/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.HTMLJavaHTMLComposer;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;

public class HTMLJavaHTMLComposerImpl
extends HTMLJavaHTMLComposer {
    private final HTMLComposerImpl myComposer;

    public HTMLJavaHTMLComposerImpl(HTMLComposerImpl composer) {
        this.myComposer = composer;
    }

    public void appendClassOrInterface(StringBuffer buf, RefClass refClass, boolean capitalizeFirstLetter) {
        if (refClass.isInterface()) {
            buf.append(capitalizeFirstLetter ? InspectionsBundle.message((String)"inspection.export.results.capitalized.interface", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.export.results.interface", (Object[])new Object[0]));
        } else if (refClass.isAbstract()) {
            buf.append(capitalizeFirstLetter ? InspectionsBundle.message((String)"inspection.export.results.capitalized.abstract.class", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.export.results.abstract.class", (Object[])new Object[0]));
        } else {
            buf.append(capitalizeFirstLetter ? InspectionsBundle.message((String)"inspection.export.results.capitalized.class", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.export.results.class", (Object[])new Object[0]));
        }
    }

    public void appendClassExtendsImplements(StringBuffer buf, RefClass refClass) {
        if (refClass.getBaseClasses().size() > 0) {
            HTMLComposerImpl.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.export.results.extends.implements", (Object[])new Object[0]));
            this.myComposer.startList(buf);
            for (RefClass refBase : refClass.getBaseClasses()) {
                this.myComposer.appendListItem(buf, (RefElement)refBase);
            }
            this.myComposer.doneList(buf);
        }
    }

    public void appendDerivedClasses(StringBuffer buf, RefClass refClass) {
        if (refClass.getSubClasses().size() > 0) {
            if (refClass.isInterface()) {
                HTMLComposerImpl.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.export.results.extended.implemented", (Object[])new Object[0]));
            } else {
                HTMLComposerImpl.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.export.results.extended", (Object[])new Object[0]));
            }
            this.myComposer.startList(buf);
            for (RefClass refDerived : refClass.getSubClasses()) {
                this.myComposer.appendListItem(buf, (RefElement)refDerived);
            }
            this.myComposer.doneList(buf);
        }
    }

    public void appendLibraryMethods(StringBuffer buf, RefClass refClass) {
        if (refClass.getLibraryMethods().size() > 0) {
            HTMLComposerImpl.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.export.results.overrides.library.methods", (Object[])new Object[0]));
            this.myComposer.startList(buf);
            for (RefMethod refMethod : refClass.getLibraryMethods()) {
                this.myComposer.appendListItem(buf, (RefElement)refMethod);
            }
            this.myComposer.doneList(buf);
        }
    }

    public void appendSuperMethods(StringBuffer buf, RefMethod refMethod) {
        if (refMethod.getSuperMethods().size() > 0) {
            HTMLComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.export.results.overrides.implements", (Object[])new Object[0]));
            this.myComposer.startList(buf);
            for (RefMethod refSuper : refMethod.getSuperMethods()) {
                this.myComposer.appendListItem(buf, (RefElement)refSuper);
            }
            this.myComposer.doneList(buf);
        }
    }

    public void appendDerivedMethods(StringBuffer buf, RefMethod refMethod) {
        if (refMethod.getDerivedMethods().size() > 0) {
            HTMLComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.export.results.derived.methods", (Object[])new Object[0]));
            this.myComposer.startList(buf);
            for (RefMethod refDerived : refMethod.getDerivedMethods()) {
                this.myComposer.appendListItem(buf, (RefElement)refDerived);
            }
            this.myComposer.doneList(buf);
        }
    }

    public void appendTypeReferences(StringBuffer buf, RefClass refClass) {
        if (refClass.getInTypeReferences().size() > 0) {
            HTMLComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.export.results.type.references", (Object[])new Object[0]));
            this.myComposer.startList(buf);
            for (RefElement refElement : refClass.getInTypeReferences()) {
                this.myComposer.appendListItem(buf, refElement);
            }
            this.myComposer.doneList(buf);
        }
    }

    public void appendShortName(RefEntity refElement, final StringBuffer buf) {
        String modifier;
        if (refElement instanceof RefJavaElement && (modifier = ((RefJavaElement)refElement).getAccessModifier()) != null && modifier != "packageLocal") {
            buf.append(modifier);
            buf.append("&nbsp;");
        }
        refElement.accept((RefVisitor)new RefJavaVisitor(){

            public void visitClass(@NotNull RefClass refClass) {
                if (refClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (refClass.isStatic()) {
                    buf.append(InspectionsBundle.message((String)"inspection.export.results.static", (Object[])new Object[0]));
                    buf.append("&nbsp;");
                }
                HTMLJavaHTMLComposerImpl.this.appendClassOrInterface(buf, refClass, false);
                buf.append("&nbsp;").append("<b>").append("<code>");
                String name = refClass.getName();
                buf.append(refClass.isSyntheticJSP() ? XmlStringUtil.escapeString((String)name) : name);
                buf.append("</code>").append("</b>");
            }

            public void visitField(@NotNull RefField field) {
                PsiField psiField;
                if (field == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((psiField = (PsiField)field.getUastElement().getJavaPsi()) != null) {
                    if (field.isStatic()) {
                        buf.append(InspectionsBundle.message((String)"inspection.export.results.static", (Object[])new Object[0]));
                        buf.append("&nbsp;");
                    }
                    buf.append(InspectionsBundle.message((String)"inspection.export.results.field", (Object[])new Object[0]));
                    buf.append("&nbsp;").append("<code>");
                    buf.append(XmlStringUtil.escapeString((String)psiField.getType().getPresentableText()));
                    buf.append("&nbsp;").append("<b>");
                    buf.append(psiField.getName());
                    buf.append("</b>").append("</code>");
                }
            }

            public void visitMethod(@NotNull RefMethod method) {
                PsiModifierListOwner element;
                if (method == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((element = (PsiModifierListOwner)method.getUastElement().getJavaPsi()) instanceof PsiClass) {
                    return;
                }
                PsiMethod psiMethod = (PsiMethod)element;
                if (psiMethod != null) {
                    PsiType returnType = psiMethod.getReturnType();
                    if (method.isStatic()) {
                        buf.append(InspectionsBundle.message((String)"inspection.export.results.static", (Object[])new Object[0]));
                        buf.append("&nbsp;");
                    } else if (method.isAbstract()) {
                        buf.append(InspectionsBundle.message((String)"inspection.export.results.abstract", (Object[])new Object[0]));
                        buf.append("&nbsp;");
                    }
                    buf.append(method.isConstructor() ? InspectionsBundle.message((String)"inspection.export.results.constructor", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.export.results.method", (Object[])new Object[0]));
                    buf.append("&nbsp;").append("<code>");
                    if (returnType != null) {
                        buf.append(XmlStringUtil.escapeString((String)returnType.getPresentableText()));
                        buf.append("&nbsp;");
                    }
                    buf.append("<b>");
                    buf.append(psiMethod.getName());
                    buf.append("</b>");
                    HTMLJavaHTMLComposerImpl.appendMethodParameters(buf, psiMethod, true);
                    buf.append("</code>");
                }
            }

            public void visitFile(@NotNull RefFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(3);
                }
                PsiFile psiFile = file.getPsiElement();
                buf.append("<b>");
                buf.append(psiFile.getName());
                buf.append("</b>");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refClass";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/ex/HTMLJavaHTMLComposerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void appendLocation(RefEntity entity, StringBuffer buf) {
        RefEntity owner = entity.getOwner();
        if (owner instanceof RefPackage) {
            buf.append(InspectionsBundle.message((String)"inspection.export.results.package", (Object[])new Object[0]));
            buf.append("&nbsp;").append("<code>");
            buf.append(RefJavaUtil.getInstance().getPackageName(entity));
            buf.append("</code>");
        } else if (owner instanceof RefMethod) {
            buf.append(InspectionsBundle.message((String)"inspection.export.results.method", (Object[])new Object[0]));
            buf.append("&nbsp;");
            this.myComposer.appendElementReference(buf, (RefElement)owner);
        } else if (owner instanceof RefField) {
            buf.append(InspectionsBundle.message((String)"inspection.export.results.field", (Object[])new Object[0]));
            buf.append("&nbsp;");
            this.myComposer.appendElementReference(buf, (RefElement)owner);
            buf.append("&nbsp;");
            buf.append(InspectionsBundle.message((String)"inspection.export.results.initializer", (Object[])new Object[0]));
        } else if (owner instanceof RefClass) {
            this.appendClassOrInterface(buf, (RefClass)owner, false);
            buf.append("&nbsp;");
            this.myComposer.appendElementReference(buf, (RefElement)owner);
        }
    }

    @Nullable
    public String getQualifiedName(RefEntity refEntity) {
        if (refEntity instanceof RefJavaElement && ((RefJavaElement)refEntity).isSyntheticJSP()) {
            return XmlStringUtil.escapeString((String)refEntity.getName());
        }
        if (refEntity instanceof RefMethod) {
            UMethod uMethod = (UMethod)((RefMethod)refEntity).getUastElement();
            if (uMethod != null) {
                return uMethod.getName();
            }
            return refEntity.getName();
        }
        return null;
    }

    public void appendReferencePresentation(RefEntity refElement, StringBuffer buf, boolean isPackageIncluded) {
        UMethod psiMethod;
        RefMethod method;
        UMethod psiMethod2;
        PsiType returnType;
        if (refElement instanceof RefImplicitConstructor) {
            buf.append(InspectionsBundle.message((String)"inspection.export.results.implicit.constructor", (Object[])new Object[0]));
            buf.append("&nbsp;");
            refElement = ((RefImplicitConstructor)refElement).getOwnerClass();
        }
        buf.append("<code>");
        if (refElement instanceof RefField) {
            RefField field = (RefField)refElement;
            UField psiField = field.getUastElement();
            buf.append(XmlStringUtil.escapeString((String)psiField.getType().getPresentableText()));
            buf.append("&nbsp;");
        } else if (refElement instanceof RefMethod && (returnType = (psiMethod2 = (UMethod)(method = (RefMethod)refElement).getUastElement()).getReturnType()) != null) {
            buf.append(XmlStringUtil.escapeString((String)returnType.getPresentableText()));
            buf.append("&nbsp;");
        }
        buf.append("<a HREF=\"");
        buf.append(((RefElementImpl)refElement).getURL());
        buf.append("\"");
        if (isPackageIncluded) {
            buf.append(" qualifiedname=\"");
            buf.append(refElement.getQualifiedName());
            buf.append("\"");
        }
        buf.append(">");
        if (refElement instanceof RefClass && ((RefClass)refElement).isAnonymous()) {
            buf.append(InspectionsBundle.message((String)"inspection.reference.anonymous", (Object[])new Object[0]));
        } else if (refElement instanceof RefJavaElement && ((RefJavaElement)refElement).isSyntheticJSP()) {
            buf.append(XmlStringUtil.escapeString((String)refElement.getName()));
        } else if (refElement instanceof RefMethod) {
            psiMethod = (UMethod)((RefMethod)refElement).getUastElement();
            buf.append(psiMethod.getName());
        } else {
            buf.append(refElement.getName());
        }
        buf.append("</a>");
        if (refElement instanceof RefMethod) {
            psiMethod = (UMethod)((RefMethod)refElement).getUastElement();
            HTMLJavaHTMLComposerImpl.appendMethodParameters(buf, (PsiMethod)psiMethod, false);
        }
        buf.append("</code>");
        RefEntity owner = refElement.getOwner();
        if (owner != null) {
            if (refElement instanceof RefClass && ((RefClass)refElement).isAnonymous()) {
                buf.append(" ");
                buf.append(InspectionsBundle.message((String)"inspection.export.results.anonymous.ref.in.owner", (Object[])new Object[0]));
                buf.append(" ");
                this.myComposer.appendElementReference(buf, (RefElement)owner, isPackageIncluded);
            } else if (isPackageIncluded) {
                buf.append(" ").append("<code class=\"package\">").append("(");
                this.myComposer.appendQualifiedName(buf, owner);
                buf.append(")").append("</code>");
            }
        }
    }

    private static void appendMethodParameters(StringBuffer buf, PsiMethod method, boolean showNames) {
        PsiParameter[] params = method.getParameterList().getParameters();
        buf.append('(');
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            PsiParameter param = params[i];
            buf.append(XmlStringUtil.escapeString((String)param.getType().getPresentableText()));
            if (!showNames) continue;
            buf.append(' ');
            buf.append(param.getName());
        }
        buf.append(')');
    }
}

