/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.NullableNotNullDialog;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.search.JavaNullMethodArgumentUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NullableStuffInspection
extends NullableStuffInspectionBase {
    @Override
    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter2) {
        return new NavigateToNullLiteralArguments(parameter2);
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    public static class NavigateToNullLiteralArguments
    extends LocalQuickFixOnPsiElement {
        public NavigateToNullLiteralArguments(@NotNull PsiParameter element) {
            if (element == null) {
                NavigateToNullLiteralArguments.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                NavigateToNullLiteralArguments.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"nullable.stuff.inspection.navigate.null.argument.usages.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                NavigateToNullLiteralArguments.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiParameter p;
            PsiMethod method;
            if (project == null) {
                NavigateToNullLiteralArguments.$$$reportNull$$$0(3);
            }
            if (file == null) {
                NavigateToNullLiteralArguments.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                NavigateToNullLiteralArguments.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                NavigateToNullLiteralArguments.$$$reportNull$$$0(6);
            }
            if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(p = (PsiParameter)startElement), PsiMethod.class)) == null) {
                return;
            }
            final int parameterIdx = ArrayUtil.find((Object[])method.getParameterList().getParameters(), (Object)p);
            if (parameterIdx < 0) {
                return;
            }
            UsageViewPresentation presentation = new UsageViewPresentation();
            String title = InspectionsBundle.message((String)"nullable.stuff.inspection.navigate.null.argument.usages.view.name", (Object[])new Object[]{p.getName()});
            presentation.setUsagesString(title);
            presentation.setTabName(title);
            presentation.setTabText(title);
            UsageViewManager.getInstance((Project)project).searchAndShowUsages(new UsageTarget[]{new PsiElement2UsageTargetAdapter((PsiElement)method.getParameterList().getParameters()[parameterIdx])}, () -> new UsageSearcher(){

                public void generate(@NotNull Processor<Usage> processor) {
                    if (processor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ReadAction.run(() -> {
                        if (processor == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        JavaNullMethodArgumentUtil.searchNullArgument(method, parameterIdx, (Processor<? super PsiExpression>)((Processor)arg -> {
                            if (processor == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return processor.process((Object)new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)arg)));
                        }));
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "processor";
                    objectArray2[1] = "com/intellij/codeInspection/nullable/NullableStuffInspection$NavigateToNullLiteralArguments$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "generate";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$generate$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$null$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, false, false, presentation, null);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/nullable/NullableStuffInspection$NavigateToNullLiteralArguments";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/nullable/NullableStuffInspection$NavigateToNullLiteralArguments";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class OptionsPanel
    extends JPanel {
        private JCheckBox myBreakingOverriding;
        private JCheckBox myNAMethodOverridesNN;
        private JPanel myPanel;
        private JCheckBox myReportNotAnnotatedGetter;
        private JButton myConfigureAnnotationsButton;
        private JCheckBox myIgnoreExternalSuperNotNull;
        private JCheckBox myNNParameterOverridesNA;
        private JCheckBox myRequireNNFieldsInitialized;
        private JBCheckBox myReportNullLiteralsPassedNotNullParameter;

        private OptionsPanel() {
            super(new BorderLayout());
            this.$$$setupUI$$$();
            this.add((Component)this.myPanel, "Center");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsPanel.this.apply();
                }
            };
            this.myNAMethodOverridesNN.addActionListener(actionListener);
            this.myBreakingOverriding.addActionListener(actionListener);
            this.myNNParameterOverridesNA.addActionListener(actionListener);
            this.myReportNotAnnotatedGetter.addActionListener(actionListener);
            this.myIgnoreExternalSuperNotNull.addActionListener(actionListener);
            this.myRequireNNFieldsInitialized.addActionListener(actionListener);
            this.myReportNullLiteralsPassedNotNullParameter.addActionListener(actionListener);
            this.myConfigureAnnotationsButton.addActionListener(NullableNotNullDialog.createActionListener((Component)this));
            this.reset();
        }

        private void reset() {
            this.myBreakingOverriding.setSelected(NullableStuffInspection.this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE);
            this.myNAMethodOverridesNN.setSelected(NullableStuffInspection.this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL);
            this.myReportNotAnnotatedGetter.setSelected(NullableStuffInspection.this.REPORT_NOT_ANNOTATED_GETTER);
            this.myIgnoreExternalSuperNotNull.setSelected(NullableStuffInspection.this.IGNORE_EXTERNAL_SUPER_NOTNULL);
            this.myNNParameterOverridesNA.setSelected(NullableStuffInspection.this.REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED);
            this.myRequireNNFieldsInitialized.setSelected(NullableStuffInspection.this.REQUIRE_NOTNULL_FIELDS_INITIALIZED);
            this.myReportNullLiteralsPassedNotNullParameter.setSelected(NullableStuffInspection.this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER);
            this.myIgnoreExternalSuperNotNull.setEnabled(this.myNAMethodOverridesNN.isSelected());
        }

        private void apply() {
            NullableStuffInspection.this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL = this.myNAMethodOverridesNN.isSelected();
            NullableStuffInspection.this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE = this.myBreakingOverriding.isSelected();
            NullableStuffInspection.this.REPORT_NOT_ANNOTATED_GETTER = this.myReportNotAnnotatedGetter.isSelected();
            NullableStuffInspection.this.IGNORE_EXTERNAL_SUPER_NOTNULL = this.myIgnoreExternalSuperNotNull.isSelected();
            NullableStuffInspection.this.REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED = this.myNNParameterOverridesNA.isSelected();
            NullableStuffInspection.this.REQUIRE_NOTNULL_FIELDS_INITIALIZED = this.myRequireNNFieldsInitialized.isSelected();
            NullableStuffInspection.this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = this.myReportNullLiteralsPassedNotNullParameter.isSelected();
            NullableStuffInspection.this.REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS = NullableStuffInspection.this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL;
            this.myIgnoreExternalSuperNotNull.setEnabled(this.myNAMethodOverridesNN.isSelected());
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JButton jButton;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myReportNotAnnotatedGetter = jCheckBox6 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.nullable.problems.not.annotated.getters.for.annotated.fields"));
            jPanel.add((Component)jCheckBox6, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myBreakingOverriding = jCheckBox5 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.nullable.problems.method.overrides.notnull.option"));
            jPanel.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myNAMethodOverridesNN = jCheckBox4 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.nullable.problems.method.overrides.option"));
            jPanel.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myConfigureAnnotationsButton = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/InspectionsBundle").getString("configure.annotations.option"));
            jPanel.add((Component)jButton, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myIgnoreExternalSuperNotNull = jCheckBox3 = new JCheckBox();
            jCheckBox3.setText("Ignore external @NotNull");
            jCheckBox3.setMnemonic('I');
            jCheckBox3.setDisplayedMnemonicIndex(0);
            jPanel.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
            this.myNNParameterOverridesNA = jCheckBox2 = new JCheckBox();
            jCheckBox2.setText("Report @NotNull parameters overriding non-annotated");
            jCheckBox2.setMnemonic('P');
            jCheckBox2.setDisplayedMnemonicIndex(16);
            jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myRequireNNFieldsInitialized = jCheckBox = new JCheckBox();
            jCheckBox.setText("Require @NotNull fields to be initialized explicitly");
            jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myReportNullLiteralsPassedNotNullParameter = jBCheckBox = new JBCheckBox();
            jBCheckBox.setText("Report @NotNull parameters with null-literal argument usages");
            jPanel.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

