/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;

interface ConditionalExpression {
    public String getType();

    public String getCondition();

    public String getTrueBranch();

    public String getFalseBranch();

    default public String asExpression() {
        return this.getCondition() + "?" + this.getTrueBranch() + ":" + this.getFalseBranch();
    }

    public static class Optional
    implements ConditionalExpression {
        private final PsiType myType;
        private final String myCondition;
        private final String myPresentExpression;
        private final String myTypeArgument;

        Optional(PsiType type2, String condition2, String presentExpression) {
            this.myType = type2;
            this.myCondition = condition2;
            this.myPresentExpression = presentExpression;
            this.myTypeArgument = type2 instanceof PsiPrimitiveType ? "" : "<" + type2.getCanonicalText() + ">";
        }

        @Override
        public String getType() {
            return OptionalUtil.getOptionalClass(this.myType.getCanonicalText()) + this.myTypeArgument;
        }

        @Override
        public String getCondition() {
            return this.myCondition;
        }

        @Override
        public String getTrueBranch() {
            return OptionalUtil.getOptionalClass(this.myType.getCanonicalText()) + "." + this.myTypeArgument + "of(" + this.myPresentExpression + ")";
        }

        @Override
        public String getFalseBranch() {
            return OptionalUtil.getOptionalClass(this.myType.getCanonicalText()) + "." + this.myTypeArgument + "empty()";
        }

        public Plain unwrap(String absentExpression) {
            return new Plain(this.myType, this.myCondition, this.myPresentExpression, absentExpression);
        }
    }

    public static class Boolean
    implements ConditionalExpression {
        private final String myCondition;
        private final boolean myInvert;

        public Boolean(String condition2, boolean invert) {
            this.myCondition = condition2;
            this.myInvert = invert;
        }

        @Override
        public String getType() {
            return "boolean";
        }

        @Override
        public String getCondition() {
            return this.myCondition;
        }

        @Override
        public String getTrueBranch() {
            return String.valueOf(!this.myInvert);
        }

        @Override
        public String getFalseBranch() {
            return String.valueOf(this.myInvert);
        }

        public Boolean negate() {
            return new Boolean(this.myCondition, !this.myInvert);
        }

        public boolean isInverted() {
            return this.myInvert;
        }

        public Plain toPlain(PsiType type2, String trueBranch, String falseBranch) {
            return this.myInvert ? new Plain(type2, this.myCondition, falseBranch, trueBranch) : new Plain(type2, this.myCondition, trueBranch, falseBranch);
        }

        @Override
        public String asExpression() {
            return this.myInvert ? this.myCondition : "!(" + this.myCondition + ")";
        }
    }

    public static class Plain
    implements ConditionalExpression {
        private final PsiType myType;
        private final String myCondition;
        private final String myTrueBranch;
        private final String myFalseBranch;

        public Plain(PsiType type2, String condition2, String trueBranch, String falseBranch) {
            this.myType = type2;
            this.myCondition = condition2;
            this.myTrueBranch = trueBranch;
            this.myFalseBranch = falseBranch;
        }

        @Override
        public String getType() {
            return this.myType.getCanonicalText();
        }

        @Override
        public String getCondition() {
            return this.myCondition;
        }

        @Override
        public String getTrueBranch() {
            return this.myTrueBranch;
        }

        @Override
        public String getFalseBranch() {
            return this.myFalseBranch;
        }
    }
}

