/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaFormatterUtil {
    private static final Set<IElementType> ASSIGNMENT_ELEMENT_TYPES = new HashSet<IElementType>(Arrays.asList(JavaElementType.ASSIGNMENT_EXPRESSION, JavaElementType.LOCAL_VARIABLE, JavaElementType.FIELD));

    private JavaFormatterUtil() {
    }

    public static boolean isAssignment(ASTNode node) {
        return ASSIGNMENT_ELEMENT_TYPES.contains(node.getElementType());
    }

    public static boolean areSamePriorityBinaryExpressions(ASTNode node1, ASTNode node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        if (!(node1 instanceof PsiPolyadicExpression) || !(node2 instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression1 = (PsiPolyadicExpression)node1;
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)node2;
        return expression1.getOperationTokenType() == expression2.getOperationTokenType();
    }

    @NotNull
    public static WrapType getWrapType(int wrap) {
        switch (wrap) {
            case 2: {
                WrapType wrapType = WrapType.ALWAYS;
                if (wrapType == null) {
                    JavaFormatterUtil.$$$reportNull$$$0(0);
                }
                return wrapType;
            }
            case 1: {
                WrapType wrapType = WrapType.NORMAL;
                if (wrapType == null) {
                    JavaFormatterUtil.$$$reportNull$$$0(1);
                }
                return wrapType;
            }
            case 0: {
                WrapType wrapType = WrapType.NONE;
                if (wrapType == null) {
                    JavaFormatterUtil.$$$reportNull$$$0(2);
                }
                return wrapType;
            }
        }
        WrapType wrapType = WrapType.CHOP_DOWN_IF_LONG;
        if (wrapType == null) {
            JavaFormatterUtil.$$$reportNull$$$0(3);
        }
        return wrapType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/JavaFormatterUtil", "getWrapType"));
    }
}

