/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.jsp.JavaJspRecursiveElementVisitor;
import com.intellij.psi.jsp.JspFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class BraceEnforcer
extends JavaJspRecursiveElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.BraceEnforcer");
    private final PostFormatProcessorHelper myPostProcessor;

    public BraceEnforcer(CodeStyleSettings settings) {
        this.myPostProcessor = new PostFormatProcessorHelper(settings.getCommonSettings((Language)JavaLanguage.INSTANCE));
    }

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        this.visitElement((PsiElement)expression2);
    }

    public void visitIfStatement(PsiIfStatement statement) {
        if (this.checkElementContainsRange((PsiElement)statement)) {
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)statement.getProject()).createSmartPsiElementPointer((PsiElement)statement);
            super.visitIfStatement(statement);
            statement = (PsiIfStatement)pointer.getElement();
            if (statement == null) {
                return;
            }
            this.processStatement((PsiStatement)statement, statement.getThenBranch(), this.myPostProcessor.getSettings().IF_BRACE_FORCE);
            PsiStatement elseBranch = statement.getElseBranch();
            if (!(elseBranch instanceof PsiIfStatement) || !this.myPostProcessor.getSettings().SPECIAL_ELSE_IF_TREATMENT) {
                this.processStatement((PsiStatement)statement, elseBranch, this.myPostProcessor.getSettings().IF_BRACE_FORCE);
            }
        }
    }

    public void visitForStatement(PsiForStatement statement) {
        if (this.checkElementContainsRange((PsiElement)statement)) {
            super.visitForStatement(statement);
            this.processStatement((PsiStatement)statement, statement.getBody(), this.myPostProcessor.getSettings().FOR_BRACE_FORCE);
        }
    }

    public void visitForeachStatement(PsiForeachStatement statement) {
        if (this.checkElementContainsRange((PsiElement)statement)) {
            super.visitForeachStatement(statement);
            this.processStatement((PsiStatement)statement, statement.getBody(), this.myPostProcessor.getSettings().FOR_BRACE_FORCE);
        }
    }

    public void visitWhileStatement(PsiWhileStatement statement) {
        if (this.checkElementContainsRange((PsiElement)statement)) {
            super.visitWhileStatement(statement);
            this.processStatement((PsiStatement)statement, statement.getBody(), this.myPostProcessor.getSettings().WHILE_BRACE_FORCE);
        }
    }

    public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        if (this.checkElementContainsRange((PsiElement)statement)) {
            super.visitDoWhileStatement(statement);
            this.processStatement((PsiStatement)statement, statement.getBody(), this.myPostProcessor.getSettings().DOWHILE_BRACE_FORCE);
        }
    }

    public void visitJspFile(JspFile file) {
        PsiClass javaRoot = file.getJavaClass();
        if (javaRoot != null) {
            javaRoot.accept((PsiElementVisitor)this);
        }
    }

    private void processStatement(PsiStatement statement, PsiStatement blockCandidate, int options) {
        if (blockCandidate instanceof PsiBlockStatement || blockCandidate == null) {
            return;
        }
        if (options == 3 || options == 1 && PostFormatProcessorHelper.isMultiline((PsiElement)statement)) {
            this.replaceWithBlock(statement, blockCandidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceWithBlock(@NotNull PsiStatement statement, PsiStatement blockCandidate) {
        if (statement == null) {
            BraceEnforcer.$$$reportNull$$$0(0);
        }
        if (!statement.isValid()) {
            LOG.assertTrue(false);
        }
        if (!this.checkRangeContainsElement((PsiElement)blockCandidate)) {
            return;
        }
        PsiManager manager = statement.getManager();
        LOG.assertTrue(manager != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        String oldText = blockCandidate.getText();
        int lastLineFeedIndex = oldText.lastIndexOf("\n");
        lastLineFeedIndex = Math.max(0, lastLineFeedIndex);
        int lastLineCommentIndex = oldText.indexOf("//", lastLineFeedIndex);
        StringBuilder buf = new StringBuilder(oldText.length() + 5);
        buf.append("{ ").append(oldText);
        if (lastLineCommentIndex >= 0) {
            buf.append("\n");
        }
        buf.append(" }");
        int oldTextLength = statement.getTextLength();
        try {
            CodeEditUtil.replaceChild((ASTNode)SourceTreeToPsiMap.psiElementToTree((PsiElement)statement), (ASTNode)SourceTreeToPsiMap.psiElementToTree((PsiElement)blockCandidate), (ASTNode)SourceTreeToPsiMap.psiElementToTree((PsiElement)factory.createStatementFromText(buf.toString(), null)));
            CodeStyleManager.getInstance((Project)statement.getProject()).reformat((PsiElement)statement, true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.updateResultRange(oldTextLength, statement.getTextLength());
        }
    }

    protected void updateResultRange(int oldTextLength, int newTextLength) {
        this.myPostProcessor.updateResultRange(oldTextLength, newTextLength);
    }

    protected boolean checkElementContainsRange(PsiElement element) {
        return this.myPostProcessor.isElementPartlyInRange(element);
    }

    protected boolean checkRangeContainsElement(PsiElement element) {
        return this.myPostProcessor.isElementFullyInRange(element);
    }

    public PsiElement process(PsiElement formatted) {
        LOG.assertTrue(formatted.isValid());
        formatted.accept((PsiElementVisitor)this);
        return formatted;
    }

    public TextRange processText(PsiFile source, TextRange rangeToReformat) {
        this.myPostProcessor.setResultTextRange(rangeToReformat);
        source.accept((PsiElementVisitor)this);
        return this.myPostProcessor.getResultTextRange();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/impl/source/codeStyle/BraceEnforcer", "replaceWithBlock"));
    }
}

