/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDClassComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDMethodComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDParamListOwnerComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDParser {
    private static final String JAVADOC_HEADER = "/**";
    private static final String PRE_TAG_START = "<pre>";
    private static final String PRE_TAG_END = "</pre>";
    private static final String P_END_TAG = "</p>";
    private static final String P_START_TAG = "<p>";
    private static final String SELF_CLOSED_P_TAG = "<p/>";
    private final JavaCodeStyleSettings mySettings;
    private final CommonCodeStyleSettings myCommonSettings;
    private static final String HTML_TAG_REGEXP = "\\s*</?\\w+\\s*(\\w+\\s*=.*)?>.*";
    private static final String PRE_TAG_START_REGEXP = "<pre\\s*(\\w+\\s*=.*)?>";
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("\\s*</?\\w+\\s*(\\w+\\s*=.*)?>.*");
    private static final Pattern PRE_TAG_START_PATTERN = Pattern.compile("<pre\\s*(\\w+\\s*=.*)?>");
    private static final TagParser[] tagParsers = new TagParser[]{(tag, line, c) -> {
        boolean isMyTag = JDTag.SEE.tagEqual(tag);
        if (isMyTag) {
            c.addSeeAlso(line);
        }
        return isMyTag;
    }, (tag, line, c) -> {
        boolean isMyTag = JDTag.SINCE.tagEqual(tag);
        if (isMyTag) {
            c.addSince(line);
        }
        return isMyTag;
    }, (tag, line, c) -> {
        boolean isMyTag;
        boolean bl = isMyTag = c instanceof JDClassComment && JDTag.VERSION.tagEqual(tag);
        if (isMyTag) {
            ((JDClassComment)c).setVersion(line);
        }
        return isMyTag;
    }, (tag, line, c) -> {
        boolean isMyTag = JDTag.DEPRECATED.tagEqual(tag);
        if (isMyTag) {
            c.setDeprecated(line);
        }
        return isMyTag;
    }, (tag, line, c) -> {
        boolean isMyTag;
        boolean bl = isMyTag = c instanceof JDMethodComment && JDTag.RETURN.tagEqual(tag);
        if (isMyTag) {
            ((JDMethodComment)c).setReturnTag(line);
        }
        return isMyTag;
    }, (tag, line, c) -> {
        boolean isMyTag;
        boolean bl = isMyTag = c instanceof JDParamListOwnerComment && JDTag.PARAM.tagEqual(tag);
        if (isMyTag) {
            char ch;
            int idx;
            JDParamListOwnerComment mc = (JDParamListOwnerComment)c;
            for (idx = 0; idx < line.length() && !Character.isWhitespace(ch = line.charAt(idx)); ++idx) {
            }
            if (idx == line.length()) {
                mc.addParameter(line, "");
            } else {
                String name = line.substring(0, idx);
                String desc = line.substring(idx).trim();
                mc.addParameter(name, desc);
            }
        }
        return isMyTag;
    }, (tag, line, c) -> {
        boolean isMyTag;
        boolean bl = isMyTag = c instanceof JDMethodComment && (JDTag.THROWS.tagEqual(tag) || JDTag.EXCEPTION.tagEqual(tag));
        if (isMyTag) {
            char ch;
            int idx;
            JDMethodComment mc = (JDMethodComment)c;
            for (idx = 0; idx < line.length() && !Character.isWhitespace(ch = line.charAt(idx)); ++idx) {
            }
            if (idx == line.length()) {
                mc.addThrow(line, "");
            } else {
                String name = line.substring(0, idx);
                String desc = line.substring(idx).trim();
                mc.addThrow(name, desc);
            }
        }
        return isMyTag;
    }, (tag, line, c) -> {
        boolean isMyTag;
        boolean bl = isMyTag = c instanceof JDClassComment && JDTag.AUTHOR.tagEqual(tag);
        if (isMyTag) {
            ((JDClassComment)c).addAuthor(line.trim());
        }
        return isMyTag;
    }};

    public JDParser(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            JDParser.$$$reportNull$$$0(0);
        }
        this.mySettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        this.myCommonSettings = settings.getCommonSettings((Language)JavaLanguage.INSTANCE);
    }

    public void formatCommentText(@NotNull PsiElement element, @NotNull CommentFormatter formatter) {
        CommentInfo info;
        if (element == null) {
            JDParser.$$$reportNull$$$0(1);
        }
        if (formatter == null) {
            JDParser.$$$reportNull$$$0(2);
        }
        if ((info = JDParser.getElementsCommentInfo(element)) == null || !JDParser.isJavadoc(info)) {
            return;
        }
        JDComment comment = this.parse(info, formatter);
        if (comment != null) {
            String indent = formatter.getIndent(info.commentOwner);
            String commentText = comment.generate(indent);
            formatter.replaceCommentText(commentText, info.docComment);
        }
    }

    private static boolean isJavadoc(CommentInfo info) {
        return JAVADOC_HEADER.equals(info.commentHeader);
    }

    private static CommentInfo getElementsCommentInfo(@Nullable PsiElement psiElement) {
        PsiJavaDocumentedElement owner;
        PsiDocComment docComment;
        if (psiElement instanceof PsiDocComment) {
            PsiDocComment docComment2 = (PsiDocComment)psiElement;
            PsiJavaDocumentedElement owner2 = docComment2.getOwner();
            if (owner2 != null) {
                return JDParser.getCommentInfo(docComment2, (PsiElement)owner2);
            }
            PsiElement parent = docComment2.getParent();
            if (parent instanceof PsiJavaFile) {
                return JDParser.getCommentInfo(docComment2, parent);
            }
        } else if (psiElement instanceof PsiJavaDocumentedElement && (docComment = (owner = (PsiJavaDocumentedElement)psiElement).getDocComment()) != null) {
            return JDParser.getCommentInfo(docComment, (PsiElement)owner);
        }
        return null;
    }

    private static CommentInfo getCommentInfo(@NotNull PsiDocComment docComment, @NotNull PsiElement owner) {
        if (docComment == null) {
            JDParser.$$$reportNull$$$0(3);
        }
        if (owner == null) {
            JDParser.$$$reportNull$$$0(4);
        }
        String commentHeader = null;
        String commentFooter = null;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        PsiDocComment e = docComment;
        while (true) {
            if (e instanceof PsiDocComment) {
                PsiComment cm = (PsiComment)e;
                String text2 = cm.getText();
                if (text2.startsWith("//")) {
                    if (!first) {
                        sb.append('\n');
                    }
                    sb.append(text2.substring(2).trim());
                } else if (text2.startsWith("/*")) {
                    int commentFooterStartOffset;
                    int commentHeaderEndOffset = CharArrayUtil.shiftForward((CharSequence)text2, (int)1, (String)"*");
                    if (commentHeaderEndOffset <= (commentFooterStartOffset = CharArrayUtil.shiftBackward((CharSequence)text2, (int)(text2.length() - 2), (String)"*"))) {
                        commentHeader = text2.substring(0, commentHeaderEndOffset);
                        commentFooter = text2.substring(commentFooterStartOffset + 1);
                        text2 = text2.substring(commentHeaderEndOffset, commentFooterStartOffset + 1);
                    } else {
                        commentHeader = text2.substring(0, commentHeaderEndOffset);
                        text2 = "";
                        commentFooter = "";
                    }
                    sb.append(text2);
                }
            } else if (!(e instanceof PsiWhiteSpace) && !(e instanceof PsiComment)) break;
            first = false;
            e = e.getNextSibling();
        }
        return new CommentInfo(docComment, owner, commentHeader, sb.toString(), commentFooter);
    }

    private JDComment parse(@NotNull CommentInfo info, @NotNull CommentFormatter formatter) {
        if (info == null) {
            JDParser.$$$reportNull$$$0(5);
        }
        if (formatter == null) {
            JDParser.$$$reportNull$$$0(6);
        }
        JDComment comment = JDParser.createComment(info.commentOwner, formatter);
        this.parse(info.comment, comment);
        if (info.commentHeader != null) {
            comment.setFirstCommentLine(info.commentHeader);
        }
        if (info.commentFooter != null) {
            comment.setLastCommentLine(info.commentFooter);
        }
        return comment;
    }

    private static JDComment createComment(@NotNull PsiElement commentOwner, @NotNull CommentFormatter formatter) {
        if (commentOwner == null) {
            JDParser.$$$reportNull$$$0(7);
        }
        if (formatter == null) {
            JDParser.$$$reportNull$$$0(8);
        }
        if (commentOwner instanceof PsiClass) {
            return new JDClassComment(formatter);
        }
        if (commentOwner instanceof PsiMethod) {
            return new JDMethodComment(formatter);
        }
        return new JDComment(formatter);
    }

    private void parse(@Nullable String text2, @NotNull JDComment comment) {
        if (comment == null) {
            JDParser.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            return;
        }
        ArrayList<Boolean> markers = new ArrayList<Boolean>();
        List<String> l = this.toArray(text2, markers);
        if (text2.indexOf(10) >= 0) {
            comment.setMultiLine(true);
        }
        if (l == null) {
            return;
        }
        int size = l.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            String line = l.get(i);
            if (!(line = line.trim()).isEmpty() && line.charAt(0) == '*') {
                line = ((Boolean)markers.get(i)).booleanValue() ? (line.length() > 1 && line.charAt(1) == ' ' ? line.substring(2) : line.substring(1)) : line.substring(1).trim();
            }
            l.set(i, line);
        }
        StringBuilder sb = new StringBuilder();
        String tag = null;
        boolean isInsidePreTag = false;
        for (int i = 0; i <= size; ++i) {
            String line;
            String string = line = i == size ? null : l.get(i);
            if (i == size || !line.isEmpty()) {
                if (i == size || line.charAt(0) == '@' && !isInsidePreTag) {
                    if (tag == null) {
                        comment.setDescription(sb.toString());
                    } else {
                        TagParser parser;
                        int j;
                        String myline = sb.toString();
                        for (j = 0; j < tagParsers.length && !(parser = tagParsers[j]).parse(tag, myline, comment); ++j) {
                        }
                        if (j == tagParsers.length) {
                            comment.addUnknownTag("@" + tag + " " + myline);
                        }
                    }
                    if (i < size) {
                        int last_idx = line.indexOf(32);
                        if (last_idx == -1) {
                            tag = line.substring(1);
                            line = "";
                        } else {
                            tag = line.substring(1, last_idx);
                            line = line.substring(last_idx).trim();
                        }
                        sb.setLength(0);
                        sb.append(line);
                    }
                } else {
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append(line);
                }
            } else if (sb.length() > 0) {
                sb.append('\n');
            }
            if (line == null) continue;
            isInsidePreTag = isInsidePreTag ? !JDParser.lineHasClosingPreTag(line) : JDParser.lineHasUnclosedPreTag(line);
        }
    }

    @Nullable
    private List<String> toArray(@Nullable String s, @Nullable List<Boolean> markers) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        boolean p2nl = markers != null && this.mySettings.JD_P_AT_EMPTY_LINES;
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, "\n", true);
        boolean first = true;
        int preCount = 0;
        int curPos = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            curPos += token.length();
            if ("\n".equals(token)) {
                if (!first) {
                    list.add("");
                    if (markers != null) {
                        markers.add(preCount > 0);
                    }
                }
                first = false;
                continue;
            }
            first = true;
            if (p2nl && JDParser.isParaTag(token) && s.indexOf(P_END_TAG, curPos) < 0) {
                list.add(JDParser.isSelfClosedPTag(token) ? SELF_CLOSED_P_TAG : P_START_TAG);
                markers.add(preCount > 0);
                continue;
            }
            if (preCount == 0) {
                token = token.trim();
            }
            list.add(token);
            if (markers == null) continue;
            if (JDParser.lineHasUnclosedPreTag(token)) {
                ++preCount;
            }
            markers.add(preCount > 0);
            if (!JDParser.lineHasClosingPreTag(token)) continue;
            --preCount;
        }
        return list;
    }

    private static boolean isParaTag(String token) {
        String withoutWS = JDParser.removeWhiteSpacesFrom(token).toLowerCase(Locale.US);
        return withoutWS.equals(SELF_CLOSED_P_TAG) || withoutWS.equals(P_START_TAG);
    }

    private static boolean isSelfClosedPTag(String token) {
        return JDParser.removeWhiteSpacesFrom(token).toLowerCase(Locale.US).equals(SELF_CLOSED_P_TAG);
    }

    private static boolean hasLineLongerThan(String str, int maxLength) {
        if (str == null) {
            return false;
        }
        for (String s : str.split("\n")) {
            if (s.length() <= maxLength) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String removeWhiteSpacesFrom(@NotNull String token) {
        if (token == null) {
            JDParser.$$$reportNull$$$0(10);
        }
        StringBuilder result = new StringBuilder();
        for (char c : token.toCharArray()) {
            if (c == ' ') continue;
            result.append(c);
        }
        String string = result.toString();
        if (string == null) {
            JDParser.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    private List<String> toArrayWrapping(@Nullable String s, int width) {
        ArrayList<String> list = new ArrayList<String>();
        List<Pair<String, Boolean>> pairs = this.splitToParagraphs(s);
        if (pairs == null) {
            return null;
        }
        block0: for (Pair<String, Boolean> pair : pairs) {
            String seq = (String)pair.getFirst();
            boolean isMarked = (Boolean)pair.getSecond();
            if (seq.isEmpty()) {
                list.add("");
                continue;
            }
            while (true) {
                if (seq.length() < width || isMarked) {
                    seq = isMarked ? seq : seq.trim();
                    list.add(seq);
                    continue block0;
                }
                int wrapPos = Math.min(seq.length() - 1, width);
                if ((wrapPos = seq.lastIndexOf(32, wrapPos)) <= 2 * width / 3) {
                    wrapPos = Math.min(seq.length() - 1, width);
                    wrapPos = seq.indexOf(32, wrapPos);
                }
                if (wrapPos >= seq.length() - 1 || wrapPos < 0) {
                    seq = isMarked ? seq : seq.trim();
                    list.add(seq);
                    continue block0;
                }
                list.add(seq.substring(0, wrapPos));
                seq = seq.substring(wrapPos + 1);
            }
        }
        return list;
    }

    @Nullable
    private List<Pair<String, Boolean>> splitToParagraphs(@Nullable String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        ArrayList<Pair<String, Boolean>> result = new ArrayList<Pair<String, Boolean>>();
        StringBuilder sb = new StringBuilder();
        ArrayList<Boolean> markers = new ArrayList<Boolean>();
        List<String> list = this.toArray(s, markers);
        Boolean[] marks = markers.toArray(new Boolean[0]);
        markers.clear();
        assert (list != null);
        for (int i = 0; i < list.size(); ++i) {
            String s1 = list.get(i);
            if (marks[i].booleanValue()) {
                if (sb.length() != 0) {
                    result.add((Pair<String, Boolean>)new Pair((Object)sb.toString(), (Object)false));
                    sb.setLength(0);
                }
                result.add((Pair<String, Boolean>)Pair.create((Object)s1, (Object)marks[i]));
                continue;
            }
            if (s1.isEmpty() || s1.equals(SELF_CLOSED_P_TAG) || this.isKeepLineFeedsIn(s1)) {
                JDParser.endParagraph(result, sb);
                result.add((Pair<String, Boolean>)Pair.create((Object)s1, (Object)marks[i]));
                continue;
            }
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(s1);
        }
        if (!this.mySettings.JD_PRESERVE_LINE_FEEDS && sb.length() != 0) {
            result.add((Pair<String, Boolean>)new Pair((Object)sb.toString(), (Object)false));
        }
        return result;
    }

    private boolean isKeepLineFeedsIn(@NotNull String line) {
        if (line == null) {
            JDParser.$$$reportNull$$$0(12);
        }
        return this.mySettings.JD_PRESERVE_LINE_FEEDS || JDParser.startsWithTag(line);
    }

    private static boolean startsWithTag(@NotNull String line) {
        if (line == null) {
            JDParser.$$$reportNull$$$0(13);
        }
        if (line.trim().startsWith("<")) {
            return HTML_TAG_PATTERN.matcher(line).matches();
        }
        return false;
    }

    private static void endParagraph(@NotNull List<Pair<String, Boolean>> result, @NotNull StringBuilder sb) {
        if (result == null) {
            JDParser.$$$reportNull$$$0(14);
        }
        if (sb == null) {
            JDParser.$$$reportNull$$$0(15);
        }
        if (sb.length() > 0) {
            result.add((Pair<String, Boolean>)new Pair((Object)sb.toString(), (Object)false));
            sb.setLength(0);
        }
    }

    private static boolean lineHasUnclosedPreTag(@NotNull String line) {
        if (line == null) {
            JDParser.$$$reportNull$$$0(16);
        }
        return JDParser.getOccurenceCount(line, PRE_TAG_START_PATTERN) > StringUtil.getOccurrenceCount((String)line, (String)PRE_TAG_END);
    }

    private static boolean lineHasClosingPreTag(@NotNull String line) {
        if (line == null) {
            JDParser.$$$reportNull$$$0(17);
        }
        return StringUtil.getOccurrenceCount((String)line, (String)PRE_TAG_END) > JDParser.getOccurenceCount(line, PRE_TAG_START_PATTERN);
    }

    private static int getOccurenceCount(@NotNull String line, @NotNull Pattern pattern) {
        if (line == null) {
            JDParser.$$$reportNull$$$0(18);
        }
        if (pattern == null) {
            JDParser.$$$reportNull$$$0(19);
        }
        Matcher matcher = pattern.matcher(line);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    @NotNull
    protected StringBuilder formatJDTagDescription(@Nullable String str, @NotNull CharSequence prefix) {
        if (prefix == null) {
            JDParser.$$$reportNull$$$0(20);
        }
        StringBuilder stringBuilder = this.formatJDTagDescription(str, prefix, prefix);
        if (stringBuilder == null) {
            JDParser.$$$reportNull$$$0(21);
        }
        return stringBuilder;
    }

    @NotNull
    protected StringBuilder formatJDTagDescription(@Nullable String str, @NotNull CharSequence firstLinePrefix, @NotNull CharSequence continuationPrefix) {
        List<String> list;
        boolean canWrap;
        if (firstLinePrefix == null) {
            JDParser.$$$reportNull$$$0(22);
        }
        if (continuationPrefix == null) {
            JDParser.$$$reportNull$$$0(23);
        }
        int rightMargin = this.myCommonSettings.getRootSettings().getRightMargin((Language)JavaLanguage.INSTANCE);
        int maxCommentLength = rightMargin - continuationPrefix.length();
        int firstLinePrefixLength = firstLinePrefix.length();
        boolean firstLineShorter = firstLinePrefixLength > continuationPrefix.length();
        StringBuilder sb = new StringBuilder(firstLinePrefix);
        boolean bl = canWrap = !this.mySettings.JD_PRESERVE_LINE_FEEDS || JDParser.hasLineLongerThan(str, maxCommentLength);
        if (this.myCommonSettings.WRAP_COMMENTS && canWrap) {
            list = this.toArrayWrapping(str, maxCommentLength);
            if (firstLineShorter && list != null && !list.isEmpty() && list.get(0).length() > rightMargin - firstLinePrefixLength) {
                list = new ArrayList<String>();
                String firstLine = this.toArrayWrapping(str, rightMargin - firstLinePrefixLength).get(0);
                list.add(firstLine);
                str = str.substring(firstLine.length());
                boolean unclosedPreTag = JDParser.lineHasUnclosedPreTag(firstLine);
                if (unclosedPreTag) {
                    str = PRE_TAG_START + str.replaceAll("^\\s+", "");
                }
                List<String> subList = this.toArrayWrapping(str, maxCommentLength);
                if (unclosedPreTag && subList != null && !subList.isEmpty()) {
                    String firstLineTagRemoved = subList.get(0).substring(PRE_TAG_START.length());
                    subList.set(0, firstLineTagRemoved);
                }
                if (subList != null) {
                    list.addAll(subList);
                }
            }
        } else {
            list = this.toArray(str, new ArrayList<Boolean>());
        }
        if (list == null) {
            sb.append('\n');
        } else {
            boolean insidePreTag = false;
            for (int i = 0; i < list.size(); ++i) {
                String line = list.get(i);
                if (line.isEmpty() && !this.mySettings.JD_KEEP_EMPTY_LINES) continue;
                if (i != 0) {
                    sb.append(continuationPrefix);
                }
                if (line.isEmpty() && this.mySettings.JD_P_AT_EMPTY_LINES && !insidePreTag && !JDParser.isFollowedByTagLine(list, i)) {
                    sb.append(P_START_TAG);
                } else {
                    sb.append(line);
                    if (JDParser.lineHasUnclosedPreTag(line)) {
                        insidePreTag = true;
                    } else if (JDParser.lineHasClosingPreTag(line)) {
                        insidePreTag = false;
                    }
                }
                sb.append('\n');
            }
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            JDParser.$$$reportNull$$$0(24);
        }
        return stringBuilder;
    }

    private static boolean isFollowedByTagLine(List<String> lines, int currLine) {
        for (int i = currLine + 1; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.isEmpty()) continue;
            return JDParser.startsWithTag(line);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentOwner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 11: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser";
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstLinePrefix";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "continuationPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/javadoc/JDParser";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeWhiteSpacesFrom";
                break;
            }
            case 21: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "formatJDTagDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "formatCommentText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCommentInfo";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createComment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeWhiteSpacesFrom";
                break;
            }
            case 11: 
            case 21: 
            case 24: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isKeepLineFeedsIn";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "startsWithTag";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "endParagraph";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lineHasUnclosedPreTag";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lineHasClosingPreTag";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOccurenceCount";
                break;
            }
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "formatJDTagDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CommentInfo {
        public final PsiDocComment docComment;
        public final PsiElement commentOwner;
        public final String commentHeader;
        public final String comment;
        public final String commentFooter;

        CommentInfo(PsiDocComment docComment, PsiElement commentOwner, String commentHeader, String comment, String commentFooter) {
            this.docComment = docComment;
            this.commentOwner = commentOwner;
            this.commentHeader = commentHeader;
            this.comment = comment;
            this.commentFooter = commentFooter;
        }
    }

    private static interface TagParser {
        public boolean parse(String var1, String var2, JDComment var3);
    }
}

