/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackagePrefixFileSystemItemImpl;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePathReferenceProvider
extends PsiReferenceProvider {
    private final boolean myEndingSlashNotAllowed;

    public FilePathReferenceProvider() {
        this(true);
    }

    public FilePathReferenceProvider(boolean endingSlashNotAllowed) {
        this.myEndingSlashNotAllowed = endingSlashNotAllowed;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, String text2, int offset, boolean soft) {
        if (element == null) {
            FilePathReferenceProvider.$$$reportNull$$$0(0);
        }
        PsiReference[] psiReferenceArray = this.getReferencesByElement(element, text2, offset, soft, Module.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            FilePathReferenceProvider.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, String text2, int offset, final boolean soft, final Module ... forModules) {
        if (element == null) {
            FilePathReferenceProvider.$$$reportNull$$$0(2);
        }
        if (forModules == null) {
            FilePathReferenceProvider.$$$reportNull$$$0(3);
        }
        FileReference[] fileReferenceArray = new FileReferenceSet(text2, element, offset, this, true, this.myEndingSlashNotAllowed){

            protected boolean isSoft() {
                return soft;
            }

            public boolean isAbsolutePathReference() {
                return true;
            }

            public boolean couldBeConvertedTo(boolean relative) {
                return !relative;
            }

            public boolean absoluteUrlNeedsStartSlash() {
                String s = this.getPathString();
                return s != null && !s.isEmpty() && s.charAt(0) == '/';
            }

            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                if (forModules.length > 0) {
                    LinkedHashSet rootsForModules = ContainerUtil.newLinkedHashSet();
                    for (Module forModule : forModules) {
                        rootsForModules.addAll(FilePathReferenceProvider.getRoots(forModule, true));
                    }
                    LinkedHashSet linkedHashSet = rootsForModules;
                    if (linkedHashSet == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return linkedHashSet;
                }
                Collection<PsiFileSystemItem> collection = FilePathReferenceProvider.getRoots(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()), true);
                if (collection == null) {
                    1.$$$reportNull$$$0(1);
                }
                return collection;
            }

            public FileReference createFileReference(TextRange range, int index, String text2) {
                return FilePathReferenceProvider.this.createFileReference(this, range, index, text2);
            }

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return element1 -> FilePathReferenceProvider.this.isPsiElementAccepted((PsiElement)element1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider$1", "computeDefaultContexts"));
            }
        }.getAllReferences();
        if (fileReferenceArray == null) {
            FilePathReferenceProvider.$$$reportNull$$$0(4);
        }
        return fileReferenceArray;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            FilePathReferenceProvider.$$$reportNull$$$0(5);
        }
        return target instanceof PsiFileSystemItem;
    }

    protected boolean isPsiElementAccepted(PsiElement element) {
        return !(element instanceof PsiJavaFile) || !(element instanceof PsiCompiledElement);
    }

    protected FileReference createFileReference(FileReferenceSet referenceSet, TextRange range, int index, String text2) {
        return new FileReference(referenceSet, range, index, text2);
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Object value2;
        if (element == null) {
            FilePathReferenceProvider.$$$reportNull$$$0(6);
        }
        if (context == null) {
            FilePathReferenceProvider.$$$reportNull$$$0(7);
        }
        String text2 = null;
        if (element instanceof PsiLiteralExpression && (value2 = ((PsiLiteralExpression)element).getValue()) instanceof String) {
            text2 = (String)value2;
        }
        if (text2 == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                FilePathReferenceProvider.$$$reportNull$$$0(8);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = this.getReferencesByElement(element, text2, 1, true);
        if (psiReferenceArray == null) {
            FilePathReferenceProvider.$$$reportNull$$$0(9);
        }
        return psiReferenceArray;
    }

    @NotNull
    public static Collection<PsiFileSystemItem> getRoots(@Nullable Module thisModule, boolean includingClasses) {
        PsiDirectory directory;
        if (thisModule == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                FilePathReferenceProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)thisModule);
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        PsiManager psiManager = PsiManager.getInstance((Project)thisModule.getProject());
        if (includingClasses) {
            VirtualFile[] libraryUrls;
            for (VirtualFile file : libraryUrls = moduleRootManager.orderEntries().getAllLibrariesAndSdkClassesRoots()) {
                directory = psiManager.findDirectory(file);
                if (directory == null) continue;
                result.add(directory);
            }
        }
        VirtualFile[] sourceRoots = moduleRootManager.orderEntries().recursively().withoutSdk().withoutLibraries().sources().usingCache().getRoots();
        for (VirtualFile root : sourceRoots) {
            directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage != null && aPackage.getName() != null) {
                result.add(PackagePrefixFileSystemItemImpl.create(directory));
                continue;
            }
            result.add(directory);
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            FilePathReferenceProvider.$$$reportNull$$$0(11);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forModules";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptsTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

