/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContractConverter {
    private ContractConverter() {
    }

    @Nullable
    static PsiAnnotation convertContract(@NotNull PsiMethod method, @NotNull JavaChangeInfo info) throws ContractConversionException {
        if (method == null) {
            ContractConverter.$$$reportNull$$$0(0);
        }
        if (info == null) {
            ContractConverter.$$$reportNull$$$0(1);
        }
        return ContractConverter.convertContract(method, info.getOldParameterNames(), info.getNewParameters());
    }

    @Nullable
    public static PsiAnnotation convertContract(@NotNull PsiMethod method, @NotNull String[] oldParameterNames, @NotNull JavaParameterInfo[] newParameters) throws ContractConversionException {
        PsiAnnotation annotation;
        if (method == null) {
            ContractConverter.$$$reportNull$$$0(2);
        }
        if (oldParameterNames == null) {
            ContractConverter.$$$reportNull$$$0(3);
        }
        if (newParameters == null) {
            ContractConverter.$$$reportNull$$$0(4);
        }
        if ((annotation = JavaMethodContractUtil.findContractAnnotation(method)) == null || AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation)) {
            return null;
        }
        if (AnnotationUtil.isExternalAnnotation((PsiAnnotation)annotation)) {
            throw new ContractConversionException("automatic update of external annotation is not supported");
        }
        if (annotation.getOwner() != method.getModifierList()) {
            throw new ContractInheritedException();
        }
        if (annotation.findDeclaredAttributeValue("mutates") != null) {
            throw new ContractConversionException("it contains mutation contract");
        }
        String text2 = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, null);
        List<Object> contracts2 = Collections.emptyList();
        if (text2 != null) {
            try {
                contracts2 = StandardMethodContract.parseContract(text2);
            }
            catch (StandardMethodContract.ParseException exception) {
                throw new ContractConversionException("error in contract definition: " + exception.getMessage());
            }
        }
        int[] newToOldIndex = StreamEx.of((Object[])newParameters).mapToInt(ParameterInfo::getOldIndex).toArray();
        int[] oldToNewIndex = ContractConverter.reverseIndex(oldParameterNames.length, newToOldIndex);
        ArrayList<StandardMethodContract> result = new ArrayList<StandardMethodContract>();
        for (StandardMethodContract standardMethodContract : contracts2) {
            result.add(ContractConverter.convertContract(standardMethodContract, newToOldIndex, oldToNewIndex, oldParameterNames));
        }
        if (result.equals(contracts2)) {
            return annotation;
        }
        return JavaMethodContractUtil.updateContract(annotation, result);
    }

    @NotNull
    private static StandardMethodContract convertContract(@NotNull StandardMethodContract contract, @NotNull int[] newToOldIndex, @NotNull int[] oldToNewIndex, @NotNull String[] oldParameterNames) throws ContractConversionException {
        if (contract == null) {
            ContractConverter.$$$reportNull$$$0(5);
        }
        if (newToOldIndex == null) {
            ContractConverter.$$$reportNull$$$0(6);
        }
        if (oldToNewIndex == null) {
            ContractConverter.$$$reportNull$$$0(7);
        }
        if (oldParameterNames == null) {
            ContractConverter.$$$reportNull$$$0(8);
        }
        if (contract.getParameterCount() != oldToNewIndex.length) {
            throw new ContractConversionException("invalid contract clause '" + contract + "'");
        }
        for (int i = 0; i < contract.getParameterCount(); ++i) {
            if (contract.getParameterConstraint(i) == StandardMethodContract.ValueConstraint.ANY_VALUE || oldToNewIndex[i] != -1) continue;
            throw new ContractConversionException("parameter '" + oldParameterNames[i] + "' was deleted, but contract clause '" + contract + "' depends on it");
        }
        StandardMethodContract.ValueConstraint[] newConstraints = (StandardMethodContract.ValueConstraint[])IntStreamEx.of((int[])newToOldIndex).mapToObj(idx -> {
            if (contract == null) {
                ContractConverter.$$$reportNull$$$0(10);
            }
            return idx == -1 ? StandardMethodContract.ValueConstraint.ANY_VALUE : contract.getParameterConstraint(idx);
        }).toArray(StandardMethodContract.ValueConstraint.class);
        ContractReturnValue returnValue = contract.getReturnValue();
        if (returnValue instanceof ContractReturnValue.ParameterReturnValue) {
            int oldIndex = ((ContractReturnValue.ParameterReturnValue)returnValue).getParameterNumber();
            if (oldIndex >= contract.getParameterCount()) {
                throw new ContractConversionException("invalid reference in return value: " + returnValue);
            }
            int index = oldToNewIndex[oldIndex];
            if (index == -1) {
                throw new ContractConversionException("parameter '" + oldParameterNames[oldIndex] + "' was deleted, but contract clause '" + contract + "' returns it");
            }
            returnValue = ContractReturnValue.returnParameter(index);
        }
        StandardMethodContract standardMethodContract = new StandardMethodContract(newConstraints, returnValue);
        if (standardMethodContract == null) {
            ContractConverter.$$$reportNull$$$0(9);
        }
        return standardMethodContract;
    }

    private static int[] reverseIndex(int oldParameterCount, int[] newToOldIndex) {
        int[] oldToNewIndex = new int[oldParameterCount];
        Arrays.fill(oldToNewIndex, -1);
        for (int i = 0; i < newToOldIndex.length; ++i) {
            int oldIndex = newToOldIndex[i];
            if (oldIndex < 0 || oldIndex >= oldParameterCount) continue;
            oldToNewIndex[oldIndex] = i;
        }
        return oldToNewIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldParameterNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameters";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contract";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newToOldIndex";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldToNewIndex";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/ContractConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/ContractConverter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "convertContract";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertContract";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$convertContract$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ContractInheritedException
    extends ContractConversionException {
        ContractInheritedException() {
            super("annotation is inherited from base method");
        }
    }

    public static class ContractConversionException
    extends Exception {
        ContractConversionException(String message2) {
            super(message2);
        }
    }
}

