/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import java.util.Iterator;
import java.util.List;

public class ElementToWorkOn {
    public static final Key<PsiElement> PARENT = Key.create((String)"PARENT");
    private final PsiExpression myExpression;
    private final PsiLocalVariable myLocalVariable;
    public static final Key<String> PREFIX = Key.create((String)"prefix");
    public static final Key<String> SUFFIX = Key.create((String)"suffix");
    public static final Key<RangeMarker> TEXT_RANGE = Key.create((String)"range");
    public static final Key<TextRange> EXPR_RANGE = Key.create((String)"expr_range");
    public static final Key<Boolean> REPLACE_NON_PHYSICAL = Key.create((String)"replace_non_physical");
    public static final Key<Boolean> OUT_OF_CODE_BLOCK = Key.create((String)"out_of_code_block");

    private ElementToWorkOn(PsiLocalVariable localVariable, PsiExpression expr) {
        this.myLocalVariable = localVariable;
        this.myExpression = expr;
    }

    public static ElementToWorkOn adjustElements(PsiExpression expr, PsiElement anchorElement) {
        PsiLocalVariable localVariable = null;
        if (anchorElement instanceof PsiLocalVariable) {
            localVariable = (PsiLocalVariable)anchorElement;
        } else if (expr instanceof PsiReferenceExpression) {
            PsiElement ref = ((PsiReferenceExpression)expr).resolve();
            if (ref instanceof PsiLocalVariable) {
                localVariable = (PsiLocalVariable)ref;
            }
        } else if (expr instanceof PsiArrayInitializerExpression && expr.getParent() instanceof PsiNewExpression) {
            expr = (PsiExpression)expr.getParent();
        }
        return new ElementToWorkOn(localVariable, expr);
    }

    public PsiExpression getExpression() {
        return this.myExpression;
    }

    public PsiLocalVariable getLocalVariable() {
        return this.myLocalVariable;
    }

    public boolean isInvokedOnDeclaration() {
        return this.myExpression == null;
    }

    public static void processElementToWorkOn(final Editor editor, final PsiFile file, final String refactoringName, final String helpId, final Project project, final ElementsProcessor<? super ElementToWorkOn> processor) {
        PsiLocalVariable localVar = null;
        PsiExpression expr = null;
        if (!editor.getSelectionModel().hasSelection()) {
            PsiElement element = TargetElementUtil.findTargetElement((Editor)editor, (int)11);
            if (element instanceof PsiLocalVariable) {
                localVar = (PsiLocalVariable)element;
                PsiElement elementAt = file.findElementAt(editor.getCaretModel().getOffset());
                if (elementAt instanceof PsiIdentifier && elementAt.getParent() instanceof PsiReferenceExpression) {
                    expr = (PsiExpression)elementAt.getParent();
                } else {
                    PsiElement refElement;
                    PsiReference reference = TargetElementUtil.findReference((Editor)editor);
                    if (reference != null && (refElement = reference.getElement()) instanceof PsiReferenceExpression) {
                        expr = (PsiReferenceExpression)refElement;
                    }
                }
            } else {
                final PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PsiLocalVariable.class);
                int offset = editor.getCaretModel().getOffset();
                PsiElement[] statementsInRange = IntroduceVariableBase.findStatementsAtOffset(editor, file, offset);
                if (statementsInRange.length == 1 && IntroduceVariableBase.selectLineAtCaret(offset, statementsInRange)) {
                    editor.getSelectionModel().selectLineAtCaret();
                    ElementToWorkOn elementToWorkOn = ElementToWorkOn.getElementToWorkOn(editor, file, refactoringName, helpId, project, localVar, expr);
                    if (elementToWorkOn == null || elementToWorkOn.getLocalVariable() == null && elementToWorkOn.getExpression() == null || !processor.accept(elementToWorkOn)) {
                        editor.getSelectionModel().removeSelection();
                    }
                }
                if (!editor.getSelectionModel().hasSelection()) {
                    List<PsiExpression> expressions2 = IntroduceVariableBase.collectExpressions(file, editor, offset);
                    Iterator<PsiExpression> iterator = expressions2.iterator();
                    while (iterator.hasNext()) {
                        PsiExpression expression2 = iterator.next();
                        if (processor.accept(new ElementToWorkOn(null, expression2))) continue;
                        iterator.remove();
                    }
                    if (expressions2.isEmpty()) {
                        editor.getSelectionModel().selectLineAtCaret();
                    } else if (!IntroduceVariableBase.isChooserNeeded(expressions2)) {
                        expr = expressions2.get(0);
                    } else {
                        int selection = IntroduceVariableBase.preferredSelection(statementsInRange, expressions2);
                        IntroduceTargetChooser.showChooser((Editor)editor, expressions2, (Pass)new Pass<PsiExpression>(){

                            public void pass(PsiExpression selectedValue) {
                                PsiLocalVariable var = null;
                                if (variable != null && variable.getInitializer() == selectedValue) {
                                    var = variable;
                                }
                                processor.pass(ElementToWorkOn.getElementToWorkOn(editor, file, refactoringName, helpId, project, var, selectedValue));
                            }
                        }, (Function)new PsiExpressionTrimRenderer.RenderFunction(), (String)"Expressions", (int)selection, (NotNullFunction)ScopeHighlighter.NATURAL_RANGER);
                        return;
                    }
                }
            }
        }
        processor.pass(ElementToWorkOn.getElementToWorkOn(editor, file, refactoringName, helpId, project, localVar, expr));
    }

    private static ElementToWorkOn getElementToWorkOn(Editor editor, PsiFile file, String refactoringName, String helpId, Project project, PsiLocalVariable localVar, PsiExpression expr) {
        String errorMessage;
        int startOffset = 0;
        int endOffset = 0;
        if (localVar == null && expr == null) {
            startOffset = editor.getSelectionModel().getSelectionStart();
            expr = CodeInsightUtil.findExpressionInRange(file, startOffset, endOffset = editor.getSelectionModel().getSelectionEnd());
            if (expr == null) {
                PsiIdentifier ident = CodeInsightUtil.findElementInRange(file, startOffset, endOffset, PsiIdentifier.class);
                if (ident != null) {
                    localVar = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)ident, PsiLocalVariable.class);
                }
            } else if (expr instanceof PsiArrayInitializerExpression && expr.getParent() instanceof PsiNewExpression) {
                expr = (PsiExpression)expr.getParent();
            }
        }
        if (expr == null && localVar == null) {
            PsiDeclarationStatement decl;
            PsiElement[] declaredElements;
            PsiElement[] statements = CodeInsightUtil.findStatementsInRange(file, startOffset, endOffset);
            if (statements.length == 1 && statements[0] instanceof PsiExpressionStatement) {
                expr = ((PsiExpressionStatement)statements[0]).getExpression();
            } else if (statements.length == 1 && statements[0] instanceof PsiDeclarationStatement && (declaredElements = (decl = (PsiDeclarationStatement)statements[0]).getDeclaredElements()).length == 1 && declaredElements[0] instanceof PsiLocalVariable) {
                localVar = (PsiLocalVariable)declaredElements[0];
            }
        }
        if (localVar == null && expr == null) {
            expr = IntroduceVariableBase.getSelectedExpression(project, file, startOffset, endOffset);
        }
        if (localVar == null && expr != null && (errorMessage = IntroduceVariableBase.getErrorMessage(expr)) != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)errorMessage, (String)refactoringName, (String)helpId);
            return null;
        }
        return new ElementToWorkOn(localVar, expr);
    }

    public static void showNothingSelectedErrorMessage(Editor editor, String refactoringName, String helpId, Project project) {
        String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.local.or.expression.name"));
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)refactoringName, (String)helpId);
    }

    public static interface ElementsProcessor<T> {
        public boolean accept(ElementToWorkOn var1);

        public void pass(T var1);
    }
}

