/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject;

import com.intellij.ide.util.TreeJavaClassChooserDialog;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.introduceParameterObject.AbstractIntroduceParameterObjectDialog;
import com.intellij.refactoring.introduceparameterobject.JavaIntroduceParameterObjectClassDescriptor;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.ParameterTablePanel;
import com.intellij.refactoring.util.VariableData;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class IntroduceParameterObjectDialog
extends AbstractIntroduceParameterObjectDialog<PsiMethod, ParameterInfoImpl, JavaIntroduceParameterObjectClassDescriptor, VariableData> {
    private JRadioButton useExistingClassButton;
    private JPanel myUseExistingPanel;
    private JRadioButton createNewClassButton;
    private JTextField classNameField;
    private JPanel myCreateNewClassPanel;
    private JRadioButton myCreateInnerClassRadioButton;
    private JTextField myInnerClassNameTextField;
    private JPanel myInnerClassPanel;
    private JPanel myWholePanel;
    private ReferenceEditorComboWithBrowseButton packageTextField;
    private ReferenceEditorComboWithBrowseButton existingClassField;
    private JCheckBox myGenerateAccessorsCheckBox;
    private JCheckBox myEscalateVisibilityCheckBox;
    private ComboboxWithBrowseButton myDestinationCb;
    private static final String RECENTS_KEY = "IntroduceParameterObject.RECENTS_KEY";
    private static final String EXISTING_KEY = "IntroduceParameterObject.EXISTING_KEY";

    public IntroduceParameterObjectDialog(PsiMethod sourceMethod) {
        super((PsiNamedElement)sourceMethod);
        this.$$$setupUI$$$();
        DocumentAdapter docListener = new DocumentAdapter(){

            protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                IntroduceParameterObjectDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectDialog$1", "textChanged"));
            }
        };
        PsiClass containingClass = sourceMethod.getContainingClass();
        this.classNameField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)docListener);
        this.myInnerClassNameTextField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)docListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useExistingClassButton);
        buttonGroup.add(this.createNewClassButton);
        buttonGroup.add(this.myCreateInnerClassRadioButton);
        this.createNewClassButton.setSelected(true);
        if (containingClass == null || containingClass.getQualifiedName() == null || containingClass.getContainingClass() != null || containingClass.isInterface()) {
            this.myCreateInnerClassRadioButton.setEnabled(false);
        }
        this.init();
        ActionListener listener = actionEvent -> {
            this.toggleRadioEnablement();
            IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
            if (this.useExistingClass()) {
                focusManager.requestFocus((Component)((Object)this.existingClassField), true);
            } else if (this.myCreateInnerClassRadioButton.isSelected()) {
                focusManager.requestFocus((Component)this.myInnerClassNameTextField, true);
            } else {
                focusManager.requestFocus((Component)this.classNameField, true);
            }
        };
        this.useExistingClassButton.addActionListener(listener);
        this.createNewClassButton.addActionListener(listener);
        this.myCreateInnerClassRadioButton.addActionListener(listener);
        this.myGenerateAccessorsCheckBox.setSelected(true);
        this.myEscalateVisibilityCheckBox.setSelected(true);
        this.toggleRadioEnablement();
    }

    protected boolean isDelegateCheckboxVisible() {
        PsiClass containingClass = ((PsiMethod)this.mySourceMethod).getContainingClass();
        return containingClass != null && !containingClass.isInterface();
    }

    private void toggleRadioEnablement() {
        UIUtil.setEnabled((Component)this.myUseExistingPanel, (boolean)this.useExistingClassButton.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myCreateNewClassPanel, (boolean)this.createNewClassButton.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myInnerClassPanel, (boolean)this.myCreateInnerClassRadioButton.isSelected(), (boolean)true);
        this.validateButtons();
        this.enableGenerateAccessors();
    }

    protected String getDimensionServiceKey() {
        return "RefactorJ.IntroduceParameterObject";
    }

    protected String getSourceMethodPresentation() {
        return PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)this.mySourceMethod), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
    }

    protected ParameterTablePanel createParametersPanel() {
        PsiParameterList parameterList = ((PsiMethod)this.mySourceMethod).getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        VariableData[] parameterInfo = new VariableData[parameters2.length];
        for (int i = 0; i < parameterInfo.length; ++i) {
            parameterInfo[i] = new VariableData((PsiVariable)parameters2[i]);
            parameterInfo[i].name = parameters2[i].getName();
            parameterInfo[i].passAsParameter = true;
        }
        return new ParameterTablePanel(this.myProject, parameterInfo, new PsiElement[0]){

            protected void updateSignature() {
            }

            protected void doEnterAction() {
            }

            protected void doCancelAction() {
                IntroduceParameterObjectDialog.this.doCancelAction();
            }
        };
    }

    protected JPanel createParameterClassPanel() {
        return this.myWholePanel;
    }

    protected JavaIntroduceParameterObjectClassDescriptor createClassDescriptor() {
        String packageName;
        String className;
        boolean useExistingClass = this.useExistingClass();
        boolean createInnerClass = this.myCreateInnerClassRadioButton.isSelected();
        if (createInnerClass) {
            className = this.getInnerClassName();
            packageName = "";
        } else if (useExistingClass) {
            String existingClassName = this.getExistingClassName();
            className = StringUtil.getShortName((String)existingClassName);
            packageName = StringUtil.getPackageName((String)existingClassName);
        } else {
            packageName = this.getPackageName();
            className = this.getClassName();
        }
        String newVisibility = this.myEscalateVisibilityCheckBox.isEnabled() && this.myEscalateVisibilityCheckBox.isSelected() ? "EscalateVisible" : null;
        MoveDestination moveDestination = ((DestinationFolderComboBox)this.myDestinationCb).selectDirectory(new PackageWrapper(PsiManager.getInstance((Project)this.myProject), packageName), false);
        PsiParameterList parameterList = ((PsiMethod)this.mySourceMethod).getParameterList();
        ArrayList<ParameterInfoImpl> parameters2 = new ArrayList<ParameterInfoImpl>();
        for (VariableData data : (VariableData[])this.myParameterTablePanel.getVariableData()) {
            if (!data.passAsParameter) continue;
            parameters2.add(new ParameterInfoImpl(parameterList.getParameterIndex((PsiParameter)data.variable), data.name, data.type));
        }
        ParameterInfoImpl[] infos = parameters2.toArray(new ParameterInfoImpl[0]);
        return new JavaIntroduceParameterObjectClassDescriptor(className, packageName, moveDestination, useExistingClass, createInnerClass, newVisibility, infos, (PsiMethod)this.mySourceMethod, this.myGenerateAccessorsCheckBox.isSelected());
    }

    protected void canRun() throws ConfigurationException {
        super.canRun();
        Project project = ((PsiMethod)this.mySourceMethod).getProject();
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)project);
        if (this.myCreateInnerClassRadioButton.isSelected()) {
            String innerClassName = this.getInnerClassName();
            if (!nameHelper.isIdentifier(innerClassName)) {
                throw new ConfigurationException("'" + innerClassName + "' is invalid inner class name");
            }
            if (((PsiMethod)this.mySourceMethod).getContainingClass().findInnerClassByName(innerClassName, false) != null) {
                throw new ConfigurationException("Inner class with name '" + innerClassName + "' already exist");
            }
        } else if (!this.useExistingClass()) {
            String className = this.getClassName();
            if (className.length() == 0 || !nameHelper.isIdentifier(className)) {
                throw new ConfigurationException("'" + className + "' is invalid parameter class name");
            }
            String packageName = this.getPackageName();
            if (packageName.length() == 0 || !nameHelper.isQualifiedName(packageName)) {
                throw new ConfigurationException("'" + packageName + "' is invalid parameter class package name");
            }
        } else {
            String className = this.getExistingClassName();
            if (className.length() == 0 || !nameHelper.isQualifiedName(className)) {
                throw new ConfigurationException("'" + className + "' is invalid qualified parameter class name");
            }
            if (JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.getProject())) == null) {
                throw new ConfigurationException("'" + className + "' does not exist");
            }
        }
    }

    private String getInnerClassName() {
        return this.myInnerClassNameTextField.getText().trim();
    }

    @NotNull
    public String getPackageName() {
        String string = this.packageTextField.getText().trim();
        if (string == null) {
            IntroduceParameterObjectDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getExistingClassName() {
        String string = this.existingClassField.getText().trim();
        if (string == null) {
            IntroduceParameterObjectDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getClassName() {
        String string = this.classNameField.getText().trim();
        if (string == null) {
            IntroduceParameterObjectDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.classNameField;
    }

    protected String getHelpId() {
        return "refactorj.introduceParameterObject";
    }

    public boolean useExistingClass() {
        return this.useExistingClassButton.isSelected();
    }

    private void createUIComponents() {
        PsiFile file = ((PsiMethod)this.mySourceMethod).getContainingFile();
        this.packageTextField = new PackageNameReferenceEditorCombo(file instanceof PsiJavaFile ? ((PsiJavaFile)file).getPackageName() : "", this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
        Document document = ((EditorComboBox)this.packageTextField.getChildComponent()).getDocument();
        DocumentListener adapter = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                IntroduceParameterObjectDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectDialog$3", "documentChanged"));
            }
        };
        document.addDocumentListener(adapter);
        this.existingClassField = new ReferenceEditorComboWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = ((PsiMethod)IntroduceParameterObjectDialog.this.mySourceMethod).getProject();
                GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
                TreeJavaClassChooserDialog chooser = new TreeJavaClassChooserDialog(RefactorJBundle.message("select.wrapper.class", new Object[0]), project, scope, null, null);
                String classText = IntroduceParameterObjectDialog.this.existingClassField.getText();
                PsiClass currentClass = JavaPsiFacade.getInstance((Project)project).findClass(classText, GlobalSearchScope.allScope((Project)project));
                if (currentClass != null) {
                    chooser.select((PsiNamedElement)currentClass);
                }
                chooser.show();
                PsiClass selectedClass = (PsiClass)chooser.getSelected();
                if (selectedClass != null) {
                    String className = selectedClass.getQualifiedName();
                    IntroduceParameterObjectDialog.this.existingClassField.setText(className);
                    RecentsManager.getInstance((Project)IntroduceParameterObjectDialog.this.myProject).registerRecentEntry(IntroduceParameterObjectDialog.EXISTING_KEY, className);
                }
            }
        }, "", this.myProject, true, EXISTING_KEY);
        ((EditorComboBox)this.existingClassField.getChildComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                IntroduceParameterObjectDialog.this.validateButtons();
                IntroduceParameterObjectDialog.this.enableGenerateAccessors();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectDialog$5", "documentChanged"));
            }
        });
        this.myDestinationCb = new DestinationFolderComboBox(){

            @Override
            public String getTargetPackage() {
                return IntroduceParameterObjectDialog.this.getPackageName();
            }
        };
        ((DestinationFolderComboBox)this.myDestinationCb).setData(this.myProject, ((PsiMethod)this.mySourceMethod).getContainingFile().getContainingDirectory(), (EditorComboBox)this.packageTextField.getChildComponent());
    }

    private void enableGenerateAccessors() {
        VirtualFile virtualFile;
        PsiFile containingFile;
        PsiClass selectedClass;
        boolean existingNotALibraryClass = false;
        if (this.useExistingClassButton.isSelected() && (selectedClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.existingClassField.getText(), GlobalSearchScope.projectScope((Project)this.myProject))) != null && (containingFile = selectedClass.getContainingFile()) != null && (virtualFile = containingFile.getVirtualFile()) != null) {
            existingNotALibraryClass = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.SOURCES);
        }
        this.myGenerateAccessorsCheckBox.setEnabled(existingNotALibraryClass);
        this.myEscalateVisibilityCheckBox.setEnabled(existingNotALibraryClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingClassName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JTextField jTextField;
        JPanel jPanel;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JTextField jTextField2;
        JPanel jPanel3;
        JRadioButton jRadioButton3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myWholePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "");
        this.createNewClassButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Create new class");
        jRadioButton3.setMnemonic('C');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myCreateNewClassPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.classNameField = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Package name");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageTextField;
        jPanel3.add((Component)((Object)referenceEditorComboWithBrowseButton), new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/RefactoringBundle").getString("target.destination.folder"));
        jPanel3.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myDestinationCb;
        jPanel3.add((Component)comboboxWithBrowseButton, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myUseExistingPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Name");
        jLabel4.setDisplayedMnemonic('N');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton2 = this.existingClassField;
        jPanel2.add((Component)((Object)referenceEditorComboWithBrowseButton2), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myGenerateAccessorsCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Generate accessors");
        jCheckBox2.setMnemonic('G');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 2, 9, 0, 3, 0, null, null, null));
        this.myEscalateVisibilityCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Escalate visibility");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCreateInnerClassRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Create inner class");
        jRadioButton2.setMnemonic('I');
        jRadioButton2.setDisplayedMnemonicIndex(7);
        jPanel4.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInnerClassPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Name");
        jLabel5.setDisplayedMnemonic('N');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myInnerClassNameTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        this.useExistingClassButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Use existing class");
        jRadioButton.setMnemonic('U');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel3.setLabelFor((Component)comboboxWithBrowseButton);
        jLabel5.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

