/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MutationUtils {
    private MutationUtils() {
    }

    public static void replaceType(@NotNull String newTypeText, @NotNull PsiTypeElement typeElement) throws IncorrectOperationException {
        if (newTypeText == null) {
            MutationUtils.$$$reportNull$$$0(0);
        }
        if (typeElement == null) {
            MutationUtils.$$$reportNull$$$0(1);
        }
        Project project = typeElement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiType newType = factory.createTypeFromText(newTypeText, null);
        PsiTypeElement newTypeElement = factory.createTypeElement(newType);
        PsiElement insertedElement = typeElement.replace((PsiElement)newTypeElement);
        PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(insertedElement);
        CodeStyleManager.getInstance((Project)project).reformat(shortenedElement);
    }

    public static void replaceExpression(@NotNull String newExpression, @NotNull PsiExpression exp) throws IncorrectOperationException {
        if (newExpression == null) {
            MutationUtils.$$$reportNull$$$0(2);
        }
        if (exp == null) {
            MutationUtils.$$$reportNull$$$0(3);
        }
        Project project = exp.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiExpression newCall = factory.createExpressionFromText(newExpression, null);
        PsiElement insertedElement = exp.replace((PsiElement)newCall);
        PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(insertedElement);
        CodeStyleManager.getInstance((Project)project).reformat(shortenedElement);
    }

    public static void replaceExpressionIfValid(@NotNull String newExpression, @NotNull PsiExpression exp) throws IncorrectOperationException {
        if (newExpression == null) {
            MutationUtils.$$$reportNull$$$0(4);
        }
        if (exp == null) {
            MutationUtils.$$$reportNull$$$0(5);
        }
        try {
            MutationUtils.replaceExpression(newExpression, exp);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
    }

    public static void replaceReference(@NotNull String className, @NotNull PsiJavaCodeReferenceElement ref) throws IncorrectOperationException {
        PsiElement insertedElement;
        if (className == null) {
            MutationUtils.$$$reportNull$$$0(6);
        }
        if (ref == null) {
            MutationUtils.$$$reportNull$$$0(7);
        }
        Project project = ref.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = facade.getElementFactory();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiReferenceExpression) {
            PsiClass aClass = facade.findClass(className, scope);
            if (aClass == null) {
                return;
            }
            ((PsiReferenceExpression)parent).setQualifierExpression((PsiExpression)factory.createReferenceExpression(aClass));
            insertedElement = ((PsiReferenceExpression)parent).getQualifierExpression();
            assert (insertedElement != null) : parent;
        } else {
            PsiJavaCodeReferenceElement newReference = factory.createReferenceElementByFQClassName(className, scope);
            insertedElement = ref.replace((PsiElement)newReference);
        }
        PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(insertedElement);
        CodeStyleManager.getInstance((Project)project).reformat(shortenedElement);
    }

    public static void replaceStatement(@NotNull String newStatement, @NotNull PsiStatement statement) throws IncorrectOperationException {
        if (newStatement == null) {
            MutationUtils.$$$reportNull$$$0(8);
        }
        if (statement == null) {
            MutationUtils.$$$reportNull$$$0(9);
        }
        Project project = statement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiStatement newCall = factory.createStatementFromText(newStatement, null);
        PsiElement insertedElement = statement.replace((PsiElement)newCall);
        PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(insertedElement);
        CodeStyleManager.getInstance((Project)project).reformat(shortenedElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTypeText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStatement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/psi/MutationUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceExpression";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceExpressionIfValid";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceReference";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

