/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetMapper;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RenameAliasingPomTargetProcessor
extends RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance(RenameAliasingPomTargetProcessor.class);

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenameAliasingPomTargetProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof PomTarget || element instanceof PomTargetPsiElement;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            RenameAliasingPomTargetProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            RenameAliasingPomTargetProcessor.$$$reportNull$$$0(2);
        }
        if (allRenames == null) {
            RenameAliasingPomTargetProcessor.$$$reportNull$$$0(3);
        }
        PomTarget target = null;
        if (element instanceof PomTargetPsiElement) {
            target = ((PomTargetPsiElement)element).getTarget();
        } else if (element instanceof PomTarget) {
            target = (PomTarget)element;
        }
        if (target != null) {
            for (AliasingPsiTargetMapper mapper : AliasingPsiTargetMapper.EP_NAME.getExtensionList()) {
                for (AliasingPsiTarget psiTarget : mapper.getTargets(target)) {
                    String name;
                    PsiElement psiElement = PomService.convertToPsi((PsiTarget)psiTarget);
                    String definedName = allRenames.put(psiElement, name = psiTarget.getNameAlias(newName));
                    if (definedName != null) {
                        LOG.assertTrue(definedName.equals(name), (Object)("target: " + psiTarget + "; defined name: " + definedName + "; name: " + name + "; mapper: " + mapper));
                        continue;
                    }
                    this.prepareRenaming(psiElement, name, allRenames);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/RenameAliasingPomTargetProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

