/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithFactory;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.replaceConstructorWithFactory.ReplaceConstructorWithFactoryViewDescriptor;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceConstructorWithFactoryProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.replaceConstructorWithFactory.ReplaceConstructorWithFactoryProcessor");
    private final PsiMethod myConstructor;
    private final String myFactoryName;
    private final PsiElementFactory myFactory;
    private final PsiClass myOriginalClass;
    private final PsiClass myTargetClass;
    private final PsiManager myManager;
    private final boolean myIsInner;
    private List<PsiElement> myNonNewConstructorUsages;

    public ReplaceConstructorWithFactoryProcessor(Project project, PsiMethod originalConstructor, PsiClass originalClass, PsiClass targetClass, @NonNls String factoryName) {
        super(project);
        this.myOriginalClass = originalClass;
        this.myConstructor = originalConstructor;
        this.myTargetClass = targetClass;
        this.myFactoryName = factoryName;
        this.myManager = PsiManager.getInstance((Project)project);
        this.myFactory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
        this.myIsInner = this.isInner(this.myOriginalClass);
    }

    private boolean isInner(PsiClass originalClass) {
        boolean result = PsiUtil.isInnerClass((PsiClass)originalClass);
        if (result) {
            LOG.assertTrue(PsiTreeUtil.isAncestor((PsiElement)this.myTargetClass, (PsiElement)originalClass, (boolean)false));
        }
        return result;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ReplaceConstructorWithFactoryProcessor.$$$reportNull$$$0(0);
        }
        if (this.myConstructor != null) {
            ReplaceConstructorWithFactoryViewDescriptor replaceConstructorWithFactoryViewDescriptor = new ReplaceConstructorWithFactoryViewDescriptor(this.myConstructor);
            if (replaceConstructorWithFactoryViewDescriptor == null) {
                ReplaceConstructorWithFactoryProcessor.$$$reportNull$$$0(1);
            }
            return replaceConstructorWithFactoryViewDescriptor;
        }
        ReplaceConstructorWithFactoryViewDescriptor replaceConstructorWithFactoryViewDescriptor = new ReplaceConstructorWithFactoryViewDescriptor(this.myOriginalClass);
        if (replaceConstructorWithFactoryViewDescriptor == null) {
            ReplaceConstructorWithFactoryProcessor.$$$reportNull$$$0(2);
        }
        return replaceConstructorWithFactoryViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.myProject);
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        this.myNonNewConstructorUsages = new ArrayList<PsiElement>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)(this.myConstructor == null ? this.myOriginalClass : this.myConstructor), (SearchScope)projectScope, (boolean)false)) {
            PsiElement element = reference.getElement();
            if (element.getParent() instanceof PsiNewExpression) {
                usages.add(new UsageInfo(element.getParent()));
                continue;
            }
            if ("super".equals(element.getText()) || "this".equals(element.getText())) {
                this.myNonNewConstructorUsages.add(element);
                continue;
            }
            if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
                this.myNonNewConstructorUsages.add(element);
                continue;
            }
            if (!(element instanceof PsiClass)) continue;
            this.myNonNewConstructorUsages.add(element);
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            ReplaceConstructorWithFactoryProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        PsiMethod factoryMethod;
        PsiClass constructorContainingClass;
        if (refUsages == null) {
            ReplaceConstructorWithFactoryProcessor.$$$reportNull$$$0(4);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)this.myProject).getResolveHelper();
        if (!helper.isAccessible((PsiMember)(constructorContainingClass = this.getConstructorContainingClass()), (PsiElement)this.myTargetClass, null)) {
            String message2 = RefactoringBundle.message((String)"class.0.is.not.accessible.from.target.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)constructorContainingClass, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)this.myTargetClass, (boolean)true)});
            conflicts.putValue((Object)constructorContainingClass, (Object)message2);
        }
        HashSet<PsiElement> reportedContainers = new HashSet<PsiElement>();
        String targetClassDescription = RefactoringUIUtil.getDescription((PsiElement)this.myTargetClass, (boolean)true);
        for (UsageInfo usage : usages) {
            PsiElement container = ConflictsUtil.getContainer(usage.getElement());
            if (reportedContainers.contains(container)) continue;
            reportedContainers.add(container);
            if (helper.isAccessible((PsiMember)this.myTargetClass, usage.getElement(), null)) continue;
            String message3 = RefactoringBundle.message((String)"target.0.is.not.accessible.from.1", (Object[])new Object[]{targetClassDescription, RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true)});
            conflicts.putValue((Object)this.myTargetClass, (Object)message3);
        }
        if (this.myIsInner) {
            for (UsageInfo usage : usages) {
                PsiClass containingClass;
                PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)usage.getElement(), PsiField.class);
                if (field == null || !PsiTreeUtil.isAncestor((PsiElement)(containingClass = field.getContainingClass()), (PsiElement)this.myTargetClass, (boolean)true)) continue;
                String message4 = RefactoringBundle.message((String)"constructor.being.refactored.is.used.in.initializer.of.0", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)field, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)constructorContainingClass, (boolean)false)});
                conflicts.putValue((Object)field, (Object)message4);
            }
        }
        if ((factoryMethod = this.myTargetClass.findMethodBySignature(this.createFactoryMethod(), false)) != null) {
            conflicts.putValue((Object)factoryMethod, (Object)("Factory method " + RefactoringUIUtil.getDescription((PsiElement)factoryMethod, (boolean)false) + " already exists and will be used instead of newly created."));
        }
        return this.showConflicts(conflicts, usages);
    }

    private PsiClass getConstructorContainingClass() {
        if (this.myConstructor != null) {
            return this.myConstructor.getContainingClass();
        }
        return this.myOriginalClass;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ReplaceConstructorWithFactoryProcessor.$$$reportNull$$$0(5);
        }
        try {
            PsiReferenceExpression classReferenceExpression = this.myFactory.createReferenceExpression(this.myTargetClass);
            PsiReferenceExpression qualifiedMethodReference = (PsiReferenceExpression)this.myFactory.createExpressionFromText("A." + this.myFactoryName, null);
            PsiMethod factoryMethod = this.createFactoryMethod();
            PsiMethod oldFactoryMethod = this.myTargetClass.findMethodBySignature(factoryMethod, false);
            PsiMethod psiMethod = factoryMethod = oldFactoryMethod != null ? oldFactoryMethod : (PsiMethod)this.myTargetClass.add((PsiElement)factoryMethod);
            if (this.myConstructor != null) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)this.myConstructor, (String)"private", (boolean)true);
                VisibilityUtil.escalateVisibility((PsiMember)this.myConstructor, (PsiElement)factoryMethod);
                for (PsiElement place : this.myNonNewConstructorUsages) {
                    VisibilityUtil.escalateVisibility((PsiMember)this.myConstructor, (PsiElement)place);
                }
            }
            if (this.myConstructor == null) {
                PsiMethod constructor = this.myFactory.createConstructor();
                PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)"private", (boolean)true);
                constructor = (PsiMethod)this.getConstructorContainingClass().add((PsiElement)constructor);
                VisibilityUtil.escalateVisibility((PsiMember)constructor, (PsiElement)this.myTargetClass);
            }
            for (UsageInfo usage : usages) {
                PsiNewExpression newExpression = (PsiNewExpression)usage.getElement();
                if (newExpression == null || oldFactoryMethod != null && PsiTreeUtil.isAncestor((PsiElement)oldFactoryMethod, (PsiElement)newExpression, (boolean)false)) continue;
                VisibilityUtil.escalateVisibility((PsiMember)factoryMethod, (PsiElement)newExpression);
                PsiMethodCallExpression factoryCall = (PsiMethodCallExpression)this.myFactory.createExpressionFromText(this.myFactoryName + "()", (PsiElement)newExpression);
                factoryCall.getArgumentList().replace((PsiElement)newExpression.getArgumentList());
                boolean replaceMethodQualifier = false;
                PsiExpression newQualifier = newExpression.getQualifier();
                PsiElement resolvedFactoryMethod = factoryCall.getMethodExpression().resolve();
                if (resolvedFactoryMethod != factoryMethod || newQualifier != null) {
                    factoryCall.getMethodExpression().replace((PsiElement)qualifiedMethodReference);
                    replaceMethodQualifier = true;
                }
                if (replaceMethodQualifier) {
                    if (newQualifier == null) {
                        factoryCall.getMethodExpression().getQualifierExpression().replace((PsiElement)classReferenceExpression);
                    } else {
                        factoryCall.getMethodExpression().getQualifierExpression().replace((PsiElement)newQualifier);
                    }
                }
                newExpression.replace((PsiElement)factoryCall);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private PsiMethod createFactoryMethod() throws IncorrectOperationException {
        PsiParameter[] params;
        PsiClass containingClass = this.getConstructorContainingClass();
        PsiClassType type2 = this.myFactory.createType(containingClass, PsiSubstitutor.EMPTY);
        PsiMethod factoryMethod = this.myFactory.createMethod(this.myFactoryName, (PsiType)type2);
        if (this.myConstructor != null) {
            factoryMethod.getParameterList().replace((PsiElement)this.myConstructor.getParameterList());
            factoryMethod.getThrowsList().replace((PsiElement)this.myConstructor.getThrowsList());
        }
        HashSet<String> names = new HashSet<String>();
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)(this.myConstructor != null ? this.myConstructor : containingClass))) {
            if (names.contains(typeParameter.getName())) continue;
            names.add(typeParameter.getName());
            factoryMethod.getTypeParameterList().addAfter((PsiElement)typeParameter, null);
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)this.myFactory.createStatementFromText("return new A();", null);
        PsiNewExpression newExpression = (PsiNewExpression)returnStatement.getReturnValue();
        PsiJavaCodeReferenceElement classRef = this.myFactory.createReferenceElementByType(type2);
        newExpression.getClassReference().replace((PsiElement)classRef);
        PsiExpressionList argumentList = newExpression.getArgumentList();
        for (PsiParameter parameter2 : params = factoryMethod.getParameterList().getParameters()) {
            PsiExpression paramRef = this.myFactory.createExpressionFromText(parameter2.getName(), null);
            argumentList.add((PsiElement)paramRef);
        }
        factoryMethod.getBody().add((PsiElement)returnStatement);
        PsiUtil.setModifierProperty((PsiModifierListOwner)factoryMethod, (String)this.getDefaultFactoryVisibility(), (boolean)true);
        if (!this.myIsInner) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)factoryMethod, (String)"static", (boolean)true);
        }
        return (PsiMethod)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)factoryMethod);
    }

    @PsiModifier.ModifierConstant
    private String getDefaultFactoryVisibility() {
        PsiModifierList modifierList = this.myConstructor != null ? this.myConstructor.getModifierList() : this.myOriginalClass.getModifierList();
        return VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierList);
    }

    @NotNull
    protected String getCommandName() {
        if (this.myConstructor != null) {
            String string = RefactoringBundle.message((String)"replace.constructor.0.with.a.factory.method", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myConstructor)});
            if (string == null) {
                ReplaceConstructorWithFactoryProcessor.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = RefactoringBundle.message((String)"replace.default.constructor.of.0.with.a.factory.method", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myOriginalClass)});
        if (string == null) {
            ReplaceConstructorWithFactoryProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    public PsiClass getOriginalClass() {
        return this.getConstructorContainingClass();
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    public PsiMethod getConstructor() {
        return this.myConstructor;
    }

    public String getFactoryName() {
        return this.myFactoryName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/replaceConstructorWithFactory/ReplaceConstructorWithFactoryProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/replaceConstructorWithFactory/ReplaceConstructorWithFactoryProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

