/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalReturnStatementValue
implements ReturnValue {
    PsiExpression myReturnValue;

    public ConditionalReturnStatementValue(PsiExpression returnValue) {
        this.myReturnValue = returnValue;
    }

    @Override
    public boolean isEquivalent(ReturnValue other) {
        if (!(other instanceof ConditionalReturnStatementValue)) {
            return false;
        }
        PsiExpression otherReturnValue = ((ConditionalReturnStatementValue)other).myReturnValue;
        if (otherReturnValue == null || this.myReturnValue == null) {
            return this.myReturnValue == null && otherReturnValue == null;
        }
        return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.myReturnValue, (PsiElement)otherReturnValue);
    }

    @Override
    @Nullable
    public PsiStatement createReplacement(@NotNull PsiMethod extractedMethod, @NotNull PsiMethodCallExpression methodCallExpression, @Nullable PsiType returnType) throws IncorrectOperationException {
        PsiIfStatement statement;
        if (extractedMethod == null) {
            ConditionalReturnStatementValue.$$$reportNull$$$0(0);
        }
        if (methodCallExpression == null) {
            ConditionalReturnStatementValue.$$$reportNull$$$0(1);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)methodCallExpression.getProject());
        if (this.myReturnValue == null) {
            statement = (PsiIfStatement)elementFactory.createStatementFromText("if(a) return;", null);
        } else {
            statement = (PsiIfStatement)elementFactory.createStatementFromText("if(a) return b;", null);
            PsiReturnStatement thenBranch = (PsiReturnStatement)statement.getThenBranch();
            assert (thenBranch != null);
            PsiExpression returnValue = thenBranch.getReturnValue();
            assert (returnValue != null);
            returnValue.replace((PsiElement)this.myReturnValue);
        }
        PsiExpression condition2 = statement.getCondition();
        assert (condition2 != null);
        condition2.replace((PsiElement)methodCallExpression);
        return (PsiStatement)CodeStyleManager.getInstance((Project)statement.getManager().getProject()).reformat((PsiElement)statement);
    }

    public boolean isEmptyOrConstantExpression() {
        return this.myReturnValue == null || ExpressionUtils.isNullLiteral(this.myReturnValue) || PsiUtil.isConstantExpression((PsiExpression)this.myReturnValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "extractedMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "methodCallExpression";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/util/duplicates/ConditionalReturnStatementValue";
        objectArray[2] = "createReplacement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

