/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.duplicates.ExtractableExpressionPart;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class ExtractedParameter {
    @NotNull
    public final PsiType myType;
    @NotNull
    public final ExtractableExpressionPart myPattern;
    @NotNull
    public final ExtractableExpressionPart myCandidate;
    @NotNull
    public final Set<PsiExpression> myPatternUsages;

    public ExtractedParameter(@NotNull ExtractableExpressionPart patternPart, @NotNull ExtractableExpressionPart candidatePart, @NotNull PsiType type2) {
        if (patternPart == null) {
            ExtractedParameter.$$$reportNull$$$0(0);
        }
        if (candidatePart == null) {
            ExtractedParameter.$$$reportNull$$$0(1);
        }
        if (type2 == null) {
            ExtractedParameter.$$$reportNull$$$0(2);
        }
        this.myPatternUsages = new HashSet<PsiExpression>();
        this.myType = type2;
        this.myPattern = patternPart;
        this.myCandidate = candidatePart;
        this.addUsages(patternPart);
    }

    public static boolean match(@NotNull ExtractableExpressionPart patternPart, @NotNull ExtractableExpressionPart candidatePart, @NotNull List<ExtractedParameter> parameters2) {
        PsiType type2;
        if (patternPart == null) {
            ExtractedParameter.$$$reportNull$$$0(3);
        }
        if (candidatePart == null) {
            ExtractedParameter.$$$reportNull$$$0(4);
        }
        if (parameters2 == null) {
            ExtractedParameter.$$$reportNull$$$0(5);
        }
        if ((type2 = ExtractableExpressionPart.commonType(patternPart, candidatePart)) == null) {
            return false;
        }
        for (ExtractedParameter parameter2 : parameters2) {
            boolean samePattern = parameter2.samePattern(patternPart);
            boolean sameCandidate = parameter2.sameCandidate(candidatePart);
            if (samePattern && sameCandidate) {
                parameter2.addUsages(patternPart);
                return true;
            }
            if (!samePattern && !sameCandidate) continue;
            return false;
        }
        parameters2.add(new ExtractedParameter(patternPart, candidatePart, type2));
        return true;
    }

    @NotNull
    public ExtractedParameter copyWithCandidateUsage(@NotNull PsiExpression candidateUsage) {
        if (candidateUsage == null) {
            ExtractedParameter.$$$reportNull$$$0(6);
        }
        ExtractedParameter result = new ExtractedParameter(this.myPattern, ExtractableExpressionPart.fromUsage(candidateUsage, this.myType), this.myType);
        result.myPatternUsages.addAll(this.myPatternUsages);
        ExtractedParameter extractedParameter = result;
        if (extractedParameter == null) {
            ExtractedParameter.$$$reportNull$$$0(7);
        }
        return extractedParameter;
    }

    @NotNull
    public String getLocalVariableTypeText() {
        PsiType type2 = GenericsUtil.getVariableTypeByExpressionType((PsiType)this.myType);
        String string = type2.getCanonicalText();
        if (string == null) {
            ExtractedParameter.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void addUsages(ExtractableExpressionPart patternPart) {
        this.myPatternUsages.add(patternPart.getUsage());
    }

    private boolean sameCandidate(ExtractableExpressionPart part) {
        return this.myCandidate.isEquivalent(part);
    }

    private boolean samePattern(ExtractableExpressionPart part) {
        return this.myPattern.isEquivalent(part);
    }

    public static List<Match> getCompatibleMatches(List<Match> matches, PsiElement[] pattern, List<PsiElement[]> candidates) {
        ArrayList<Match> result = new ArrayList<Match>();
        Set firstUsages = null;
        for (Match match : matches) {
            List<ExtractedParameter> parameters2 = match.getExtractedParameters();
            PsiElement[] candidateElements = (PsiElement[])ContainerUtil.find(candidates, elements -> ((PsiElement[])elements).length != 0 && match.getMatchStart() == elements[0]);
            Set candidateVariables = ContainerUtil.map2SetNotNull(parameters2, parameter2 -> parameter2.myCandidate.myVariable);
            if (candidateElements == null || ExtractedParameter.containsModifiedField(candidateElements, candidateVariables)) continue;
            Set patternUsages = StreamEx.of(parameters2).map(p -> p.myPattern.getUsage()).toSet();
            if (firstUsages == null) {
                Set patternVariables = ContainerUtil.map2SetNotNull(parameters2, parameter2 -> parameter2.myPattern.myVariable);
                if (ExtractedParameter.containsModifiedField(pattern, patternVariables)) {
                    return Collections.emptyList();
                }
                firstUsages = patternUsages;
                result.add(match);
                continue;
            }
            if (!firstUsages.equals(patternUsages)) continue;
            result.add(match);
        }
        return result;
    }

    private static boolean containsModifiedField(@NotNull PsiElement[] elements, Set<PsiVariable> variables) {
        Set fields;
        if (elements == null) {
            ExtractedParameter.$$$reportNull$$$0(9);
        }
        if (!(fields = ((StreamEx)StreamEx.of(variables).select(PsiField.class).filter(field -> !field.hasModifierProperty("final"))).toSet()).isEmpty()) {
            FieldModificationVisitor visitor = new FieldModificationVisitor(fields);
            for (PsiElement element : elements) {
                element.accept((PsiElementVisitor)visitor);
                if (!visitor.myModified) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternPart";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidatePart";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateUsage";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/duplicates/ExtractedParameter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/duplicates/ExtractedParameter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithCandidateUsage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalVariableTypeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyWithCandidateUsage";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsModifiedField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FieldModificationVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiField> myFields;
        private boolean myModified;

        FieldModificationVisitor(Set<PsiField> fields) {
            this.myFields = fields;
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            this.visitModifiedExpression(expression2.getLExpression());
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            IElementType op = expression2.getOperationTokenType();
            if (op == JavaTokenType.PLUSPLUS || op == JavaTokenType.MINUSMINUS) {
                this.visitModifiedExpression(expression2.getOperand());
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression expression2) {
            super.visitPostfixExpression(expression2);
            IElementType op = expression2.getOperationTokenType();
            if (op == JavaTokenType.PLUSPLUS || op == JavaTokenType.MINUSMINUS) {
                this.visitModifiedExpression(expression2.getOperand());
            }
        }

        private void visitModifiedExpression(PsiExpression modifiedExpression) {
            PsiField field;
            PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)modifiedExpression);
            if (expression2 instanceof PsiReferenceExpression && (field = (PsiField)ObjectUtils.tryCast((Object)((PsiReferenceExpression)expression2).resolve(), PsiField.class)) != null && this.myFields.contains(field)) {
                this.myModified = true;
                this.stopWalking();
            }
        }
    }
}

