/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class UnwrapCall
extends FixableUsageInfo {
    private final String myUnwrapMethod;

    public UnwrapCall(@NotNull PsiExpression call, @NotNull String unwrapMethod) {
        if (call == null) {
            UnwrapCall.$$$reportNull$$$0(0);
        }
        if (unwrapMethod == null) {
            UnwrapCall.$$$reportNull$$$0(1);
        }
        super((PsiElement)call);
        this.myUnwrapMethod = unwrapMethod;
    }

    public void fixUsage() throws IncorrectOperationException {
        PsiElement element = this.getElement();
        if (!(element instanceof PsiExpression)) {
            return;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiExpression expression2 = LambdaRefactoringUtil.convertToMethodCallInLambdaBody((PsiMethodReferenceExpression)element);
            if (expression2 == null) {
                return;
            }
            element = expression2;
        }
        String newExpression = element.getText() + '.' + this.myUnwrapMethod + "()";
        MutationUtils.replaceExpression(newExpression, (PsiExpression)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "unwrapMethod";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/wrapreturnvalue/usageInfo/UnwrapCall";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

