/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.FunctionalExpressionUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SuspiciousToArrayCallInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("suspicious.to.array.call.display.name", new Object[0]);
        if (string == null) {
            SuspiciousToArrayCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        PsiType foundType = (PsiType)infos[1];
        String string = InspectionGadgetsBundle.message("suspicious.to.array.call.problem.descriptor", type2.getCanonicalText(), foundType.getCanonicalText());
        if (string == null) {
            SuspiciousToArrayCallInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousToArrayCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/SuspiciousToArrayCallInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SuspiciousToArrayCallVisitor
    extends BaseInspectionVisitor {
        private SuspiciousToArrayCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiType argumentType;
            if (expression2 == null) {
                SuspiciousToArrayCallVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toArray".equals(methodName)) {
                return;
            }
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 == null) {
                return;
            }
            PsiType type2 = qualifierExpression2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiClassType classType = (PsiClassType)type2;
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Collection")) {
                PsiType itemType = GenericsUtil.getVariableTypeByExpressionType((PsiType)JavaGenericsUtil.getCollectionItemType((PsiType)classType, (GlobalSearchScope)expression2.getResolveScope()));
                this.checkArrayTypes(argument, expression2, argument.getType(), itemType);
            } else if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.Stream") && (argumentType = SuspiciousToArrayCallVisitor.getIntFunctionParameterType(argument)) != null) {
                this.checkArrayTypes(argument, expression2, argumentType, StreamApiUtil.getStreamElementType((PsiType)classType));
            }
        }

        private static PsiType getIntFunctionParameterType(PsiExpression argument) {
            PsiType argumentType = FunctionalExpressionUtils.getFunctionalExpressionType(argument);
            return PsiUtil.substituteTypeParameter((PsiType)argumentType, (String)"java.util.function.IntFunction", (int)0, (boolean)false);
        }

        private void checkArrayTypes(@NotNull PsiExpression argument, @NotNull PsiMethodCallExpression expression2, PsiType argumentType, PsiType itemType) {
            if (argument == null) {
                SuspiciousToArrayCallVisitor.$$$reportNull$$$0(1);
            }
            if (expression2 == null) {
                SuspiciousToArrayCallVisitor.$$$reportNull$$$0(2);
            }
            if (!(argumentType instanceof PsiArrayType)) {
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)argumentType;
            PsiType componentType = arrayType.getComponentType();
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)parent;
                PsiTypeElement castTypeElement = castExpression.getCastType();
                if (castTypeElement == null) {
                    return;
                }
                PsiType castType = castTypeElement.getType();
                if (castType.equals(arrayType) || !(castType instanceof PsiArrayType)) {
                    return;
                }
                PsiArrayType castArrayType = (PsiArrayType)castType;
                this.registerError((PsiElement)argument, castArrayType.getComponentType(), componentType);
            } else {
                PsiClassType classType;
                PsiClass aClass;
                if (itemType == null || componentType.isAssignableFrom(itemType)) {
                    return;
                }
                if (itemType instanceof PsiClassType && (aClass = (classType = (PsiClassType)itemType).resolve()) instanceof PsiTypeParameter) {
                    PsiTypeParameter typeParameter = (PsiTypeParameter)aClass;
                    PsiReferenceList extendsList = typeParameter.getExtendsList();
                    PsiClassType[] types = extendsList.getReferencedTypes();
                    if (types.length == 0) {
                        this.registerError((PsiElement)argument, TypeUtils.getObjectType((PsiElement)argument), componentType);
                    } else if (types.length == 1) {
                        this.registerError((PsiElement)argument, types[0], componentType);
                    }
                    return;
                }
                this.registerError((PsiElement)argument, itemType, componentType);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousToArrayCallInspection$SuspiciousToArrayCallVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkArrayTypes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

