/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ListenerMayUseAdapterInspection
extends BaseInspection {
    public boolean checkForEmptyMethods = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("listener.may.use.adapter.display.name", new Object[0]);
        if (string == null) {
            ListenerMayUseAdapterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String className = aClass.getName();
        String adapterName = (String)infos[1];
        String string = InspectionGadgetsBundle.message("listener.may.use.adapter.problem.descriptor", className, adapterName);
        if (string == null) {
            ListenerMayUseAdapterInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("listener.may.use.adapter.emtpy.methods.option", new Object[0]), (InspectionProfileEntry)this, "checkForEmptyMethods");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        String adapterName = (String)infos[1];
        return new ListenerMayUseAdapterFix(adapterName);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ListenerMayUseAdapterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/ListenerMayUseAdapterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ListenerMayUseAdapterVisitor
    extends BaseInspectionVisitor {
        private ListenerMayUseAdapterVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            PsiJavaCodeReferenceElement[] implementsReferences;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            PsiJavaCodeReferenceElement[] extendsReferences = extendsList.getReferenceElements();
            if (extendsReferences.length > 0) {
                return;
            }
            PsiReferenceList implementsList = aClass.getImplementsList();
            if (implementsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement implementsReference : implementsReferences = implementsList.getReferenceElements()) {
                this.checkReference(aClass, implementsReference);
            }
        }

        private void checkReference(@NotNull PsiClass aClass, @NotNull PsiJavaCodeReferenceElement implementsReference) {
            PsiElement target;
            if (aClass == null) {
                ListenerMayUseAdapterVisitor.$$$reportNull$$$0(0);
            }
            if (implementsReference == null) {
                ListenerMayUseAdapterVisitor.$$$reportNull$$$0(1);
            }
            if (!((target = implementsReference.resolve()) instanceof PsiClass)) {
                return;
            }
            PsiClass implementsClass = (PsiClass)target;
            String className = implementsClass.getQualifiedName();
            if (className == null || !className.endsWith("Listener")) {
                return;
            }
            PsiMethod[] interfaceMethods = implementsClass.getMethods();
            if (interfaceMethods.length < 2) {
                return;
            }
            boolean allDefault = true;
            for (PsiMethod interfaceMethod : interfaceMethods) {
                if (interfaceMethod.hasModifierProperty("default")) continue;
                allDefault = false;
                break;
            }
            if (allDefault) {
                return;
            }
            String adapterName = className.substring(0, className.length() - 8) + "Adapter";
            GlobalSearchScope scope = implementsClass.getResolveScope();
            PsiClass adapterClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass(adapterName, scope);
            if (adapterClass == null || adapterClass.equals(aClass) || !adapterClass.hasModifierProperty("abstract") || adapterClass.isDeprecated()) {
                return;
            }
            PsiReferenceList implementsList = adapterClass.getImplementsList();
            if (implementsList == null) {
                return;
            }
            PsiJavaCodeReferenceElement[] referenceElements = implementsList.getReferenceElements();
            boolean adapterImplementsListener = false;
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
                PsiElement implementsTarget = referenceElement.resolve();
                if (!implementsClass.equals(implementsTarget)) continue;
                adapterImplementsListener = true;
            }
            if (!adapterImplementsListener) {
                return;
            }
            if (ListenerMayUseAdapterInspection.this.checkForEmptyMethods) {
                PsiMethod[] methods;
                boolean emptyMethodFound = false;
                for (PsiMethod method : methods = aClass.getMethods()) {
                    PsiMethod[] superMethods;
                    PsiCodeBlock body2 = method.getBody();
                    if (!ControlFlowUtils.isEmptyCodeBlock(body2) || (superMethods = method.findSuperMethods(implementsClass)).length == 0) continue;
                    emptyMethodFound = true;
                    break;
                }
                if (!emptyMethodFound) {
                    return;
                }
            }
            this.registerError((PsiElement)implementsReference, aClass, adapterName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "implementsReference";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/classlayout/ListenerMayUseAdapterInspection$ListenerMayUseAdapterVisitor";
            objectArray[2] = "checkReference";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ListenerMayUseAdapterFix
    extends InspectionGadgetsFix {
        private final String adapterName;

        ListenerMayUseAdapterFix(@NotNull String adapterName) {
            if (adapterName == null) {
                ListenerMayUseAdapterFix.$$$reportNull$$$0(0);
            }
            this.adapterName = adapterName;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"extends " + this.adapterName});
            if (string == null) {
                ListenerMayUseAdapterFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with adapter" == null) {
                ListenerMayUseAdapterFix.$$$reportNull$$$0(2);
            }
            return "Replace with adapter";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)descriptor.getPsiElement();
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (aClass == null) {
                return;
            }
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length > 0) {
                PsiElement target = element.resolve();
                if (!(target instanceof PsiClass)) {
                    return;
                }
                PsiClass interfaceClass = (PsiClass)target;
                for (PsiMethod method : methods) {
                    PsiMethod[] superMethods;
                    if (!ControlFlowUtils.isEmptyCodeBlock(method.getBody()) || (superMethods = method.findSuperMethods(interfaceClass)).length <= 0) continue;
                    method.delete();
                }
            }
            element.delete();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiClass adapterClass = psiFacade.findClass(this.adapterName, aClass.getResolveScope());
            if (adapterClass == null) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = psiFacade.getElementFactory().createClassReferenceElement(adapterClass);
            extendsList.add((PsiElement)referenceElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "adapterName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/classlayout/ListenerMayUseAdapterInspection$ListenerMayUseAdapterFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/classlayout/ListenerMayUseAdapterInspection$ListenerMayUseAdapterFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

