/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForLoopWithMissingComponentInspection
extends BaseInspection {
    public boolean ignoreCollectionLoops = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.display.name", new Object[0]);
        if (string == null) {
            ForLoopWithMissingComponentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean hasInitializer = (Boolean)infos[0];
        boolean hasCondition = (Boolean)infos[1];
        boolean hasUpdate = (Boolean)infos[2];
        if (hasInitializer) {
            if (hasCondition) {
                String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor3", new Object[0]);
                if (string == null) {
                    ForLoopWithMissingComponentInspection.$$$reportNull$$$0(1);
                }
                return string;
            }
            if (hasUpdate) {
                String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor2", new Object[0]);
                if (string == null) {
                    ForLoopWithMissingComponentInspection.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor6", new Object[0]);
            if (string == null) {
                ForLoopWithMissingComponentInspection.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (hasCondition) {
            if (hasUpdate) {
                String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor1", new Object[0]);
                if (string == null) {
                    ForLoopWithMissingComponentInspection.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor5", new Object[0]);
            if (string == null) {
                ForLoopWithMissingComponentInspection.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (hasUpdate) {
            String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor4", new Object[0]);
            if (string == null) {
                ForLoopWithMissingComponentInspection.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor7", new Object[0]);
        if (string == null) {
            ForLoopWithMissingComponentInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("for.loop.with.missing.component.collection.loop.option", new Object[0]), (InspectionProfileEntry)this, "ignoreCollectionLoops");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopWithMissingComponentVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/ForLoopWithMissingComponentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ForLoopWithMissingComponentVisitor
    extends BaseInspectionVisitor {
        private ForLoopWithMissingComponentVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                ForLoopWithMissingComponentVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement);
            boolean hasCondition = this.hasCondition(statement);
            boolean hasInitializer = this.hasInitializer(statement);
            boolean hasUpdate = this.hasUpdate(statement);
            if (hasCondition && hasInitializer && hasUpdate) {
                return;
            }
            if (ForLoopWithMissingComponentInspection.this.ignoreCollectionLoops && this.isCollectionLoopStatement(statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, hasInitializer, hasCondition, hasUpdate);
        }

        private boolean hasCondition(PsiForStatement statement) {
            return statement.getCondition() != null;
        }

        private boolean hasInitializer(PsiForStatement statement) {
            PsiStatement initialization = statement.getInitialization();
            return initialization != null && !(initialization instanceof PsiEmptyStatement);
        }

        private boolean hasUpdate(PsiForStatement statement) {
            PsiStatement update2 = statement.getUpdate();
            return update2 != null && !(update2 instanceof PsiEmptyStatement);
        }

        private boolean isCollectionLoopStatement(PsiForStatement forStatement) {
            PsiStatement initialization = forStatement.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration2.getDeclaredElements();
            PsiExpression condition2 = forStatement.getCondition();
            for (PsiElement declaredElement : declaredElements) {
                if (!(declaredElement instanceof PsiVariable)) continue;
                PsiVariable variable = (PsiVariable)declaredElement;
                if (TypeUtils.variableHasTypeOrSubtype(variable, "java.util.ListIterator") && (this.isHasNext(condition2, variable) || this.isHasPrevious(condition2, variable))) {
                    return true;
                }
                if (!(TypeUtils.variableHasTypeOrSubtype(variable, "java.util.Iterator") ? this.isHasNext(condition2, variable) : TypeUtils.variableHasTypeOrSubtype(variable, "java.util.Enumeration") && this.isHasMoreElements(condition2, variable))) continue;
                return true;
            }
            return false;
        }

        private boolean isHasNext(PsiExpression condition2, PsiVariable iterator) {
            return this.isCallToBooleanZeroArgumentMethod("hasNext", condition2, iterator);
        }

        private boolean isHasPrevious(PsiExpression condition2, PsiVariable iterator) {
            return this.isCallToBooleanZeroArgumentMethod("hasPrevious", condition2, iterator);
        }

        private boolean isHasMoreElements(PsiExpression condition2, PsiVariable enumeration) {
            return this.isCallToBooleanZeroArgumentMethod("hasMoreElements", condition2, enumeration);
        }

        private boolean isCallToBooleanZeroArgumentMethod(String methodName, PsiExpression expression2, PsiVariable calledOn) {
            if (expression2 instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
                for (PsiExpression operand2 : polyadicExpression.getOperands()) {
                    if (!this.isCallToBooleanZeroArgumentMethod(methodName, operand2, calledOn)) continue;
                    return true;
                }
                return false;
            }
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            if (!MethodCallUtils.isCallToMethod(call, null, (PsiType)PsiType.BOOLEAN, methodName, new PsiType[0])) {
                return false;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return true;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            return calledOn.equals(target);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/ForLoopWithMissingComponentInspection$ForLoopWithMissingComponentVisitor", "visitForStatement"));
        }
    }
}

