/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoopConditionNotUpdatedInsideLoopInspection
extends BaseInspection {
    public boolean ignorePossibleNonLocalChanges = true;
    public boolean ignoreIterators = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("loop.condition.not.updated.inside.loop.display.name", new Object[0]);
        if (string == null) {
            LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean entireCondition = (Boolean)infos[0];
        if (entireCondition) {
            String string = InspectionGadgetsBundle.message("loop.condition.not.updated.inside.loop.problem.descriptor", new Object[0]);
            if (string == null) {
                LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("loop.variable.not.updated.inside.loop.problem.descriptor", new Object[0]);
        if (string == null) {
            LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            LoopConditionNotUpdatedInsideLoopInspection.$$$reportNull$$$0(3);
        }
        this.defaultWriteSettings(node, "ignorePossibleNonLocalChanges");
        this.writeBooleanOption(node, "ignorePossibleNonLocalChanges", true);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("loop.variable.not.updated.inside.loop.option.nonlocal", new Object[0]), (InspectionProfileEntry)this, "ignorePossibleNonLocalChanges");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoopConditionNotUpdatedInsideLoopVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LoopConditionNotUpdatedInsideLoopVisitor
    extends BaseInspectionVisitor {
        private LoopConditionNotUpdatedInsideLoopVisitor() {
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            this.check(condition2, (PsiLoopStatement)statement);
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            super.visitDoWhileStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            this.check(condition2, (PsiLoopStatement)statement);
        }

        public void visitForStatement(PsiForStatement statement) {
            super.visitForStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            this.check(condition2, (PsiLoopStatement)statement);
        }

        private void check(@Nullable PsiExpression condition2, @NotNull PsiLoopStatement statement) {
            if (statement == null) {
                LoopConditionNotUpdatedInsideLoopVisitor.$$$reportNull$$$0(0);
            }
            SmartList notUpdated = new SmartList();
            PsiStatement body2 = statement.getBody();
            if (body2 == null || condition2 == null || SideEffectChecker.mayHaveSideEffects(condition2)) {
                return;
            }
            if (LoopConditionNotUpdatedInsideLoopInspection.this.ignorePossibleNonLocalChanges && !ExpressionUtils.isLocallyDefinedExpression(condition2)) {
                PsiStatement update2;
                if (SideEffectChecker.mayHaveNonLocalSideEffects((PsiElement)body2)) {
                    return;
                }
                if (statement instanceof PsiForStatement && (update2 = ((PsiForStatement)statement).getUpdate()) != null && SideEffectChecker.mayHaveNonLocalSideEffects((PsiElement)update2)) {
                    return;
                }
            }
            if (this.isConditionNotUpdated(condition2, (PsiStatement)statement, (List<? super PsiExpression>)notUpdated)) {
                if (!ControlFlowUtils.statementMayCompleteNormally(body2) && !ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement)) {
                    return;
                }
                if (notUpdated.isEmpty()) {
                    if (!BoolUtils.isBooleanLiteral(condition2)) {
                        this.registerError((PsiElement)condition2, Boolean.TRUE);
                    }
                } else {
                    for (PsiExpression expression2 : notUpdated) {
                        this.registerError((PsiElement)expression2, Boolean.FALSE);
                    }
                }
            }
        }

        private boolean isConditionNotUpdated(@Nullable PsiExpression condition2, @NotNull PsiStatement context, List<? super PsiExpression> notUpdated) {
            if (context == null) {
                LoopConditionNotUpdatedInsideLoopVisitor.$$$reportNull$$$0(1);
            }
            if (condition2 == null) {
                return false;
            }
            if (PsiUtil.isConstantExpression((PsiExpression)condition2) || ExpressionUtils.isNullLiteral(condition2)) {
                return true;
            }
            if (condition2 instanceof PsiInstanceOfExpression) {
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)condition2;
                PsiExpression operand2 = instanceOfExpression.getOperand();
                return this.isConditionNotUpdated(operand2, context, notUpdated);
            }
            if (condition2 instanceof PsiParenthesizedExpression) {
                PsiExpression expression2 = ((PsiParenthesizedExpression)condition2).getExpression();
                return this.isConditionNotUpdated(expression2, context, notUpdated);
            }
            if (condition2 instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition2;
                for (PsiExpression operand3 : polyadicExpression.getOperands()) {
                    if (this.isConditionNotUpdated(operand3, context, notUpdated)) continue;
                    return false;
                }
                return true;
            }
            if (condition2 instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)condition2;
                PsiElement element = referenceExpression.resolve();
                if (element instanceof PsiField) {
                    PsiField field = (PsiField)element;
                    PsiType type2 = field.getType();
                    if (field.hasModifierProperty("final") && type2.getArrayDimensions() == 0) {
                        if (field.hasModifierProperty("static")) {
                            return true;
                        }
                        PsiExpression qualifier = referenceExpression.getQualifierExpression();
                        if (qualifier == null) {
                            return true;
                        }
                        if (this.isConditionNotUpdated(qualifier, context, notUpdated)) {
                            return true;
                        }
                    }
                } else if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
                    boolean arrayUpdated;
                    PsiVariable variable = (PsiVariable)element;
                    boolean isFinal = variable.hasModifierProperty("final");
                    PsiType type3 = variable.getType();
                    boolean bl = arrayUpdated = type3 instanceof PsiArrayType && VariableAccessUtils.arrayContentsAreAssigned(variable, (PsiElement)context);
                    if (!(!isFinal && VariableAccessUtils.variableIsAssigned(variable, (PsiElement)context) || arrayUpdated)) {
                        if (!isFinal) {
                            notUpdated.add((PsiExpression)referenceExpression);
                        }
                        return true;
                    }
                }
            } else if (condition2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition2;
                if (!PsiUtil.isIncrementDecrementOperation((PsiElement)prefixExpression)) {
                    PsiExpression operand4 = prefixExpression.getOperand();
                    return this.isConditionNotUpdated(operand4, context, notUpdated);
                }
            } else {
                if (condition2 instanceof PsiArrayAccessExpression) {
                    PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)condition2;
                    PsiExpression indexExpression = accessExpression.getIndexExpression();
                    return this.isConditionNotUpdated(indexExpression, context, notUpdated) && this.isConditionNotUpdated(accessExpression.getArrayExpression(), context, notUpdated);
                }
                if (condition2 instanceof PsiConditionalExpression) {
                    PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)condition2;
                    PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
                    PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
                    if (thenExpression2 == null || elseExpression2 == null) {
                        return false;
                    }
                    return this.isConditionNotUpdated(conditionalExpression.getCondition(), context, notUpdated) && this.isConditionNotUpdated(thenExpression2, context, notUpdated) && this.isConditionNotUpdated(elseExpression2, context, notUpdated);
                }
                if (condition2 instanceof PsiMethodCallExpression) {
                    PsiExpression qualifier = ((PsiMethodCallExpression)condition2).getMethodExpression().getQualifierExpression();
                    if (!this.isConditionNotUpdated(qualifier, context, notUpdated)) {
                        return false;
                    }
                    for (PsiExpression arg : ((PsiMethodCallExpression)condition2).getArgumentList().getExpressions()) {
                        if (this.isConditionNotUpdated(arg, context, notUpdated)) continue;
                        return false;
                    }
                    return true;
                }
                if (condition2 instanceof PsiTypeCastExpression) {
                    return this.isConditionNotUpdated(((PsiTypeCastExpression)condition2).getOperand(), context, notUpdated);
                }
                if (condition2 instanceof PsiThisExpression || condition2 instanceof PsiClassObjectAccessExpression) {
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/LoopConditionNotUpdatedInsideLoopInspection$LoopConditionNotUpdatedInsideLoopVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "check";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isConditionNotUpdated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

