/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TooBroadThrowsInspection
extends BaseInspection {
    public boolean onlyWarnOnRootExceptions = false;
    public boolean ignoreInTestCode = false;
    public boolean ignoreLibraryOverrides = false;
    public boolean ignoreThrown = false;

    @NotNull
    public String getID() {
        if ("OverlyBroadThrowsClause" == null) {
            TooBroadThrowsInspection.$$$reportNull$$$0(0);
        }
        return "OverlyBroadThrowsClause";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overly.broad.throws.clause.display.name", new Object[0]);
        if (string == null) {
            TooBroadThrowsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String typesMaskedString;
        List typesMasked = (List)infos[0];
        PsiType type2 = ((SmartTypePointer)typesMasked.get(0)).getType();
        String string = typesMaskedString = type2 != null ? type2.getPresentableText() : "";
        if (typesMasked.size() == 1) {
            String string2 = InspectionGadgetsBundle.message("overly.broad.throws.clause.problem.descriptor1", typesMaskedString);
            if (string2 == null) {
                TooBroadThrowsInspection.$$$reportNull$$$0(2);
            }
            return string2;
        }
        int lastTypeIndex = typesMasked.size() - 1;
        for (int i = 1; i < lastTypeIndex; ++i) {
            PsiType psiType = ((SmartTypePointer)typesMasked.get(i)).getType();
            if (psiType == null) continue;
            typesMaskedString = typesMaskedString + ", ";
            typesMaskedString = typesMaskedString + psiType.getPresentableText();
        }
        PsiType psiType = ((SmartTypePointer)typesMasked.get(lastTypeIndex)).getType();
        String lastTypeString = psiType != null ? psiType.getPresentableText() : "";
        String string3 = InspectionGadgetsBundle.message("overly.broad.throws.clause.problem.descriptor2", typesMaskedString, lastTypeString);
        if (string3 == null) {
            TooBroadThrowsInspection.$$$reportNull$$$0(3);
        }
        return string3;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("too.broad.catch.option", new Object[0]), "onlyWarnOnRootExceptions");
        panel.addCheckbox(InspectionGadgetsBundle.message("ignore.exceptions.declared.on.library.override.option", new Object[0]), "ignoreLibraryOverrides");
        panel.addCheckbox(InspectionGadgetsBundle.message("overly.broad.throws.clause.ignore.thrown.option", new Object[0]), "ignoreThrown");
        return panel;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Collection maskedExceptions = (Collection)infos[0];
        Boolean originalNeeded = (Boolean)infos[1];
        AddThrowsClauseFix addThrowsClauseFix = new AddThrowsClauseFix(maskedExceptions, originalNeeded);
        if (addThrowsClauseFix == null) {
            TooBroadThrowsInspection.$$$reportNull$$$0(4);
        }
        return addThrowsClauseFix;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiElement context = (PsiElement)infos[2];
        SuppressForTestsScopeFix suppressFix = SuppressForTestsScopeFix.build(this, context);
        if (suppressFix == null) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{this.buildFix(infos)};
            if (inspectionGadgetsFixArray == null) {
                TooBroadThrowsInspection.$$$reportNull$$$0(5);
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{this.buildFix(infos), suppressFix};
        if (inspectionGadgetsFixArray == null) {
            TooBroadThrowsInspection.$$$reportNull$$$0(6);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TooBroadThrowsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/TooBroadThrowsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class TooBroadThrowsVisitor
    extends BaseInspectionVisitor {
        private TooBroadThrowsVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiReferenceList throwsList = method.getThrowsList();
            if (!throwsList.isPhysical()) {
                return;
            }
            PsiJavaCodeReferenceElement[] throwsReferences = throwsList.getReferenceElements();
            if (throwsReferences.length == 0) {
                return;
            }
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null) {
                return;
            }
            if (TooBroadThrowsInspection.this.ignoreLibraryOverrides && LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            Set<PsiClassType> exceptionsThrown = ExceptionUtils.calculateExceptionsThrown((PsiElement)body2);
            Object[] referencedExceptions = throwsList.getReferencedTypes();
            HashSet exceptionsDeclared = new HashSet(referencedExceptions.length);
            ContainerUtil.addAll(exceptionsDeclared, (Object[])referencedExceptions);
            int referencedExceptionsLength = referencedExceptions.length;
            for (int i = 0; i < referencedExceptionsLength; ++i) {
                Object referencedException = referencedExceptions[i];
                if (TooBroadThrowsInspection.this.onlyWarnOnRootExceptions && !ExceptionUtils.isGenericExceptionClass((PsiType)referencedException)) continue;
                ArrayList<SmartTypePointer> exceptionsMasked = new ArrayList<SmartTypePointer>();
                SmartTypePointerManager pointerManager = SmartTypePointerManager.getInstance((Project)body2.getProject());
                for (PsiType psiType : exceptionsThrown) {
                    if (!referencedException.isAssignableFrom(psiType) || exceptionsDeclared.contains(psiType)) continue;
                    exceptionsMasked.add(pointerManager.createSmartTypePointer(psiType));
                }
                if (exceptionsMasked.isEmpty()) continue;
                PsiJavaCodeReferenceElement throwsReference = throwsReferences[i];
                boolean bl = exceptionsThrown.contains(referencedException);
                if (TooBroadThrowsInspection.this.ignoreThrown && bl) continue;
                this.registerError((PsiElement)throwsReference, exceptionsMasked, bl, throwsReference);
            }
        }
    }

    private static class AddThrowsClauseFix
    extends InspectionGadgetsFix {
        private final Collection<? extends SmartTypePointer> types;
        private final boolean originalNeeded;

        AddThrowsClauseFix(Collection<? extends SmartTypePointer> types, boolean originalNeeded) {
            this.types = types;
            this.originalNeeded = originalNeeded;
        }

        @NotNull
        public String getName() {
            if (this.originalNeeded) {
                String string = InspectionGadgetsBundle.message("overly.broad.throws.clause.quickfix1", new Object[0]);
                if (string == null) {
                    AddThrowsClauseFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("overly.broad.throws.clause.quickfix2", new Object[0]);
            if (string == null) {
                AddThrowsClauseFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Fix 'throws' clause" == null) {
                AddThrowsClauseFix.$$$reportNull$$$0(2);
            }
            return "Fix 'throws' clause";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiReferenceList)) {
                return;
            }
            PsiReferenceList referenceList = (PsiReferenceList)parent;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            if (!this.originalNeeded) {
                element.delete();
            }
            for (SmartTypePointer smartTypePointer : this.types) {
                PsiType psiType = smartTypePointer.getType();
                if (!(psiType instanceof PsiClassType)) continue;
                PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByType((PsiClassType)psiType);
                referenceList.add((PsiElement)referenceElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/errorhandling/TooBroadThrowsInspection$AddThrowsClauseFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

