/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryInitCauseInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryInitCauseFix();
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.initcause.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryInitCauseInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.initcause.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryInitCauseInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryInitCauseVisitor();
    }

    @Nullable
    static PsiNewExpression findNewExpression(PsiExpression expression2) {
        if (expression2 instanceof PsiNewExpression) {
            return (PsiNewExpression)expression2;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiExpression definition = DeclarationSearchUtils.findDefinition(referenceExpression, null);
            if (!(definition instanceof PsiNewExpression)) {
                return null;
            }
            return (PsiNewExpression)definition;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/UnnecessaryInitCauseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryInitCauseVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryInitCauseVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"initCause".equals(name)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression argument = ExpressionUtils.getOnlyExpressionInList(argumentList);
            if (!TypeUtils.expressionHasTypeOrSubtype(argument, "java.lang.Throwable")) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null || !"java.lang.Throwable".equals(aClass.getQualifiedName())) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            PsiNewExpression newExpression = UnnecessaryInitCauseInspection.findNewExpression(qualifier);
            if (!UnnecessaryInitCauseVisitor.isCauseConstructorAvailable(newExpression, argument.getType()) || !UnnecessaryInitCauseVisitor.canExpressionBeMovedBackwards(argument, (PsiExpression)newExpression)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean canExpressionBeMovedBackwards(final PsiExpression cause, PsiExpression newLocation) {
            if (cause == null || newLocation == null) {
                return false;
            }
            assert (cause.getTextOffset() > newLocation.getTextOffset());
            final PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)cause, PsiCodeBlock.class);
            PsiCodeBlock newBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)newLocation, PsiCodeBlock.class);
            if (newBlock == null || !PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)newBlock, (boolean)false)) {
                return false;
            }
            final int offset = newLocation.getTextOffset();
            final Ref result = new Ref((Object)Boolean.TRUE);
            cause.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    PsiElement[] defs;
                    if (!((Boolean)result.get()).booleanValue()) {
                        return;
                    }
                    super.visitReferenceExpression(expression2);
                    PsiElement target = expression2.resolve();
                    if (!(target instanceof PsiVariable)) {
                        return;
                    }
                    for (PsiElement def : defs = DefUseUtil.getDefs(block, (PsiVariable)target, (PsiElement)cause)) {
                        if (def.getTextOffset() <= offset) continue;
                        result.set((Object)Boolean.FALSE);
                    }
                }
            });
            return (Boolean)result.get();
        }

        public static boolean isCauseConstructorAvailable(PsiNewExpression newExpression, PsiType causeType) {
            if (newExpression == null || causeType == null) {
                return false;
            }
            PsiMethod constructor = newExpression.resolveConstructor();
            if (constructor == null) {
                return false;
            }
            PsiClass aClass = constructor.getContainingClass();
            if (aClass == null) {
                return false;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return false;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            block0: for (PsiMethod constructor1 : aClass.getConstructors()) {
                PsiParameterList parameterList = constructor1.getParameterList();
                if (parameterList.getParametersCount() != arguments.length + 1) continue;
                PsiParameter[] parameters2 = parameterList.getParameters();
                for (int i = 0; i < arguments.length; ++i) {
                    PsiExpression argument = arguments[i];
                    PsiParameter parameter2 = parameters2[i];
                    PsiType type2 = argument.getType();
                    if (type2 == null || !parameter2.getType().isAssignableFrom(type2)) continue block0;
                }
                PsiParameter lastParameter = parameters2[parameters2.length - 1];
                if (!lastParameter.getType().isAssignableFrom(causeType) || !PsiUtil.isAccessible((PsiMember)constructor1, (PsiElement)newExpression, null)) continue;
                return true;
            }
            return false;
        }
    }

    private static class UnnecessaryInitCauseFix
    extends InspectionGadgetsFix {
        private UnnecessaryInitCauseFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.initcause.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryInitCauseFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement parent;
            PsiElement element = descriptor.getPsiElement().getParent().getParent();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression argument = ExpressionUtils.getFirstExpressionInList(argumentList);
            if (argument == null) {
                return;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (qualifier == null) {
                return;
            }
            PsiNewExpression newExpression = UnnecessaryInitCauseInspection.findNewExpression(qualifier);
            if (newExpression == null) {
                return;
            }
            PsiExpressionList argumentList1 = newExpression.getArgumentList();
            if (argumentList1 == null) {
                return;
            }
            PsiElement newElement = argumentList1.add((PsiElement)argument);
            if (this.isOnTheFly()) {
                HighlightUtils.highlightElement(newElement);
            }
            if ((parent = methodCallExpression.getParent()) instanceof PsiExpressionStatement) {
                parent.delete();
            } else {
                methodCallExpression.replace((PsiElement)qualifier);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/UnnecessaryInitCauseInspection$UnnecessaryInitCauseFix", "getFamilyName"));
        }
    }
}

