/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.fixes.AddArgumentFix;
import com.siyeh.ig.internationalization.NonNlsUtils;
import java.util.ArrayList;
import java.util.Objects;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class StringToUpperWithoutLocaleInspection
extends BaseInspection {
    private static final CallMatcher MATCHER = CallMatcher.instanceCall("java.lang.String", "toUpperCase", "toLowerCase").parameterCount(0);

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("StringToUpperCaseOrToLowerCaseWithoutLocale" == null) {
            StringToUpperWithoutLocaleInspection.$$$reportNull$$$0(0);
        }
        return "StringToUpperCaseOrToLowerCaseWithoutLocale";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.touppercase.tolowercase.without.locale.display.name", new Object[0]);
        if (string == null) {
            StringToUpperWithoutLocaleInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.touppercase.tolowercase.without.locale.problem.descriptor", new Object[0]);
        if (string == null) {
            StringToUpperWithoutLocaleInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiReferenceExpression methodExpression = (PsiReferenceExpression)infos[0];
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>(2);
        PsiModifierListOwner annotatableQualifier = NonNlsUtils.getAnnotatableQualifier(methodExpression);
        fixes.add(new AddArgumentFix("java.util.Locale.ENGLISH", "Locale.ENGLISH"));
        if (annotatableQualifier != null) {
            fixes.add(new DelegatingFix((LocalQuickFix)new AddAnnotationPsiFix("org.jetbrains.annotations.NonNls", annotatableQualifier, PsiNameValuePair.EMPTY_ARRAY, new String[0])));
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            StringToUpperWithoutLocaleInspection.$$$reportNull$$$0(3);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringToUpperWithoutLocaleVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/internationalization/StringToUpperWithoutLocaleInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StringToUpperWithoutLocaleVisitor
    extends BaseInspectionVisitor {
        private StringToUpperWithoutLocaleVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                StringToUpperWithoutLocaleVisitor.$$$reportNull$$$0(0);
            }
            if (!MATCHER.test(expression2)) {
                return;
            }
            PsiExpression qualifier = expression2.getMethodExpression().getQualifierExpression();
            if (NonNlsUtils.isNonNlsAnnotatedUse((PsiExpression)expression2) || NonNlsUtils.isNonNlsAnnotated(qualifier)) {
                return;
            }
            this.registerMethodCallError(expression2, expression2.getMethodExpression());
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            if (!MATCHER.methodReferenceMatches(expression2)) {
                return;
            }
            PsiExpression qualifier = expression2.getQualifierExpression();
            if (NonNlsUtils.isNonNlsAnnotatedUse(qualifier) || NonNlsUtils.isNonNlsAnnotated(qualifier)) {
                return;
            }
            PsiElement nameElement = Objects.requireNonNull(expression2.getReferenceNameElement());
            this.registerError(nameElement, expression2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/internationalization/StringToUpperWithoutLocaleInspection$StringToUpperWithoutLocaleVisitor", "visitMethodCallExpression"));
        }
    }
}

