/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;

class ShiftUtils {
    private ShiftUtils() {
    }

    public static boolean isPowerOfTwo(PsiExpression rhs) {
        if (!(rhs instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literal = (PsiLiteralExpression)rhs;
        Object value2 = literal.getValue();
        if (!(value2 instanceof Number)) {
            return false;
        }
        if (value2 instanceof Double || value2 instanceof Float) {
            return false;
        }
        int intValue = ((Number)value2).intValue();
        if (intValue <= 1) {
            return false;
        }
        while (intValue % 2 == 0) {
            intValue >>= 1;
        }
        return intValue == 1;
    }

    public static int getLogBaseTwo(PsiLiteralExpression rhs) {
        Object value2 = rhs.getValue();
        int log = 0;
        if (value2 == null) {
            return log;
        }
        int intValue = ((Number)value2).intValue();
        while (intValue % 2 == 0) {
            intValue >>= 1;
            ++log;
        }
        return log;
    }
}

