/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.CreatePackageInfoAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.BaseSharedLocalInspection;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingPackageInfoInspection
extends BaseGlobalInspection {
    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new LocalMissingPackageInfoInspection(this);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("missing.package.info.display.name", new Object[0]);
        if (string == null) {
            MissingPackageInfoInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            MissingPackageInfoInspection.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            MissingPackageInfoInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            MissingPackageInfoInspection.$$$reportNull$$$0(3);
        }
        if (globalContext == null) {
            MissingPackageInfoInspection.$$$reportNull$$$0(4);
        }
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        RefPackage refPackage = (RefPackage)refEntity;
        String packageName = refPackage.getQualifiedName();
        Project project = globalContext.getProject();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        if (MissingPackageInfoInspection.hasPackageInfoFile(aPackage)) {
            return null;
        }
        List children = refPackage.getChildren();
        boolean hasClasses = false;
        for (RefEntity child : children) {
            if (!(child instanceof RefClass)) continue;
            hasClasses = true;
            break;
        }
        if (!hasClasses) {
            return null;
        }
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)aPackage)) {
            return new CommonProblemDescriptor[]{manager.createProblemDescriptor(InspectionGadgetsBundle.message("missing.package.info.problem.descriptor", packageName), new QuickFix[0])};
        }
        return new CommonProblemDescriptor[]{manager.createProblemDescriptor(InspectionGadgetsBundle.message("missing.package.html.problem.descriptor", packageName), new QuickFix[0])};
    }

    @Contract(value="null -> true")
    static boolean hasPackageInfoFile(PsiPackage aPackage) {
        PsiDirectory[] directories;
        if (aPackage == null) {
            return true;
        }
        for (PsiDirectory directory : directories = aPackage.getDirectories()) {
            boolean packageDotHtmlFound;
            boolean packageInfoFound = directory.findFile("package-info.java") != null;
            boolean bl = packageDotHtmlFound = directory.findFile("package.html") != null;
            if (!packageInfoFound && !packageDotHtmlFound) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/javadoc/MissingPackageInfoInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/javadoc/MissingPackageInfoInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LocalMissingPackageInfoInspection
    extends BaseSharedLocalInspection<MissingPackageInfoInspection> {
        LocalMissingPackageInfoInspection(MissingPackageInfoInspection settingsDelegate) {
            super(settingsDelegate);
        }

        @Override
        @Nullable
        protected InspectionGadgetsFix buildFix(Object ... infos) {
            return new InspectionGadgetsFix(){

                @NotNull
                public String getFamilyName() {
                    if ("Create 'package-info.java'" == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return "Create 'package-info.java'";
                }

                public boolean startInWriteAction() {
                    return false;
                }

                @Override
                protected void doFix(Project project, ProblemDescriptor descriptor) {
                    DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
                        AnActionEvent event = new AnActionEvent(null, context, "", new Presentation(), ActionManager.getInstance(), 0);
                        new CreatePackageInfoAction().actionPerformed(event);
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/MissingPackageInfoInspection$LocalMissingPackageInfoInspection$1", "getFamilyName"));
                }
            };
        }

        @Override
        @NotNull
        protected String buildErrorString(Object ... infos) {
            PsiPackageStatement packageStatement = (PsiPackageStatement)infos[0];
            if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)packageStatement)) {
                String string = InspectionGadgetsBundle.message("missing.package.info.problem.descriptor", packageStatement.getPackageName());
                if (string == null) {
                    LocalMissingPackageInfoInspection.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("missing.package.html.problem.descriptor", packageStatement.getPackageName());
            if (string == null) {
                LocalMissingPackageInfoInspection.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public BaseInspectionVisitor buildVisitor() {
            return new BaseInspectionVisitor(){

                public void visitJavaFile(PsiJavaFile file) {
                    PsiPackageStatement packageStatement = file.getPackageStatement();
                    if (packageStatement == null) {
                        return;
                    }
                    PsiJavaCodeReferenceElement packageReference = packageStatement.getPackageReference();
                    PsiElement target = packageReference.resolve();
                    if (!(target instanceof PsiPackage)) {
                        return;
                    }
                    PsiPackage aPackage = (PsiPackage)target;
                    if (MissingPackageInfoInspection.hasPackageInfoFile(aPackage)) {
                        return;
                    }
                    this.registerError((PsiElement)packageReference, packageStatement);
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/MissingPackageInfoInspection$LocalMissingPackageInfoInspection", "buildErrorString"));
        }
    }
}

