/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.NCSSVisitor;
import org.jetbrains.annotations.NotNull;

public class OverlyLongLambdaInspection
extends MethodMetricInspection {
    private static final int DEFAULT_LIMIT = 3;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overly.long.lambda.display.name", new Object[0]);
        if (string == null) {
            OverlyLongLambdaInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 3;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("non.comment.source.statements.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer statementCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("overly.long.lambda.problem.descriptor", statementCount);
        if (string == null) {
            OverlyLongLambdaInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyLongLambdaVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/methodmetrics/OverlyLongLambdaInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class OverlyLongLambdaVisitor
    extends BaseInspectionVisitor {
        private OverlyLongLambdaVisitor() {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
            PsiElement body2 = expression2.getBody();
            if (!(body2 instanceof PsiCodeBlock)) {
                return;
            }
            PsiCodeBlock block = (PsiCodeBlock)body2;
            PsiJavaToken brace = block.getLBrace();
            if (brace == null) {
                return;
            }
            NCSSVisitor visitor = new NCSSVisitor();
            block.accept((PsiElementVisitor)visitor);
            int count = visitor.getStatementCount();
            if (count <= OverlyLongLambdaInspection.this.getLimit()) {
                return;
            }
            this.registerErrorAtOffset((PsiElement)expression2, 0, body2.getStartOffsetInParent() + 1, count);
        }
    }
}

