/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryTemporaryOnConversionFromStringInspection
extends BaseInspection {
    @NonNls
    private static final Map<String, String> s_conversionMap = new HashMap<String, String>(7);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.from.string.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryTemporaryOnConversionFromStringInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String replacementString = UnnecessaryTemporaryOnConversionFromStringInspection.calculateReplacementExpression((PsiMethodCallExpression)infos[0], new CommentTracker());
        String string = InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.from.string.problem.descriptor", replacementString);
        if (string == null) {
            UnnecessaryTemporaryOnConversionFromStringInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    @NonNls
    static String calculateReplacementExpression(PsiMethodCallExpression expression2, CommentTracker commentTracker) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiNewExpression qualifier = (PsiNewExpression)ObjectUtils.tryCast((Object)methodExpression.getQualifierExpression(), PsiNewExpression.class);
        if (qualifier == null) {
            return null;
        }
        PsiExpressionList argumentList = qualifier.getArgumentList();
        if (argumentList == null || argumentList.getExpressionCount() != 1) {
            return null;
        }
        PsiExpression arg = argumentList.getExpressions()[0];
        PsiType type2 = qualifier.getType();
        if (type2 == null) {
            return null;
        }
        String qualifierType = type2.getPresentableText();
        String canonicalType = type2.getCanonicalText();
        String conversionName = s_conversionMap.get(canonicalType);
        if (TypeUtils.typeEquals("java.lang.Boolean", type2)) {
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression2)) {
                return qualifierType + '.' + conversionName + '(' + commentTracker.text((PsiElement)arg) + ").booleanValue()";
            }
            return qualifierType + ".parseBoolean(" + commentTracker.text((PsiElement)arg) + ')';
        }
        return qualifierType + '.' + conversionName + '(' + commentTracker.text((PsiElement)arg) + ')';
    }

    @Override
    @Nullable
    public InspectionGadgetsFix buildFix(Object ... infos) {
        String replacementExpression = UnnecessaryTemporaryOnConversionFromStringInspection.calculateReplacementExpression((PsiMethodCallExpression)infos[0], new CommentTracker());
        if (replacementExpression == null) {
            return null;
        }
        String name = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{replacementExpression});
        return new UnnecessaryTemporaryObjectFix(name);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryTemporaryObjectVisitor();
    }

    static {
        s_conversionMap.put("java.lang.Boolean", "valueOf");
        s_conversionMap.put("java.lang.Byte", "parseByte");
        s_conversionMap.put("java.lang.Double", "parseDouble");
        s_conversionMap.put("java.lang.Float", "parseFloat");
        s_conversionMap.put("java.lang.Integer", "parseInt");
        s_conversionMap.put("java.lang.Long", "parseLong");
        s_conversionMap.put("java.lang.Short", "parseShort");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionFromStringInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryTemporaryObjectVisitor
    extends BaseInspectionVisitor {
        @NonNls
        private static final Map<String, String> s_basicTypeMap = new HashMap<String, String>(7);

        private UnnecessaryTemporaryObjectVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                UnnecessaryTemporaryObjectVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            Map<String, String> basicTypeMap = s_basicTypeMap;
            if (!basicTypeMap.containsValue(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)qualifier;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiType argumentType = arguments[0].getType();
            if (!TypeUtils.isJavaLangString(argumentType)) {
                return;
            }
            PsiType type2 = qualifier.getType();
            if (type2 == null) {
                return;
            }
            String typeText = type2.getCanonicalText();
            if (!basicTypeMap.containsKey(typeText)) {
                return;
            }
            String mappingMethod = basicTypeMap.get(typeText);
            if (!mappingMethod.equals(methodName)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        static {
            s_basicTypeMap.put("java.lang.Boolean", "booleanValue");
            s_basicTypeMap.put("java.lang.Byte", "byteValue");
            s_basicTypeMap.put("java.lang.Double", "doubleValue");
            s_basicTypeMap.put("java.lang.Float", "floatValue");
            s_basicTypeMap.put("java.lang.Integer", "intValue");
            s_basicTypeMap.put("java.lang.Long", "longValue");
            s_basicTypeMap.put("java.lang.Short", "shortValue");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionFromStringInspection$UnnecessaryTemporaryObjectVisitor", "visitMethodCallExpression"));
        }
    }

    private static class UnnecessaryTemporaryObjectFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private UnnecessaryTemporaryObjectFix(String name) {
            this.m_name = name;
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
            if (string == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            CommentTracker commentTracker;
            PsiMethodCallExpression expression2 = (PsiMethodCallExpression)descriptor.getPsiElement();
            String newExpression = UnnecessaryTemporaryOnConversionFromStringInspection.calculateReplacementExpression(expression2, commentTracker = new CommentTracker());
            if (newExpression == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionFromStringInspection$UnnecessaryTemporaryObjectFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

