/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.canBeFinal.CanBeFinalHandler;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import com.siyeh.ig.psiutils.FinalUtils;
import org.jetbrains.annotations.NotNull;

public class FieldMayBeFinalInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("field.may.be.final.display.name", new Object[0]);
        if (string == null) {
            FieldMayBeFinalInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("field.may.be.final.problem.descriptor", new Object[0]);
        if (string == null) {
            FieldMayBeFinalInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return MakeFieldFinalFix.buildFixUnconditional((PsiField)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldMayBeFinalVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/FieldMayBeFinalInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class FieldMayBeFinalVisitor
    extends BaseInspectionVisitor {
        private FieldMayBeFinalVisitor() {
        }

        public void visitField(PsiField field) {
            PsiClass aClass;
            super.visitField(field);
            if (field.hasModifierProperty("final")) {
                return;
            }
            if (!(field.hasModifierProperty("private") || (aClass = field.getContainingClass()) != null && PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass))) {
                return;
            }
            if (!CanBeFinalHandler.allowToBeFinal((PsiMember)field)) {
                return;
            }
            if (!FinalUtils.canBeFinal((PsiVariable)field)) {
                return;
            }
            this.registerVariableError((PsiVariable)field, field);
        }
    }
}

