/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryInterfaceModifierInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    private static final Set<String> INTERFACE_REDUNDANT_MODIFIERS = new HashSet<String>(Arrays.asList("abstract", "static"));
    private static final Set<String> INNER_CLASS_REDUNDANT_MODIFIERS = new HashSet<String>(Arrays.asList("public", "static"));
    private static final Set<String> INNER_INTERFACE_REDUNDANT_MODIFIERS = new HashSet<String>(Arrays.asList("public", "abstract", "static"));
    private static final Set<String> FIELD_REDUNDANT_MODIFIERS = new HashSet<String>(Arrays.asList("public", "static", "final"));
    private static final Set<String> METHOD_REDUNDANT_MODIFIERS = new HashSet<String>(Arrays.asList("public", "abstract"));

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.interface.modifier.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryInterfaceModifierInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiModifierList modifierList = (PsiModifierList)infos[1];
        PsiElement parent = modifierList.getParent();
        if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass != null) {
                if (aClass.isInterface()) {
                    String string = InspectionGadgetsBundle.message("unnecessary.interface.modifier.inner.interface.of.interface.problem.descriptor", new Object[0]);
                    if (string == null) {
                        UnnecessaryInterfaceModifierInspection.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = InspectionGadgetsBundle.message("unnecessary.interface.modifier.problem.descriptor3", new Object[0]);
                if (string == null) {
                    UnnecessaryInterfaceModifierInspection.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("unnecessary.interface.modifier.problem.descriptor", new Object[0]);
            if (string == null) {
                UnnecessaryInterfaceModifierInspection.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (parent instanceof PsiMethod) {
            String string = InspectionGadgetsBundle.message("unnecessary.interface.modifier.problem.descriptor2", new Object[0]);
            if (string == null) {
                UnnecessaryInterfaceModifierInspection.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.interface.modifier.problem.descriptor4", new Object[0]);
        if (string == null) {
            UnnecessaryInterfaceModifierInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryInterfaceModifierVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryInterfaceModifiersFix((String)infos[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryInterfaceModifierInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryInterfaceModifierVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryInterfaceModifierVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiClass parent;
            if (aClass == null) {
                UnnecessaryInterfaceModifierVisitor.$$$reportNull$$$0(0);
            }
            if ((parent = ClassUtils.getContainingClass((PsiElement)aClass)) != null && parent.isInterface()) {
                PsiModifierList modifiers = aClass.getModifierList();
                if (aClass.isInterface()) {
                    this.checkForRedundantModifiers(modifiers, INNER_INTERFACE_REDUNDANT_MODIFIERS);
                } else {
                    this.checkForRedundantModifiers(modifiers, INNER_CLASS_REDUNDANT_MODIFIERS);
                }
            } else if (aClass.isInterface()) {
                PsiModifierList modifiers = aClass.getModifierList();
                this.checkForRedundantModifiers(modifiers, INTERFACE_REDUNDANT_MODIFIERS);
            }
        }

        public void visitField(@NotNull PsiField field) {
            PsiClass containingClass;
            if (field == null) {
                UnnecessaryInterfaceModifierVisitor.$$$reportNull$$$0(1);
            }
            if ((containingClass = field.getContainingClass()) == null) {
                return;
            }
            if (!containingClass.isInterface()) {
                return;
            }
            PsiModifierList modifiers = field.getModifierList();
            this.checkForRedundantModifiers(modifiers, FIELD_REDUNDANT_MODIFIERS);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiClass aClass;
            if (method == null) {
                UnnecessaryInterfaceModifierVisitor.$$$reportNull$$$0(2);
            }
            if ((aClass = method.getContainingClass()) == null) {
                return;
            }
            if (!aClass.isInterface()) {
                return;
            }
            PsiModifierList modifiers = method.getModifierList();
            this.checkForRedundantModifiers(modifiers, METHOD_REDUNDANT_MODIFIERS);
        }

        public void checkForRedundantModifiers(PsiModifierList list, Set<String> modifiers) {
            if (list == null) {
                return;
            }
            PsiElement[] children = list.getChildren();
            StringBuilder redundantModifiers = new StringBuilder();
            for (PsiElement child : children) {
                String modifierText = child.getText();
                if (!modifiers.contains(modifierText)) continue;
                if (redundantModifiers.length() > 0) {
                    redundantModifiers.append(' ');
                }
                redundantModifiers.append(modifierText);
            }
            for (PsiElement child : children) {
                if (!modifiers.contains(child.getText())) continue;
                this.registerError(child, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{redundantModifiers.toString(), list});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/UnnecessaryInterfaceModifierInspection$UnnecessaryInterfaceModifierVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnnecessaryInterfaceModifiersFix
    extends InspectionGadgetsFix {
        private final String modifiersText;

        private UnnecessaryInterfaceModifiersFix(String modifiersText) {
            this.modifiersText = modifiersText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("smth.unnecessary.remove.quickfix", this.modifiersText);
            if (string == null) {
                UnnecessaryInterfaceModifiersFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Remove unnecessary modifiers" == null) {
                UnnecessaryInterfaceModifiersFix.$$$reportNull$$$0(1);
            }
            return "Remove unnecessary modifiers";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiModifierList modifierList;
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiModifierList) {
                modifierList = (PsiModifierList)element;
            } else {
                PsiElement parent = element.getParent();
                if (!(parent instanceof PsiModifierList)) {
                    return;
                }
                modifierList = (PsiModifierList)parent;
            }
            PsiElement modifierOwner = modifierList.getParent();
            if (!(modifierOwner instanceof PsiMethod) || !PsiUtil.isLanguageLevel8OrHigher((PsiElement)modifierList)) {
                modifierList.setModifierProperty("static", false);
            }
            assert (modifierOwner != null);
            if (modifierOwner instanceof PsiClass) {
                PsiClass containingClass;
                PsiClass aClass = (PsiClass)modifierOwner;
                if (aClass.isInterface()) {
                    modifierList.setModifierProperty("abstract", false);
                }
                if ((containingClass = ClassUtils.getContainingClass(modifierOwner)) != null && containingClass.isInterface()) {
                    modifierList.setModifierProperty("public", false);
                }
            } else if (modifierOwner instanceof PsiMethod) {
                modifierList.setModifierProperty("abstract", false);
                modifierList.setModifierProperty("public", false);
            } else {
                modifierList.setModifierProperty("public", false);
                modifierList.setModifierProperty("final", false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/UnnecessaryInterfaceModifierInspection$UnnecessaryInterfaceModifiersFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

