/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.ui;

import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListUtil;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;

public class UiUtils {
    private UiUtils() {
    }

    public static void setComponentSize(Component component, int rows, int columns) {
        FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
        int width = fontMetrics.charWidth('m') * columns;
        component.setPreferredSize(new Dimension(width, fontMetrics.getHeight() * rows));
    }

    public static JPanel createAddRemovePanel(final ListTable table) {
        JPanel panel = ToolbarDecorator.createDecorator((JTable)table).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListWrappingTableModel tableModel = table.getModel();
                tableModel.addRow();
                EventQueue.invokeLater(() -> {
                    int lastRowIndex = tableModel.getRowCount() - 1;
                    UiUtils.editTableCell(table, lastRowIndex, 0);
                });
            }
        }).setRemoveAction(button -> TableUtil.removeSelectedItems((JTable)table)).disableUpDownActions().createPanel();
        panel.setPreferredSize((Dimension)JBUI.size((int)150, (int)100));
        return panel;
    }

    public static JPanel createAddRemoveTreeClassChooserPanel(final ListTable table, final String chooserTitle, String ... ancestorClasses) {
        Object filter = ancestorClasses.length == 0 ? ClassFilter.ALL : new SubclassFilter(ancestorClasses);
        JPanel panel = ToolbarDecorator.createDecorator((JTable)table).setAddAction(new AnActionButtonRunnable((ClassFilter)filter){
            final /* synthetic */ ClassFilter val$filter;
            {
                this.val$filter = classFilter;
            }

            public void run(AnActionButton button) {
                int rowIndex;
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)table);
                Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                ListWrappingTableModel tableModel = table.getModel();
                if (project == null) {
                    tableModel.addRow();
                    rowIndex = tableModel.getRowCount() - 1;
                } else {
                    TreeClassChooserFactory chooserFactory = TreeClassChooserFactory.getInstance((Project)project);
                    TreeClassChooser classChooser = chooserFactory.createWithInnerClassesScopeChooser(chooserTitle, GlobalSearchScope.allScope((Project)project), this.val$filter, null);
                    classChooser.showDialog();
                    PsiClass selectedClass = classChooser.getSelected();
                    if (selectedClass == null) {
                        return;
                    }
                    String qualifiedName = selectedClass.getQualifiedName();
                    int index = tableModel.indexOf(qualifiedName, 0);
                    if (index < 0) {
                        tableModel.addRow(new String[]{qualifiedName});
                        rowIndex = tableModel.getRowCount() - 1;
                    } else {
                        rowIndex = index;
                    }
                }
                UiUtils.editTableCell(table, rowIndex, table.getColumnCount() > 1 && project != null ? 1 : 0);
            }
        }).setRemoveAction(button -> TableUtil.removeSelectedItems((JTable)table)).disableUpDownActions().createPanel();
        panel.setPreferredSize((Dimension)JBUI.size((int)150, (int)100));
        return panel;
    }

    private static void editTableCell(ListTable table, int row, int column) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.setSelectionInterval(row, row);
        EventQueue.invokeLater(() -> {
            ListWrappingTableModel tableModel = table.getModel();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)table, true));
            Rectangle rectangle = table.getCellRect(row, column, true);
            table.scrollRectToVisible(rectangle);
            table.editCellAt(row, column);
            TableCellEditor editor = table.getCellEditor();
            Component component = editor.getTableCellEditorComponent((JTable)table, tableModel.getValueAt(row, column), true, row, column);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(component, true));
        });
    }

    public static JPanel createTreeClassChooserList(final Collection<? super String> collection, String borderTitle, final String chooserTitle, String ... ancestorClasses) {
        Object filter = ancestorClasses.length == 0 ? ClassFilter.ALL : new SubclassFilter(ancestorClasses);
        JPanel optionsPanel = new JPanel(new BorderLayout());
        final JBList list = new JBList(collection);
        JPanel panel = ToolbarDecorator.createDecorator((JList)list).disableUpDownActions().setAddAction(new AnActionButtonRunnable((ClassFilter)filter, collection){
            final /* synthetic */ ClassFilter val$filter;
            final /* synthetic */ Collection val$collection;
            {
                this.val$filter = classFilter;
                this.val$collection = collection;
            }

            public void run(AnActionButton anActionButton) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)list);
                Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return;
                }
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createNoInnerClassesScopeChooser(chooserTitle, GlobalSearchScope.allScope((Project)project), this.val$filter, null);
                chooser.showDialog();
                PsiClass selected = chooser.getSelected();
                if (selected == null) {
                    return;
                }
                String qualifiedName = selected.getQualifiedName();
                DefaultListModel model = (DefaultListModel)list.getModel();
                int index = model.indexOf(qualifiedName);
                if (index < 0) {
                    model.addElement(qualifiedName);
                    this.val$collection.add(qualifiedName);
                } else {
                    list.setSelectedIndex(index);
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                collection.remove(list.getSelectedValue());
                ListUtil.removeSelectedItems((JList)list);
            }
        }).createPanel();
        panel.setPreferredSize((Dimension)JBUI.size((int)150, (int)100));
        optionsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)borderTitle, (boolean)false, (Insets)JBUI.insetsTop((int)10)));
        optionsPanel.add(panel);
        return optionsPanel;
    }

    private static class SubclassFilter
    implements ClassFilter {
        private final String[] ancestorClasses;

        private SubclassFilter(String[] ancestorClasses) {
            this.ancestorClasses = ancestorClasses;
        }

        public boolean isAccepted(PsiClass aClass) {
            for (String ancestorClass : this.ancestorClasses) {
                if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)ancestorClass)) continue;
                return true;
            }
            return false;
        }
    }
}

