/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.cvsSupport2.connections.ssh.LifeStages;
import com.intellij.cvsSupport2.connections.ssh.SshConnectionUtils;
import com.intellij.cvsSupport2.connections.ssh.SshLogger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.trilead.ssh2.Connection;
import java.io.IOException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

class ConnectionLifeCycle {
    private final int myCheckGranularity;
    private final ThrowableComputable<? extends Connection, ? extends AuthenticationException> myFactory;
    private Connection myConnection;
    private LifeStages myState;
    private long myLastTs;
    private final Ref<Boolean> mySupportsPing;

    ConnectionLifeCycle(int checkGranularity, ThrowableComputable<? extends Connection, ? extends AuthenticationException> factory) {
        this.myCheckGranularity = checkGranularity;
        this.myFactory = factory;
        this.myState = LifeStages.NOT_EXIST;
        this.mySupportsPing = new Ref();
        this.myLastTs = -1L;
        SshLogger.debug("Connection lifecycle created");
    }

    public Connection getConnection() throws AuthenticationException {
        if (this.myConnection == null) {
            try {
                this.myConnection = (Connection)this.myFactory.compute();
            }
            catch (AuthenticationException e) {
                this.myState = LifeStages.CLOSED;
                throw e;
            }
            this.myState = LifeStages.CREATED;
            SshLogger.debug("Connection opened");
        }
        return this.myConnection;
    }

    public boolean hasDied() {
        if (!LifeStages.CREATED.equals((Object)this.myState)) {
            return false;
        }
        if (this.mySupportsPing.isNull()) {
            this.mySupportsPing.set((Object)SshConnectionUtils.connectionSupportsPing(this.myConnection));
        }
        if (Boolean.FALSE.equals(this.mySupportsPing.get())) {
            return false;
        }
        long prevLastTs = this.myLastTs;
        this.myLastTs = System.currentTimeMillis();
        if (prevLastTs > 0L && this.myLastTs - prevLastTs < (long)this.myCheckGranularity) {
            return false;
        }
        try {
            SshLogger.debug("will ping");
            this.myConnection.ping();
        }
        catch (IOException e) {
            SshLogger.debug("ping failed", e);
            return true;
        }
        return false;
    }

    public void close() {
        if (LifeStages.CREATED.equals((Object)this.myState) || LifeStages.CLOSING.equals((Object)this.myState)) {
            this.myConnection.close();
            this.myState = LifeStages.CLOSED;
            SshLogger.debug("connection closed");
        }
    }

    public void setClosing() {
        SshLogger.debug("closing connection...");
        this.myState = LifeStages.CLOSING;
    }

    public boolean isClosed() {
        return LifeStages.CLOSED.equals((Object)this.myState) || LifeStages.CLOSING.equals((Object)this.myState);
    }
}

