/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.server.Maven3ServerGlobals;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator2;
import org.jetbrains.idea.maven.server.embedder.MavenExecutionResult;

public abstract class Maven3ServerEmbedder
extends MavenRemoteObject
implements MavenServerEmbedder {
    public static final boolean USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING = System.getProperty("idea.maven3.use.compat.resolver") != null;
    private static final String MAVEN_VERSION = System.getProperty("idea.maven.embedder.version");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\"-D([\\S&&[^=]]+)(?:=([^\"]+))?\"|-D([\\S&&[^=]]+)(?:=(\\S+))?");
    protected final MavenServerSettings myServerSettings;

    protected Maven3ServerEmbedder(MavenServerSettings settings) {
        this.myServerSettings = settings;
        Maven3ServerEmbedder.initLog4J(this.myServerSettings);
    }

    private static void initLog4J(MavenServerSettings settings) {
        try {
            BasicConfigurator.configure();
            Level rootLoggerLevel = Maven3ServerEmbedder.toLog4JLevel(settings.getLoggingLevel());
            Logger.getRootLogger().setLevel(rootLoggerLevel);
            if (!rootLoggerLevel.isGreaterOrEqual((Priority)Level.ERROR)) {
                Logger.getLogger((String)"org.apache.maven.wagon.providers.http.httpclient.wire").setLevel(Level.ERROR);
                Logger.getLogger((String)"org.apache.http.wire").setLevel(Level.ERROR);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Level toLog4JLevel(int level) {
        switch (level) {
            case 0: {
                return Level.ALL;
            }
            case 3: {
                return Level.ERROR;
            }
            case 4: {
                return Level.FATAL;
            }
            case 5: {
                return Level.OFF;
            }
            case 1: {
                return Level.INFO;
            }
            case 2: {
                return Level.WARN;
            }
        }
        return Level.INFO;
    }

    protected abstract ArtifactRepository getLocalRepository();

    @NotNull
    public List<String> retrieveAvailableVersions(@NotNull String groupId, @NotNull String artifactId, @NotNull List<MavenRemoteRepository> remoteRepositories) throws RemoteException {
        List list;
        if (groupId == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(1);
        }
        if (remoteRepositories == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(2);
        }
        try {
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, "", "compile", "pom", null, (ArtifactHandler)new DefaultArtifactHandler("pom"));
            List versions = this.getComponent(ArtifactMetadataSource.class).retrieveAvailableVersions((Artifact)artifact, this.getLocalRepository(), this.convertRepositories(remoteRepositories));
            list = ContainerUtilRt.map2List((Collection)versions, (Function)new Function<ArtifactVersion, String>(){

                public String fun(ArtifactVersion version) {
                    return version.toString();
                }
            });
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().info(e);
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                Maven3ServerEmbedder.$$$reportNull$$$0(4);
            }
            return list2;
        }
        if (list == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(3);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected List<ProjectBuildingResult> getProjectBuildingResults(@NotNull MavenExecutionRequest request, @NotNull Collection<File> files) {
        List<Object> buildingResults;
        block11: {
            if (request == null) {
                Maven3ServerEmbedder.$$$reportNull$$$0(5);
            }
            if (files == null) {
                Maven3ServerEmbedder.$$$reportNull$$$0(6);
            }
            ProjectBuilder builder = this.getComponent(ProjectBuilder.class);
            CustomMaven3ModelInterpolator2 modelInterpolator = (CustomMaven3ModelInterpolator2)this.getComponent(ModelInterpolator.class);
            String savedLocalRepository = modelInterpolator.getLocalRepository();
            modelInterpolator.setLocalRepository(request.getLocalRepositoryPath().getAbsolutePath());
            buildingResults = new ArrayList<ProjectBuildingResult>();
            ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
            projectBuildingRequest.setValidationLevel(0);
            projectBuildingRequest.setResolveDependencies(false);
            try {
                if (files.size() == 1) {
                    this.buildSinglePom(builder, buildingResults, projectBuildingRequest, files.iterator().next());
                    break block11;
                }
                try {
                    buildingResults = builder.build(new ArrayList<File>(files), false, projectBuildingRequest);
                }
                catch (ProjectBuildingException e) {
                    for (ProjectBuildingResult result : e.getResults()) {
                        if (result.getProject() != null) {
                            buildingResults.add(result);
                            continue;
                        }
                        this.buildSinglePom(builder, buildingResults, projectBuildingRequest, result.getPomFile());
                    }
                }
            }
            finally {
                modelInterpolator.setLocalRepository(savedLocalRepository);
            }
        }
        List<Object> list = buildingResults;
        if (list == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(7);
        }
        return list;
    }

    private void buildSinglePom(ProjectBuilder builder, List<ProjectBuildingResult> buildingResults, ProjectBuildingRequest projectBuildingRequest, File pomFile) {
        try {
            ProjectBuildingResult build = builder.build(pomFile, projectBuildingRequest);
            buildingResults.add(build);
        }
        catch (ProjectBuildingException e) {
            this.handleProjectBuildingException(buildingResults, e);
        }
    }

    protected void handleProjectBuildingException(List<ProjectBuildingResult> buildingResults, ProjectBuildingException e) {
        List results = e.getResults();
        if (results != null && !results.isEmpty()) {
            buildingResults.addAll(results);
        } else {
            Throwable cause = e.getCause();
            List problems = null;
            if (cause instanceof ModelBuildingException) {
                problems = ((ModelBuildingException)cause).getProblems();
            }
            buildingResults.add(new MyProjectBuildingResult(null, e.getPomFile(), null, problems, null));
        }
    }

    protected void addMvn2CompatResults(MavenProject project, List<Exception> exceptions, List<ResolutionListener> listeners, ArtifactRepository localRepository, Collection<MavenExecutionResult> executionResults) {
        ArtifactResolutionRequest resolutionRequest = new ArtifactResolutionRequest();
        resolutionRequest.setArtifactDependencies(project.getDependencyArtifacts());
        resolutionRequest.setArtifact(project.getArtifact());
        resolutionRequest.setManagedVersionMap(project.getManagedVersionMap());
        resolutionRequest.setLocalRepository(localRepository);
        resolutionRequest.setRemoteRepositories(project.getRemoteArtifactRepositories());
        resolutionRequest.setListeners(listeners);
        resolutionRequest.setResolveRoot(false);
        resolutionRequest.setResolveTransitively(true);
        ArtifactResolver resolver = this.getComponent(ArtifactResolver.class);
        ArtifactResolutionResult result = resolver.resolve(resolutionRequest);
        project.setArtifacts(result.getArtifacts());
        executionResults.add(new MavenExecutionResult(project, exceptions));
    }

    @Nullable
    public MavenModel readModel(File file) throws RemoteException {
        return null;
    }

    public static Map<String, String> getMavenAndJvmConfigProperties(File workingDir) {
        if (workingDir == null) {
            return Collections.emptyMap();
        }
        File baseDir = MavenServerUtil.findMavenBasedir((File)workingDir);
        HashMap<String, String> result = new HashMap<String, String>();
        Maven3ServerEmbedder.readConfigFiles(baseDir, result);
        return result.isEmpty() ? Collections.emptyMap() : result;
    }

    static void readConfigFiles(File baseDir, Map<String, String> result) {
        Maven3ServerEmbedder.readConfigFile(baseDir, File.separator + ".mvn" + File.separator + "jvm.config", result, "");
        Maven3ServerEmbedder.readConfigFile(baseDir, File.separator + ".mvn" + File.separator + "maven.config", result, "true");
    }

    private static void readConfigFile(File baseDir, String relativePath, Map<String, String> result, String valueIfMissing) {
        File configFile = new File(baseDir, relativePath);
        if (configFile.exists() && configFile.isFile()) {
            try {
                String text = FileUtilRt.loadFile((File)configFile, (String)"UTF-8");
                Matcher matcher = PROPERTY_PATTERN.matcher(text);
                while (matcher.find()) {
                    if (matcher.group(1) != null) {
                        result.put(matcher.group(1), StringUtilRt.notNullize((String)matcher.group(2), (String)valueIfMissing));
                        continue;
                    }
                    result.put(matcher.group(3), StringUtilRt.notNullize((String)matcher.group(4), (String)valueIfMissing));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @NotNull
    protected abstract List<ArtifactRepository> convertRepositories(List<MavenRemoteRepository> var1) throws RemoteException;

    @Nullable
    public String getMavenVersion() {
        return MAVEN_VERSION;
    }

    public abstract <T> T getComponent(Class<T> var1, String var2);

    public abstract <T> T getComponent(Class<T> var1);

    public abstract void executeWithMavenSession(MavenExecutionRequest var1, Runnable var2);

    public abstract MavenExecutionRequest createRequest(File var1, List<String> var2, List<String> var3, List<String> var4) throws RemoteException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositories";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/Maven3ServerEmbedder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/Maven3ServerEmbedder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveAvailableVersions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectBuildingResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "retrieveAvailableVersions";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProjectBuildingResults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyProjectBuildingResult
    implements ProjectBuildingResult {
        private final String myProjectId;
        private final File myPomFile;
        private final MavenProject myMavenProject;
        private final List<ModelProblem> myProblems;
        private final DependencyResolutionResult myDependencyResolutionResult;

        MyProjectBuildingResult(String projectId, File pomFile, MavenProject mavenProject, List<ModelProblem> problems, DependencyResolutionResult dependencyResolutionResult) {
            this.myProjectId = projectId;
            this.myPomFile = pomFile;
            this.myMavenProject = mavenProject;
            this.myProblems = problems;
            this.myDependencyResolutionResult = dependencyResolutionResult;
        }

        public String getProjectId() {
            return this.myProjectId;
        }

        public File getPomFile() {
            return this.myPomFile;
        }

        public MavenProject getProject() {
            return this.myMavenProject;
        }

        public List<ModelProblem> getProblems() {
            return this.myProblems;
        }

        public DependencyResolutionResult getDependencyResolutionResult() {
            return this.myDependencyResolutionResult;
        }
    }
}

