/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.impl.AllJarsUnderDirEntry;
import com.intellij.lang.ant.config.impl.SinglePathEntry;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.config.Externalizer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;

public interface AntClasspathEntry {
    public static final Externalizer<AntClasspathEntry> EXTERNALIZER = new Externalizer<AntClasspathEntry>(){

        public AntClasspathEntry readValue(Element dataElement) {
            String pathUrl = dataElement.getAttributeValue("path");
            if (pathUrl != null) {
                return new SinglePathEntry(PathUtil.toPresentableUrl((String)pathUrl));
            }
            String dirUrl = dataElement.getAttributeValue("dir");
            if (dirUrl != null) {
                return new AllJarsUnderDirEntry(PathUtil.toPresentableUrl((String)dirUrl));
            }
            throw new IllegalStateException();
        }

        public void writeValue(Element dataElement, AntClasspathEntry entry) {
            entry.writeExternal(dataElement);
        }
    };

    public void writeExternal(Element var1);

    public void addFilesTo(List<File> var1);

    public CellAppearanceEx getAppearance();

    public static abstract class AddEntriesFactory
    implements NullableFactory<List<AntClasspathEntry>> {
        private final JComponent myParentComponent;
        private final FileChooserDescriptor myDescriptor;
        private final Function<? super VirtualFile, ? extends AntClasspathEntry> myMapper;

        public AddEntriesFactory(JComponent parentComponent, FileChooserDescriptor descriptor, Function<? super VirtualFile, ? extends AntClasspathEntry> mapper) {
            this.myParentComponent = parentComponent;
            this.myDescriptor = descriptor;
            this.myMapper = mapper;
        }

        public List<AntClasspathEntry> create() {
            Object[] files = FileChooser.chooseFiles((FileChooserDescriptor)this.myDescriptor, (Component)this.myParentComponent, null, null);
            return files.length == 0 ? null : ContainerUtil.map((Object[])files, this.myMapper);
        }
    }
}

