/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomMacroDef;
import com.intellij.lang.ant.dom.AntDomMacrodefAttributeReference;
import com.intellij.lang.ant.dom.AntDomPropertyReference;
import com.intellij.lang.ant.dom.AntStringResolver;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomReferenceInjector;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AntReferenceInjector
implements DomReferenceInjector {
    AntReferenceInjector() {
    }

    public String resolveString(@Nullable String unresolvedText, @NotNull ConvertContext context) {
        if (context == null) {
            AntReferenceInjector.$$$reportNull$$$0(0);
        }
        if (unresolvedText == null) {
            return null;
        }
        DomElement element = context.getInvocationElement();
        return AntStringResolver.computeString(element, unresolvedText);
    }

    @NotNull
    public PsiReference[] inject(@Nullable String unresolvedText, @NotNull PsiElement element, @NotNull ConvertContext context) {
        if (element == null) {
            AntReferenceInjector.$$$reportNull$$$0(1);
        }
        if (context == null) {
            AntReferenceInjector.$$$reportNull$$$0(2);
        }
        if (element instanceof XmlAttributeValue) {
            XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)element;
            ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
            AntReferenceInjector.addPropertyReferences(context, xmlAttributeValue, refs);
            AntReferenceInjector.addMacrodefParameterRefs(xmlAttributeValue, refs);
            PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                AntReferenceInjector.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            AntReferenceInjector.$$$reportNull$$$0(4);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static void addPropertyReferences(@NotNull ConvertContext context, XmlAttributeValue xmlAttributeValue, Collection<PsiReference> result) {
        String name;
        if (context == null) {
            AntReferenceInjector.$$$reportNull$$$0(5);
        }
        String value = xmlAttributeValue.getValue();
        DomElement contextElement = context.getInvocationElement();
        XmlAttribute attrib = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)xmlAttributeValue, XmlAttribute.class);
        if (attrib != null && ("if".equals(name = attrib.getName()) || "unless".equals(name))) {
            AntDomPropertyReference ref = new AntDomPropertyReference(contextElement, xmlAttributeValue, ElementManipulators.getValueTextRange((PsiElement)xmlAttributeValue));
            ref.setShouldBeSkippedByAnnotator(true);
            result.add((PsiReference)ref);
            return;
        }
        if (xmlAttributeValue != null) {
            int startIndex;
            int valueBeginingOffset = Math.abs(xmlAttributeValue.getTextRange().getStartOffset() - xmlAttributeValue.getValueTextRange().getStartOffset());
            int endIndex = -1;
            while ((startIndex = value.indexOf("${", endIndex + 1)) > endIndex) {
                if (startIndex > 0 && value.charAt(startIndex - 1) == '$') {
                    endIndex = startIndex + 1;
                    continue;
                }
                int nestedBrackets = 0;
                for (endIndex = startIndex += 2; value.length() > endIndex; ++endIndex) {
                    char ch = value.charAt(endIndex);
                    if (ch == '}') {
                        if (nestedBrackets == 0) break;
                        --nestedBrackets;
                        continue;
                    }
                    if (ch != '{') continue;
                    ++nestedBrackets;
                }
                if (nestedBrackets > 0 || endIndex > value.length()) {
                    return;
                }
                if (endIndex >= startIndex) {
                    AntDomPropertyReference ref = new AntDomPropertyReference(contextElement, xmlAttributeValue, new TextRange(valueBeginingOffset + startIndex, valueBeginingOffset + endIndex));
                    result.add((PsiReference)ref);
                }
                endIndex = startIndex;
            }
        }
    }

    public static void addMacrodefParameterRefs(@NotNull XmlAttributeValue element, Collection<? super PsiReference> refs) {
        int startIndex;
        DomElement domElement;
        if (element == null) {
            AntReferenceInjector.$$$reportNull$$$0(6);
        }
        if ((domElement = DomUtil.getDomElement((PsiElement)element)) == null) {
            return;
        }
        AntDomMacroDef macrodef = (AntDomMacroDef)domElement.getParentOfType(AntDomMacroDef.class, true);
        if (macrodef == null) {
            return;
        }
        String text = ElementManipulators.getValueText((PsiElement)element);
        int valueBeginingOffset = Math.abs(element.getTextRange().getStartOffset() - element.getValueTextRange().getStartOffset());
        int endIndex = -1;
        while ((startIndex = text.indexOf("@{", endIndex + 1)) > endIndex) {
            int nestedBrackets = 0;
            for (endIndex = startIndex += 2; text.length() > endIndex; ++endIndex) {
                char ch = text.charAt(endIndex);
                if (ch == '}') {
                    if (nestedBrackets == 0) break;
                    --nestedBrackets;
                    continue;
                }
                if (ch != '{') continue;
                ++nestedBrackets;
            }
            if (nestedBrackets > 0 || endIndex == text.length()) {
                return;
            }
            if (endIndex >= startIndex) {
                refs.add((PsiReference)new AntDomMacrodefAttributeReference((PsiElement)element, new TextRange(valueBeginingOffset + startIndex, valueBeginingOffset + endIndex)));
            }
            endIndex = startIndex;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/dom/AntReferenceInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/dom/AntReferenceInjector";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "inject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inject";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyReferences";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addMacrodefParameterRefs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

