/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.core.codegen.ClassGen;
import jadx.core.codegen.CodeWriter;
import jadx.core.codegen.ConditionGen;
import jadx.core.codegen.MethodGen;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.FieldReplaceAttr;
import jadx.core.dex.attributes.nodes.LoopLabelAttr;
import jadx.core.dex.attributes.nodes.MethodInlineAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.ArithNode;
import jadx.core.dex.instructions.ArithOp;
import jadx.core.dex.instructions.ConstClassNode;
import jadx.core.dex.instructions.ConstStringNode;
import jadx.core.dex.instructions.FillArrayNode;
import jadx.core.dex.instructions.FilledNewArrayNode;
import jadx.core.dex.instructions.GotoNode;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.NewArrayNode;
import jadx.core.dex.instructions.SwitchNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.FieldArg;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.Named;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.android.AndroidResourcesUtils;
import jadx.core.utils.exceptions.CodegenException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsnGen {
    private static final Logger LOG = LoggerFactory.getLogger(InsnGen.class);
    protected final MethodGen mgen;
    protected final MethodNode mth;
    protected final RootNode root;
    protected final boolean fallback;

    public InsnGen(MethodGen mgen, boolean fallback) {
        this.mgen = mgen;
        this.mth = mgen.getMethodNode();
        this.root = this.mth.dex().root();
        this.fallback = fallback;
    }

    private boolean isFallback() {
        return this.fallback;
    }

    public void addArgDot(CodeWriter code, InsnArg arg) throws CodegenException {
        int len = code.bufLength();
        this.addArg(code, arg, true);
        if (len != code.bufLength()) {
            code.add('.');
        }
    }

    public void addArg(CodeWriter code, InsnArg arg) throws CodegenException {
        this.addArg(code, arg, true);
    }

    public void addArg(CodeWriter code, InsnArg arg, boolean wrap) throws CodegenException {
        if (arg.isRegister()) {
            code.add(this.mgen.getNameGen().useArg((RegisterArg)arg));
        } else if (arg.isLiteral()) {
            code.add(this.lit((LiteralArg)arg));
        } else if (arg.isInsnWrap()) {
            Flags flag = wrap ? Flags.BODY_ONLY : Flags.BODY_ONLY_NOWRAP;
            this.makeInsn(((InsnWrapArg)arg).getWrapInsn(), code, flag);
        } else if (arg.isNamed()) {
            code.add(((Named)((Object)arg)).getName());
        } else if (arg.isField()) {
            FieldArg f = (FieldArg)arg;
            if (f.isStatic()) {
                this.staticField(code, f.getField());
            } else {
                this.instanceField(code, f.getField(), f.getInstanceArg());
            }
        } else {
            throw new CodegenException("Unknown arg type " + arg);
        }
    }

    public void assignVar(CodeWriter code, InsnNode insn) throws CodegenException {
        RegisterArg arg = insn.getResult();
        if (insn.contains(AFlag.DECLARE_VAR)) {
            this.declareVar(code, arg);
        } else {
            this.addArg(code, arg, false);
        }
    }

    public void declareVar(CodeWriter code, RegisterArg arg) {
        if (arg.getSVar().contains(AFlag.FINAL)) {
            code.add("final ");
        }
        this.useType(code, arg.getType());
        code.add(' ');
        code.add(this.mgen.getNameGen().assignArg(arg));
    }

    private String lit(LiteralArg arg) {
        return TypeGen.literalToString(arg.getLiteral(), arg.getType(), this.mth);
    }

    private void instanceField(CodeWriter code, FieldInfo field, InsnArg arg) throws CodegenException {
        FieldReplaceAttr replace;
        ClassNode pCls = this.mth.getParentClass();
        FieldNode fieldNode = pCls.dex().root().deepResolveField(field);
        if (fieldNode != null && (replace = fieldNode.get(AType.FIELD_REPLACE)) != null) {
            switch (replace.getReplaceType()) {
                case CLASS_INSTANCE: {
                    this.useClass(code, replace.getClsRef());
                    code.add(".this");
                    break;
                }
                case VAR: {
                    this.addArg(code, replace.getVarRef());
                }
            }
            return;
        }
        this.addArgDot(code, arg);
        if (fieldNode != null) {
            code.attachAnnotation(fieldNode);
        }
        if (fieldNode == null) {
            code.add(field.getAlias());
        } else {
            code.add(fieldNode.getAlias());
        }
    }

    public static void makeStaticFieldAccess(CodeWriter code, FieldInfo field, ClassGen clsGen) {
        FieldNode fieldNode;
        ClassInfo declClass = field.getDeclClass();
        boolean fieldFromThisClass = clsGen.getClassNode().getClassInfo().equals(declClass);
        if (!fieldFromThisClass) {
            if (!AndroidResourcesUtils.handleAppResField(code, clsGen, declClass)) {
                clsGen.useClass(code, declClass);
            }
            code.add('.');
        }
        if ((fieldNode = clsGen.getClassNode().dex().root().deepResolveField(field)) != null) {
            code.attachAnnotation(fieldNode);
        }
        if (fieldNode == null) {
            code.add(field.getAlias());
        } else {
            code.add(fieldNode.getAlias());
        }
    }

    protected void staticField(CodeWriter code, FieldInfo field) {
        InsnGen.makeStaticFieldAccess(code, field, this.mgen.getClassGen());
    }

    public void useClass(CodeWriter code, ArgType type) {
        this.mgen.getClassGen().useClass(code, type);
    }

    public void useClass(CodeWriter code, ClassInfo cls) {
        this.mgen.getClassGen().useClass(code, cls);
    }

    protected void useType(CodeWriter code, ArgType type) {
        this.mgen.getClassGen().useType(code, type);
    }

    public boolean makeInsn(InsnNode insn, CodeWriter code) throws CodegenException {
        return this.makeInsn(insn, code, null);
    }

    protected boolean makeInsn(InsnNode insn, CodeWriter code, Flags flag) throws CodegenException {
        try {
            EnumSet<Flags> state = EnumSet.noneOf(Flags.class);
            if (flag == Flags.BODY_ONLY || flag == Flags.BODY_ONLY_NOWRAP) {
                state.add(flag);
                this.makeInsnBody(code, insn, state);
            } else {
                if (flag != Flags.INLINE) {
                    code.startLineWithNum(insn.getSourceLine());
                }
                if (insn.getResult() != null && !insn.contains(AFlag.ARITH_ONEARG)) {
                    this.assignVar(code, insn);
                    code.add(" = ");
                }
                this.makeInsnBody(code, insn, state);
                if (flag != Flags.INLINE) {
                    code.add(';');
                }
            }
        }
        catch (Exception th) {
            throw new CodegenException(this.mth, "Error generate insn: " + insn, (Throwable)th);
        }
        return true;
    }

    private void makeInsnBody(CodeWriter code, InsnNode insn, Set<Flags> state) throws CodegenException {
        switch (insn.getType()) {
            case CONST_STR: {
                String str = ((ConstStringNode)insn).getString();
                code.add(this.mth.dex().root().getStringUtils().unescapeString(str));
                break;
            }
            case CONST_CLASS: {
                ArgType clsType = ((ConstClassNode)insn).getClsType();
                this.useType(code, clsType);
                code.add(".class");
                break;
            }
            case CONST: {
                LiteralArg arg = (LiteralArg)insn.getArg(0);
                code.add(this.lit(arg));
                break;
            }
            case MOVE: {
                this.addArg(code, insn.getArg(0), false);
                break;
            }
            case CHECK_CAST: 
            case CAST: {
                boolean wrap = state.contains((Object)Flags.BODY_ONLY);
                if (wrap) {
                    code.add('(');
                }
                code.add('(');
                this.useType(code, (ArgType)((IndexInsnNode)insn).getIndex());
                code.add(") ");
                this.addArg(code, insn.getArg(0), true);
                if (!wrap) break;
                code.add(')');
                break;
            }
            case ARITH: {
                this.makeArith((ArithNode)insn, code, state);
                break;
            }
            case NEG: {
                this.oneArgInsn(code, insn, state, '-');
                break;
            }
            case NOT: {
                this.oneArgInsn(code, insn, state, '~');
                break;
            }
            case RETURN: {
                if (insn.getArgsCount() != 0) {
                    code.add("return ");
                    this.addArg(code, insn.getArg(0), false);
                    break;
                }
                code.add("return");
                break;
            }
            case BREAK: {
                code.add("break");
                LoopLabelAttr labelAttr = insn.get(AType.LOOP_LABEL);
                if (labelAttr == null) break;
                code.add(' ').add(this.mgen.getNameGen().getLoopLabel(labelAttr));
                break;
            }
            case CONTINUE: {
                code.add("continue");
                break;
            }
            case THROW: {
                code.add("throw ");
                this.addArg(code, insn.getArg(0), true);
                break;
            }
            case CMP_L: 
            case CMP_G: {
                code.add('(');
                this.addArg(code, insn.getArg(0));
                code.add(" > ");
                this.addArg(code, insn.getArg(1));
                code.add(" ? 1 : (");
                this.addArg(code, insn.getArg(0));
                code.add(" == ");
                this.addArg(code, insn.getArg(1));
                code.add(" ? 0 : -1))");
                break;
            }
            case INSTANCE_OF: {
                boolean wrap = state.contains((Object)Flags.BODY_ONLY);
                if (wrap) {
                    code.add('(');
                }
                this.addArg(code, insn.getArg(0));
                code.add(" instanceof ");
                this.useType(code, (ArgType)((IndexInsnNode)insn).getIndex());
                if (!wrap) break;
                code.add(')');
                break;
            }
            case CONSTRUCTOR: {
                this.makeConstructor((ConstructorInsn)insn, code);
                break;
            }
            case INVOKE: {
                this.makeInvoke((InvokeNode)insn, code);
                break;
            }
            case NEW_ARRAY: {
                ArgType arrayType = ((NewArrayNode)insn).getArrayType();
                code.add("new ");
                this.useType(code, arrayType.getArrayRootElement());
                code.add('[');
                this.addArg(code, insn.getArg(0));
                code.add(']');
                int dim = arrayType.getArrayDimension();
                for (int i = 0; i < dim - 1; ++i) {
                    code.add("[]");
                }
                break;
            }
            case ARRAY_LENGTH: {
                this.addArg(code, insn.getArg(0));
                code.add(".length");
                break;
            }
            case FILLED_NEW_ARRAY: {
                this.filledNewArray((FilledNewArrayNode)insn, code);
                break;
            }
            case AGET: {
                this.addArg(code, insn.getArg(0));
                code.add('[');
                this.addArg(code, insn.getArg(1), false);
                code.add(']');
                break;
            }
            case APUT: {
                this.addArg(code, insn.getArg(0));
                code.add('[');
                this.addArg(code, insn.getArg(1), false);
                code.add("] = ");
                this.addArg(code, insn.getArg(2), false);
                break;
            }
            case IGET: {
                FieldInfo fieldInfo = (FieldInfo)((IndexInsnNode)insn).getIndex();
                this.instanceField(code, fieldInfo, insn.getArg(0));
                break;
            }
            case IPUT: {
                FieldInfo fieldInfo = (FieldInfo)((IndexInsnNode)insn).getIndex();
                this.instanceField(code, fieldInfo, insn.getArg(1));
                code.add(" = ");
                this.addArg(code, insn.getArg(0), false);
                break;
            }
            case SGET: {
                this.staticField(code, (FieldInfo)((IndexInsnNode)insn).getIndex());
                break;
            }
            case SPUT: {
                FieldInfo field = (FieldInfo)((IndexInsnNode)insn).getIndex();
                this.staticField(code, field);
                code.add(" = ");
                this.addArg(code, insn.getArg(0), false);
                break;
            }
            case STR_CONCAT: {
                boolean wrap = state.contains((Object)Flags.BODY_ONLY);
                if (wrap) {
                    code.add('(');
                }
                Iterator<InsnArg> it = insn.getArguments().iterator();
                while (it.hasNext()) {
                    this.addArg(code, it.next());
                    if (!it.hasNext()) continue;
                    code.add(" + ");
                }
                if (!wrap) break;
                code.add(')');
                break;
            }
            case MONITOR_ENTER: {
                if (!this.isFallback()) break;
                code.add("monitor-enter(");
                this.addArg(code, insn.getArg(0));
                code.add(')');
                break;
            }
            case MONITOR_EXIT: {
                if (!this.isFallback()) break;
                code.add("monitor-exit(");
                this.addArg(code, insn.getArg(0));
                code.add(')');
                break;
            }
            case TERNARY: {
                this.makeTernary((TernaryInsn)insn, code, state);
                break;
            }
            case ONE_ARG: {
                this.addArg(code, insn.getArg(0));
                break;
            }
            case IF: {
                this.fallbackOnlyInsn(insn);
                IfNode ifInsn = (IfNode)insn;
                code.add("if (");
                this.addArg(code, insn.getArg(0));
                code.add(' ');
                code.add(ifInsn.getOp().getSymbol()).add(' ');
                this.addArg(code, insn.getArg(1));
                code.add(") goto ").add(MethodGen.getLabelName(ifInsn.getTarget()));
                break;
            }
            case GOTO: {
                this.fallbackOnlyInsn(insn);
                code.add("goto ").add(MethodGen.getLabelName(((GotoNode)insn).getTarget()));
                break;
            }
            case MOVE_EXCEPTION: {
                this.fallbackOnlyInsn(insn);
                code.add("move-exception");
                break;
            }
            case SWITCH: {
                this.fallbackOnlyInsn(insn);
                SwitchNode sw = (SwitchNode)insn;
                code.add("switch(");
                this.addArg(code, insn.getArg(0));
                code.add(") {");
                code.incIndent();
                for (int i = 0; i < sw.getCasesCount(); ++i) {
                    String key = sw.getKeys()[i].toString();
                    code.startLine("case ").add(key).add(": goto ");
                    code.add(MethodGen.getLabelName(sw.getTargets()[i])).add(';');
                }
                code.startLine("default: goto ");
                code.add(MethodGen.getLabelName(sw.getDefaultCaseOffset())).add(';');
                code.decIndent();
                code.startLine('}');
                break;
            }
            case FILL_ARRAY: {
                this.fallbackOnlyInsn(insn);
                FillArrayNode arrayNode = (FillArrayNode)insn;
                Object data = arrayNode.getData();
                String arrStr = data instanceof int[] ? Arrays.toString((int[])data) : (data instanceof short[] ? Arrays.toString((short[])data) : (data instanceof byte[] ? Arrays.toString((byte[])data) : (data instanceof long[] ? Arrays.toString((long[])data) : "?")));
                code.add('{').add(arrStr.substring(1, arrStr.length() - 1)).add('}');
                break;
            }
            case NEW_INSTANCE: {
                this.fallbackOnlyInsn(insn);
                code.add("new ").add(insn.getResult().getType().toString());
                break;
            }
            case PHI: 
            case MERGE: {
                this.fallbackOnlyInsn(insn);
                code.add(insn.getType().toString()).add("(");
                for (InsnArg insnArg : insn.getArguments()) {
                    this.addArg(code, insnArg);
                    code.add(' ');
                }
                code.add(")");
                break;
            }
            default: {
                throw new CodegenException(this.mth, "Unknown instruction: " + (Object)((Object)insn.getType()));
            }
        }
    }

    private void oneArgInsn(CodeWriter code, InsnNode insn, Set<Flags> state, char op) throws CodegenException {
        boolean wrap = state.contains((Object)Flags.BODY_ONLY);
        if (wrap) {
            code.add('(');
        }
        code.add(op);
        this.addArg(code, insn.getArg(0));
        if (wrap) {
            code.add(')');
        }
    }

    private void fallbackOnlyInsn(InsnNode insn) throws CodegenException {
        if (!this.fallback) {
            throw new CodegenException((Object)((Object)insn.getType()) + " can be used only in fallback mode");
        }
    }

    private void filledNewArray(FilledNewArrayNode insn, CodeWriter code) throws CodegenException {
        code.add("new ");
        this.useType(code, insn.getArrayType());
        code.add('{');
        int c = insn.getArgsCount();
        for (int i = 0; i < c; ++i) {
            this.addArg(code, insn.getArg(i), false);
            if (i + 1 >= c) continue;
            code.add(", ");
        }
        code.add('}');
    }

    private void makeConstructor(ConstructorInsn insn, CodeWriter code) throws CodegenException {
        ClassNode cls = this.mth.dex().resolveClass(insn.getClassType());
        if (cls != null && cls.contains(AFlag.ANONYMOUS_CLASS) && !this.fallback) {
            this.inlineAnonymousConstr(code, cls, insn);
            return;
        }
        if (insn.isSelf()) {
            throw new JadxRuntimeException("Constructor 'self' invoke must be removed!");
        }
        if (insn.isSuper()) {
            code.add("super");
        } else if (insn.isThis()) {
            code.add("this");
        } else {
            code.add("new ");
            this.useClass(code, insn.getClassType());
        }
        MethodNode callMth = this.mth.dex().resolveMethod(insn.getCallMth());
        this.generateMethodArguments(code, insn, 0, callMth);
    }

    private void inlineAnonymousConstr(CodeWriter code, ClassNode cls, ConstructorInsn insn) throws CodegenException {
        if (cls.contains(AFlag.DONT_GENERATE)) {
            code.add("/* anonymous class already generated */");
            ErrorsCounter.methodWarn(this.mth, "Anonymous class already generated: " + cls);
            return;
        }
        ArgType parent = cls.getInterfaces().size() == 1 ? cls.getInterfaces().get(0) : cls.getSuperClass();
        cls.add(AFlag.DONT_GENERATE);
        MethodNode defCtr = cls.getDefaultConstructor();
        if (defCtr != null) {
            if (RegionUtils.notEmpty(defCtr.getRegion())) {
                defCtr.add(AFlag.ANONYMOUS_CONSTRUCTOR);
            } else {
                defCtr.add(AFlag.DONT_GENERATE);
            }
        }
        code.add("new ");
        if (parent == null) {
            code.add("Object");
        } else {
            this.useClass(code, parent);
        }
        MethodNode callMth = this.mth.dex().resolveMethod(insn.getCallMth());
        this.generateMethodArguments(code, insn, 0, callMth);
        code.add(' ');
        new ClassGen(cls, this.mgen.getClassGen().getParentGen()).addClassBody(code);
    }

    private void makeInvoke(InvokeNode insn, CodeWriter code) throws CodegenException {
        MethodInfo callMth = insn.getCallMth();
        MethodNode callMthNode = this.mth.root().deepResolveMethod(callMth);
        if (callMthNode != null) {
            if (this.inlineMethod(callMthNode, insn, code)) {
                return;
            }
            callMth = callMthNode.getMethodInfo();
        }
        int k = 0;
        InvokeType type = insn.getInvokeType();
        switch (type) {
            case DIRECT: 
            case VIRTUAL: 
            case INTERFACE: {
                InsnArg arg = insn.getArg(0);
                if (!arg.isThis()) {
                    this.addArgDot(code, arg);
                }
                ++k;
                break;
            }
            case SUPER: {
                code.add("super").add('.');
                ++k;
                break;
            }
            case STATIC: {
                ClassInfo insnCls = this.mth.getParentClass().getAlias();
                ClassInfo declClass = callMth.getDeclClass();
                if (insnCls.equals(declClass)) break;
                this.useClass(code, declClass);
                code.add('.');
            }
        }
        if (callMthNode != null) {
            code.attachAnnotation(callMthNode);
        }
        code.add(callMth.getAlias());
        this.generateMethodArguments(code, insn, k, callMthNode);
    }

    void generateMethodArguments(CodeWriter code, InsnNode insn, int startArgNum, @Nullable MethodNode callMth) throws CodegenException {
        int k = startArgNum;
        if (callMth != null && callMth.contains(AFlag.SKIP_FIRST_ARG)) {
            ++k;
        }
        int argsCount = insn.getArgsCount();
        code.add('(');
        boolean firstArg = true;
        if (k < argsCount) {
            boolean overloaded = callMth != null && callMth.isArgsOverload();
            for (int i = k; i < argsCount; ++i) {
                boolean cast;
                RegisterArg callArg;
                InsnArg arg = insn.getArg(i);
                if (arg.contains(AFlag.SKIP_ARG) || (callArg = InsnGen.getCallMthArg(callMth, i - startArgNum)) != null && callArg.contains(AFlag.SKIP_ARG)) continue;
                if (!firstArg) {
                    code.add(", ");
                }
                boolean bl = cast = overloaded && this.processOverloadedArg(code, callMth, arg, i - startArgNum);
                if (!cast && i == argsCount - 1 && this.processVarArg(code, callMth, arg)) continue;
                this.addArg(code, arg, false);
                firstArg = false;
            }
        }
        code.add(')');
    }

    private static RegisterArg getCallMthArg(@Nullable MethodNode callMth, int num) {
        if (callMth == null) {
            return null;
        }
        List<RegisterArg> args = callMth.getArguments(false);
        if (args != null && num < args.size()) {
            return args.get(num);
        }
        return null;
    }

    private boolean processOverloadedArg(CodeWriter code, MethodNode callMth, InsnArg arg, int origPos) {
        ArgType origType = callMth.getMethodInfo().getArgumentsTypes().get(origPos);
        if (!arg.getType().equals(origType)) {
            code.add('(');
            this.useType(code, origType);
            code.add(") ");
            return true;
        }
        return false;
    }

    private boolean processVarArg(CodeWriter code, MethodNode callMth, InsnArg lastArg) throws CodegenException {
        if (callMth == null || !callMth.getAccessFlags().isVarArgs()) {
            return false;
        }
        if (!lastArg.getType().isArray() || !lastArg.isInsnWrap()) {
            return false;
        }
        InsnNode insn = ((InsnWrapArg)lastArg).getWrapInsn();
        if (insn.getType() == InsnType.FILLED_NEW_ARRAY) {
            int count = insn.getArgsCount();
            for (int i = 0; i < count; ++i) {
                InsnArg elemArg = insn.getArg(i);
                this.addArg(code, elemArg, false);
                if (i >= count - 1) continue;
                code.add(", ");
            }
            return true;
        }
        return false;
    }

    private boolean inlineMethod(MethodNode callMthNode, InvokeNode insn, CodeWriter code) throws CodegenException {
        MethodInlineAttr mia = callMthNode.get(AType.METHOD_INLINE);
        if (mia == null) {
            return false;
        }
        InsnNode inl = mia.getInsn();
        if (callMthNode.getMethodInfo().getArgumentsTypes().isEmpty()) {
            this.makeInsn(inl, code, Flags.BODY_ONLY);
        } else {
            InsnArg[] regs = new InsnArg[callMthNode.getRegsCount()];
            List<RegisterArg> callArgs = callMthNode.getArguments(true);
            for (int i = 0; i < callArgs.size(); ++i) {
                InsnArg arg = insn.getArg(i);
                RegisterArg callArg = callArgs.get(i);
                regs[callArg.getRegNum()] = arg;
            }
            InsnNode inlCopy = inl.copy();
            ArrayList<RegisterArg> inlArgs = new ArrayList<RegisterArg>();
            inlCopy.getRegisterArgs(inlArgs);
            for (RegisterArg r : inlArgs) {
                int regNum = r.getRegNum();
                if (regNum >= regs.length) {
                    LOG.warn("Unknown register number {} in method call: {} from {}", new Object[]{r, callMthNode, this.mth});
                    continue;
                }
                InsnArg repl = regs[regNum];
                if (repl == null) {
                    LOG.warn("Not passed register {} in method call: {} from {}", new Object[]{r, callMthNode, this.mth});
                    continue;
                }
                inlCopy.replaceArg(r, repl);
            }
            this.makeInsn(inlCopy, code, Flags.BODY_ONLY);
        }
        return true;
    }

    private void makeTernary(TernaryInsn insn, CodeWriter code, Set<Flags> state) throws CodegenException {
        boolean wrap = state.contains((Object)Flags.BODY_ONLY);
        if (wrap) {
            code.add('(');
        }
        InsnArg first = insn.getArg(0);
        InsnArg second = insn.getArg(1);
        ConditionGen condGen = new ConditionGen(this);
        if (first.equals(LiteralArg.TRUE) && second.equals(LiteralArg.FALSE)) {
            condGen.add(code, insn.getCondition());
        } else {
            condGen.wrap(code, insn.getCondition());
            code.add(" ? ");
            this.addArg(code, first, false);
            code.add(" : ");
            this.addArg(code, second, false);
        }
        if (wrap) {
            code.add(')');
        }
    }

    private void makeArith(ArithNode insn, CodeWriter code, Set<Flags> state) throws CodegenException {
        boolean wrap;
        if (insn.contains(AFlag.ARITH_ONEARG)) {
            this.makeArithOneArg(insn, code);
            return;
        }
        boolean bl = wrap = state.contains((Object)Flags.BODY_ONLY) && !insn.contains(AFlag.DONT_WRAP);
        if (wrap) {
            code.add('(');
        }
        this.addArg(code, insn.getArg(0));
        code.add(' ');
        code.add(insn.getOp().getSymbol());
        code.add(' ');
        this.addArg(code, insn.getArg(1));
        if (wrap) {
            code.add(')');
        }
    }

    private void makeArithOneArg(ArithNode insn, CodeWriter code) throws CodegenException {
        LiteralArg lit;
        ArithOp op = insn.getOp();
        InsnArg arg = insn.getArg(1);
        if (arg.isLiteral() && (op == ArithOp.ADD || op == ArithOp.SUB) && (lit = (LiteralArg)arg).isInteger() && lit.getLiteral() == 1L) {
            this.assignVar(code, insn);
            String opSymbol = op.getSymbol();
            code.add(opSymbol).add(opSymbol);
            return;
        }
        this.assignVar(code, insn);
        code.add(' ').add(op.getSymbol()).add("= ");
        this.addArg(code, arg, false);
    }

    protected static enum Flags {
        BODY_ONLY,
        BODY_ONLY_NOWRAP,
        INLINE;

    }
}

