/*
 * Decompiled with CFR 0.152.
 */
package elements;

import elements.Corner;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import javax.swing.ImageIcon;
import values.Settings;

public class Buttons
extends Corner
implements MouseListener {
    private Color color = Color.lightGray;
    private ImageIcon buttonNormal = new ImageIcon(this.getClass().getClassLoader().getResource("images/button.png"));
    private ImageIcon buttonOver = new ImageIcon(this.getClass().getClassLoader().getResource("images/buttonover.png"));
    private ImageIcon button = this.buttonNormal;
    private Cursor normalCursor = new Cursor(0);
    private Cursor buttonCursor = new Cursor(12);
    private double w = 0.0;
    private double h = 0.0;
    private double bw = this.button.getIconWidth();
    private double bh = this.button.getIconHeight();

    public Buttons(Settings settings) {
        super(settings);
        this.addMouseListener(this);
    }

    public void paintComponent(Graphics graphics) {
        if (this.w != (double)this.getWidth() || this.h != (double)this.getHeight()) {
            this.w = this.getWidth();
            this.h = this.getHeight();
        }
        Graphics graphics2 = this.prepareForPaint();
        Graphics2D graphics2D = (Graphics2D)graphics2;
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2.setFont(this.getSettings().getFont());
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(this.getSettings().getString("UNDO"), this.getSettings().getFont(), fontRenderContext);
        graphics2.setColor(this.color);
        Rectangle rectangle = textLayout.getBounds().getBounds();
        double d = Settings.getBrickSizeRatio();
        graphics2.drawImage(this.button.getImage(), (int)((this.w - this.bw * d) / 2.0), (int)((this.h - this.bh * d) / 2.0) - 1, (int)(this.bw * d), (int)(this.bh * d) + 1, this);
        graphics2.drawString(this.getSettings().getString("UNDO"), ((int)this.w - rectangle.width) / 2, ((int)this.h + rectangle.height) / 2);
        graphics.drawImage(this.getBuf(), 0, 0, this);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(this.normalCursor);
        this.color = Color.lightGray;
        this.button = this.buttonNormal;
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(this.buttonCursor);
        this.color = Color.white;
        this.button = this.buttonOver;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.getSettings().getUndo().doClick();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }
}

