/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.reconstructor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.BranchInstruction;
import jd.core.model.instruction.bytecode.instruction.IConst;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.process.analyzer.instruction.bytecode.ComparisonInstructionAnalyzer;
import jd.core.process.analyzer.instruction.fast.visitor.ReplaceInstructionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TernaryOpReconstructor {
    public static void Reconstruct(List<Instruction> list) {
        int length = list.size();
        int index = 1;
        while (index < length) {
            Instruction i = list.get(index);
            if (i.opcode == 280 && index + 2 < length) {
                Instruction gi = list.get(index + 1);
                Instruction afterGi = list.get(index + 2);
                Instruction test = null;
                int indexTest = index;
                while (indexTest-- > 0) {
                    int jumpOffset;
                    Instruction instruction = list.get(indexTest);
                    int opcode = instruction.opcode;
                    if (opcode != 260 && opcode != 261 && opcode != 262 && opcode != 284 || gi.offset >= (jumpOffset = ((BranchInstruction)instruction).GetJumpOffset()) || jumpOffset > afterGi.offset) continue;
                    test = instruction;
                    break;
                }
                if (test != null) {
                    TernaryOpStore value1 = (TernaryOpStore)i;
                    ComparisonInstructionAnalyzer.InverseComparison(test);
                    TernaryOperator fto = new TernaryOperator(281, value1.ternaryOp2ndValueOffset, test.lineNumber, test, value1.objectref, null);
                    ReplaceInstructionVisitor visitor = new ReplaceInstructionVisitor(value1.ternaryOp2ndValueOffset, fto);
                    int indexVisitor = index + 2;
                    while (indexVisitor < length && visitor.getOldInstruction() == null) {
                        visitor.visit(list.get(indexVisitor++));
                    }
                    fto.value2 = visitor.getOldInstruction();
                    if (TernaryOpReconstructor.isBooleanConstant(fto.value1) && TernaryOpReconstructor.isBooleanConstant(fto.value2)) {
                        if (((IConst)fto.value1).value == 0) {
                            ComparisonInstructionAnalyzer.InverseComparison(fto.test);
                        }
                        visitor.init(fto.offset, fto.test);
                        indexVisitor = index + 2;
                        while (indexVisitor < length && visitor.getOldInstruction() == null) {
                            visitor.visit(list.get(indexVisitor++));
                        }
                    }
                    list.remove(index + 1);
                    list.remove(index);
                    list.remove(indexTest);
                    index -= 2;
                    length -= 3;
                }
            }
            ++index;
        }
    }

    private static boolean isBooleanConstant(Instruction instruction) {
        if (instruction == null) {
            return false;
        }
        switch (instruction.opcode) {
            case 16: 
            case 17: 
            case 256: {
                return "Z".equals(instruction.getReturnedSignature(null, null));
            }
        }
        return false;
    }
}

