/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.kde;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.network.proxy.NetworkProxyResolver;
import org.netbeans.core.network.proxy.NetworkProxySettings;

public class KdeNetworkProxy
implements NetworkProxyResolver {
    private static final Logger LOGGER = Logger.getLogger(KdeNetworkProxy.class.getName());
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private static final String EQUALS = "=";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String SQ_BRACKET_LEFT = "[";
    private static final String HOME = "HOME";
    private static final String KIOSLAVERC_PROXY_SETTINGS_GROUP = "[Proxy Settings]";
    private static final String KIOSLAVERC_PROXY_TYPE = "ProxyType";
    private static final String KIOSLAVERC_PROXY_CONFIG_SCRIPT = "Proxy Config Script";
    private static final String KIOSLAVERC_HTTP_PROXY = "httpProxy";
    private static final String KIOSLAVERC_HTTPS_PROXY = "httpsProxy";
    private static final String KIOSLAVERC_SOCKS_PROXY = "socksProxy";
    private static final String KIOSLAVERC_NO_PROXY_FOR = "NoProxyFor";
    private static final String KIOSLAVERC_PROXY_TYPE_NONE = "0";
    private static final String KIOSLAVERC_PROXY_TYPE_MANUAL = "1";
    private static final String KIOSLAVERC_PROXY_TYPE_PAC = "2";
    private static final String KIOSLAVERC_PROXY_TYPE_AUTO = "3";
    private static final String KIOSLAVERC_PROXY_TYPE_SYSTEM = "4";
    private static final String KIOSLAVERC_PATH_IN_HOME = ".kde/share/config/kioslaverc";
    private final String KIOSLAVERC_PATH = this.getKioslavercPath();

    @Override
    public NetworkProxySettings getNetworkProxySettings() {
        LOGGER.log(Level.FINE, "KDE system proxy resolver started.");
        Map<String, String> kioslavercMap = this.getKioslavercMap();
        String proxyType = kioslavercMap.get(KIOSLAVERC_PROXY_TYPE);
        if (proxyType == null) {
            LOGGER.log(Level.WARNING, "KDE system proxy resolver: The kioslaverc key not found ({0})", KIOSLAVERC_PROXY_TYPE);
            return new NetworkProxySettings(false);
        }
        if (proxyType.equals(KIOSLAVERC_PROXY_TYPE_NONE) || proxyType.equals(KIOSLAVERC_PROXY_TYPE_AUTO)) {
            LOGGER.log(Level.INFO, "KDE system proxy resolver: direct (proxy type: {0})", proxyType);
            return new NetworkProxySettings();
        }
        if (proxyType.equals(KIOSLAVERC_PROXY_TYPE_PAC)) {
            LOGGER.log(Level.INFO, "KDE system proxy resolver: auto - PAC");
            String pacFileUrl = kioslavercMap.get(KIOSLAVERC_PROXY_CONFIG_SCRIPT);
            if (pacFileUrl != null) {
                LOGGER.log(Level.INFO, "KDE system proxy resolver: PAC URL ({0})", pacFileUrl);
                return new NetworkProxySettings(pacFileUrl);
            }
            LOGGER.log(Level.INFO, "KDE system proxy resolver: PAC URL null value");
            return new NetworkProxySettings(false);
        }
        if (proxyType.equals(KIOSLAVERC_PROXY_TYPE_MANUAL) || proxyType.equals(KIOSLAVERC_PROXY_TYPE_SYSTEM)) {
            LOGGER.log(Level.INFO, "KDE system proxy resolver: manual (proxy type: {0})", proxyType);
            String httpProxy = kioslavercMap.get(KIOSLAVERC_HTTP_PROXY);
            String httpsProxy = kioslavercMap.get(KIOSLAVERC_HTTPS_PROXY);
            String socksProxy = kioslavercMap.get(KIOSLAVERC_SOCKS_PROXY);
            String noProxyFor = kioslavercMap.get(KIOSLAVERC_NO_PROXY_FOR);
            LOGGER.log(Level.INFO, "KDE system proxy resolver: http proxy ({0})", httpProxy);
            LOGGER.log(Level.INFO, "KDE system proxy resolver: https proxy ({0})", httpsProxy);
            LOGGER.log(Level.INFO, "KDE system proxy resolver: socks proxy ({0})", socksProxy);
            LOGGER.log(Level.INFO, "KDE system proxy resolver: no proxy ({0})", noProxyFor);
            if (proxyType.equals(KIOSLAVERC_PROXY_TYPE_MANUAL)) {
                httpProxy = httpProxy == null ? EMPTY_STRING : httpProxy.trim().replaceAll(SPACE, COLON);
                httpsProxy = httpsProxy == null ? EMPTY_STRING : httpsProxy.trim().replaceAll(SPACE, COLON);
                socksProxy = socksProxy == null ? EMPTY_STRING : socksProxy.trim().replaceAll(SPACE, COLON);
            }
            String[] noProxyHosts = KdeNetworkProxy.getNoProxyHosts(noProxyFor);
            return new NetworkProxySettings(httpProxy, httpsProxy, socksProxy, noProxyHosts);
        }
        return new NetworkProxySettings(false);
    }

    private Map<String, String> getKioslavercMap() {
        File kioslavercFile = new File(this.KIOSLAVERC_PATH);
        HashMap<String, String> map = new HashMap<String, String>();
        if (kioslavercFile.exists()) {
            try (BufferedReader br = Files.newBufferedReader(kioslavercFile.toPath());){
                String line;
                boolean inGroup = false;
                while ((line = br.readLine()) != null) {
                    if (inGroup) {
                        if (line.contains(EQUALS)) {
                            int indexOfEquals = line.indexOf(EQUALS);
                            String key = line.substring(0, indexOfEquals);
                            String value = line.substring(indexOfEquals + 1);
                            map.put(key, value);
                            continue;
                        }
                        if (!line.startsWith(SQ_BRACKET_LEFT)) continue;
                        break;
                    }
                    if (!line.startsWith(KIOSLAVERC_PROXY_SETTINGS_GROUP)) continue;
                    inGroup = true;
                }
            }
            catch (IOException | InvalidPathException ex) {
                LOGGER.log(Level.SEVERE, "Cannot read file: ", ex);
            }
        } else {
            LOGGER.log(Level.WARNING, "KDE system proxy resolver: The kioslaverc file not found ({0})", this.KIOSLAVERC_PATH);
        }
        return map;
    }

    private String getKioslavercPath() {
        String homePath = System.getenv(HOME);
        if (homePath != null) {
            return homePath + File.separator + KIOSLAVERC_PATH_IN_HOME;
        }
        return EMPTY_STRING;
    }

    private static String[] getNoProxyHosts(String noProxyHostsString) {
        if (noProxyHostsString != null && !noProxyHostsString.isEmpty()) {
            return noProxyHostsString.split(COMMA);
        }
        return new String[0];
    }
}

