/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.broker;

import java.util.Collection;
import java.util.List;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.broker.AbstractBrokerMessageHandler;
import org.springframework.messaging.simp.broker.DefaultSubscriptionRegistry;
import org.springframework.messaging.simp.broker.SubscriptionRegistry;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public class SimpleBrokerMessageHandler
extends AbstractBrokerMessageHandler {
    private static final byte[] EMPTY_PAYLOAD = new byte[0];
    private final SubscribableChannel clientInboundChannel;
    private final MessageChannel clientOutboundChannel;
    private final SubscribableChannel brokerChannel;
    private SubscriptionRegistry subscriptionRegistry = new DefaultSubscriptionRegistry();

    public SimpleBrokerMessageHandler(SubscribableChannel clientInboundChannel, MessageChannel clientOutboundChannel, SubscribableChannel brokerChannel, Collection<String> destinationPrefixes) {
        super(destinationPrefixes);
        Assert.notNull((Object)clientInboundChannel, (String)"'clientInboundChannel' must not be null");
        Assert.notNull((Object)clientOutboundChannel, (String)"'clientOutboundChannel' must not be null");
        Assert.notNull((Object)brokerChannel, (String)"'brokerChannel' must not be null");
        this.clientInboundChannel = clientInboundChannel;
        this.clientOutboundChannel = clientOutboundChannel;
        this.brokerChannel = brokerChannel;
    }

    public SubscribableChannel getClientInboundChannel() {
        return this.clientInboundChannel;
    }

    public MessageChannel getClientOutboundChannel() {
        return this.clientOutboundChannel;
    }

    public SubscribableChannel getBrokerChannel() {
        return this.brokerChannel;
    }

    public void setSubscriptionRegistry(SubscriptionRegistry subscriptionRegistry) {
        Assert.notNull((Object)subscriptionRegistry, (String)"SubscriptionRegistry must not be null");
        this.subscriptionRegistry = subscriptionRegistry;
    }

    public SubscriptionRegistry getSubscriptionRegistry() {
        return this.subscriptionRegistry;
    }

    @Override
    public void startInternal() {
        this.publishBrokerAvailableEvent();
        this.clientInboundChannel.subscribe(this);
        this.brokerChannel.subscribe(this);
    }

    @Override
    public void stopInternal() {
        this.publishBrokerUnavailableEvent();
        this.clientInboundChannel.unsubscribe(this);
        this.brokerChannel.unsubscribe(this);
    }

    @Override
    protected void handleMessageInternal(Message<?> message) {
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        SimpMessageType messageType = headers.getMessageType();
        String destination = headers.getDestination();
        if (!this.checkDestinationPrefix(destination)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Ignoring message to destination=" + destination));
            }
            return;
        }
        if (SimpMessageType.SUBSCRIBE.equals((Object)messageType)) {
            this.subscriptionRegistry.registerSubscription(message);
        } else if (SimpMessageType.UNSUBSCRIBE.equals((Object)messageType)) {
            this.subscriptionRegistry.unregisterSubscription(message);
        } else if (SimpMessageType.MESSAGE.equals((Object)messageType)) {
            this.sendMessageToSubscribers(headers.getDestination(), message);
        } else if (SimpMessageType.DISCONNECT.equals((Object)messageType)) {
            String sessionId = headers.getSessionId();
            this.subscriptionRegistry.unregisterAllSubscriptions(sessionId);
        } else if (SimpMessageType.CONNECT.equals((Object)messageType)) {
            SimpMessageHeaderAccessor replyHeaders = SimpMessageHeaderAccessor.create(SimpMessageType.CONNECT_ACK);
            replyHeaders.setSessionId(headers.getSessionId());
            replyHeaders.setHeader("simpConnectMessage", message);
            Message<byte[]> connectAck = MessageBuilder.withPayload(EMPTY_PAYLOAD).setHeaders(replyHeaders).build();
            this.clientOutboundChannel.send(connectAck);
        }
    }

    protected void sendMessageToSubscribers(String destination, Message<?> message) {
        MultiValueMap<String, String> subscriptions = this.subscriptionRegistry.findSubscriptions(message);
        if (subscriptions.size() > 0 && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Sending message with destination=" + destination + " to " + subscriptions.size() + " subscriber(s)"));
        }
        for (String sessionId : subscriptions.keySet()) {
            for (String subscriptionId : (List)subscriptions.get((Object)sessionId)) {
                SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
                headers.setSessionId(sessionId);
                headers.setSubscriptionId(subscriptionId);
                Object payload = message.getPayload();
                Message<?> clientMessage = MessageBuilder.withPayload(payload).setHeaders(headers).build();
                try {
                    this.clientOutboundChannel.send(clientMessage);
                }
                catch (Throwable ex) {
                    this.logger.error((Object)("Failed to send message to destination=" + destination + ", sessionId=" + sessionId + ", subscriptionId=" + subscriptionId), ex);
                }
            }
        }
    }
}

