/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.Bundle;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.OperatorPrecedence;
import org.netbeans.modules.refactoring.java.plugins.TreeDuplicator;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;

public class InlineMethodTransformer
extends RefactoringVisitor {
    private static final EnumSet<Tree.Kind> LITERALS = EnumSet.of(Tree.Kind.LAMBDA_EXPRESSION, new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.ERRONEOUS});
    private Trees trees;
    private MethodTree methodTree;
    private boolean hasParameters;
    private Problem problem;
    private HashMap<Tree, Tree> original2Translated;
    private final Deque<Map<Tree, List<StatementTree>>> newStatsQueue;
    private final Deque<Map<Tree, Tree>> translateQueue;
    private final LinkedList<String> definedIds;
    private final HashSet<Element> changedParamters;
    private final TreePathHandle tph;

    public InlineMethodTransformer(TreePathHandle tph) {
        this.tph = tph;
        this.newStatsQueue = new LinkedList<Map<Tree, List<StatementTree>>>();
        this.translateQueue = new LinkedList<Map<Tree, Tree>>();
        this.definedIds = new LinkedList();
        this.changedParamters = new HashSet();
    }

    public Problem getProblem() {
        return this.problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        try {
            GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
            genUtils.importComments((Tree)node, node);
            this.trees = this.workingCopy.getTrees();
            this.methodTree = (MethodTree)this.trees.getTree(p);
            this.hasParameters = this.methodTree.getParameters().size() > 0;
            Tree tree = (Tree)super.visitCompilationUnit(node, (Object)p);
            return tree;
        }
        finally {
            this.trees = null;
            this.methodTree = null;
            this.hasParameters = false;
        }
    }

    public Tree visitClass(ClassTree node, Element p) {
        TreePath classPath = this.getCurrentPath();
        ClassTree classTree = node;
        for (Tree tree : classTree.getMembers()) {
            TreePath memberPath = new TreePath(classPath, tree);
            Element element = this.workingCopy.getTrees().getElement(memberPath);
            if (!p.equals(element)) continue;
            classTree = this.make.removeClassMember(classTree, tree);
            break;
        }
        if (classPath.getParentPath().getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            this.original2Translated.put(node, classTree);
            return (Tree)super.visitClass(node, (Object)p);
        }
        this.original2Translated = new HashMap();
        Tree value = (Tree)super.visitClass(node, (Object)p);
        classTree = (ClassTree)this.workingCopy.getTreeUtilities().translate((Tree)classTree, this.original2Translated);
        this.rewrite(node, classTree);
        return value;
    }

    public Tree visitBlock(BlockTree node, Element p) {
        this.newStatsQueue.add(new HashMap());
        this.translateQueue.add(new HashMap());
        int nrOfIds = this.definedIds.size();
        Tree value = (Tree)super.visitBlock(node, (Object)p);
        while (this.definedIds.size() > nrOfIds) {
            this.definedIds.pop();
        }
        Map<Tree, List<StatementTree>> newStatementsForBlock = this.newStatsQueue.pollLast();
        Map<Tree, Tree> original2TranslatedForBlock = this.translateQueue.pollLast();
        if (!newStatementsForBlock.isEmpty()) {
            LinkedList<StatementTree> newStatementList = new LinkedList<StatementTree>();
            for (StatementTree statementTree : node.getStatements()) {
                Tree tree;
                List<StatementTree> stats = newStatementsForBlock.get(statementTree);
                if (stats != null) {
                    newStatementList.addAll(stats);
                }
                if ((tree = original2TranslatedForBlock.get(statementTree)) != null && tree.getKind() == Tree.Kind.EMPTY_STATEMENT && ((JCTree)tree).pos < 0) continue;
                newStatementList.add(statementTree);
            }
            BlockTree newBlock = this.make.Block(newStatementList, node.isStatic());
            if (!original2TranslatedForBlock.isEmpty()) {
                newBlock = (BlockTree)this.workingCopy.getTreeUtilities().translate((Tree)newBlock, original2TranslatedForBlock);
            }
            this.original2Translated.put(node, newBlock);
        }
        return value;
    }

    public Tree visitMethod(MethodTree node, Element p) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return node;
        }
        return (Tree)super.visitMethod(node, (Object)p);
    }

    public Tree visitMemberReference(MemberReferenceTree node, Element methodElement) {
        TreePath methodInvocationPath = this.getCurrentPath();
        Element el = this.trees.getElement(methodInvocationPath);
        if (el != null && el.getKind() == ElementKind.METHOD && methodElement.equals(el)) {
            List<? extends VariableTree> parameters = this.methodTree.getParameters();
            BlockTree body = this.methodTree.getBody();
            HashMap<Tree, Tree> original2TranslatedBody = new HashMap<Tree, Tree>();
            this.scanForNameClash(methodInvocationPath, body, methodElement, original2TranslatedBody);
            if (this.problem != null && this.problem.isFatal()) {
                return node;
            }
            body = (BlockTree)this.workingCopy.getTreeUtilities().translate((Tree)body, original2TranslatedBody);
            LambdaExpressionTree lambda = this.make.LambdaExpression(parameters, (Tree)body);
            this.rewrite(node, lambda);
        }
        return (Tree)super.visitMemberReference(node, (Object)methodElement);
    }

    public Tree visitMethodInvocation(MethodInvocationTree node, Element methodElement) {
        Tree value = (Tree)super.visitMethodInvocation(node, (Object)methodElement);
        TreePath methodInvocationPath = this.getCurrentPath();
        Element el = this.trees.getElement(methodInvocationPath);
        if (el != null && el.getKind() == ElementKind.METHOD && methodElement.equals(el)) {
            Tree methodInvocation;
            GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
            ExecutableElement method = (ExecutableElement)el;
            LinkedList<StatementTree> newStatementList = new LinkedList<StatementTree>();
            TypeElement bodyEnclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(methodElement);
            TreePath findEnclosingClass = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, methodInvocationPath, true, true, true, true, true);
            Element invocationEnclosingTypeElement = this.workingCopy.getTrees().getElement(findEnclosingClass);
            boolean inSameClass = bodyEnclosingTypeElement.equals(invocationEnclosingTypeElement);
            boolean inStatic = !methodElement.getModifiers().contains((Object)Modifier.STATIC) && this.isInStaticContext(methodInvocationPath);
            boolean invokeOnInstance = false;
            MethodInvocationTree invTree = (MethodInvocationTree)methodInvocationPath.getLeaf();
            if (!methodElement.getModifiers().contains((Object)Modifier.STATIC) && invTree.getMethodSelect().getKind() == Tree.Kind.MEMBER_SELECT) {
                invokeOnInstance = true;
                MemberSelectTree mst = (MemberSelectTree)invTree.getMethodSelect();
                if (mst.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                    Name n = ((IdentifierTree)mst.getExpression()).getName();
                    invokeOnInstance = !n.contentEquals("this");
                }
            }
            TreePath statementPath = this.findCorrespondingStatement(methodInvocationPath);
            StatementTree statementTree = (StatementTree)statementPath.getLeaf();
            BlockTree body = this.methodTree.getBody();
            HashMap<Tree, Tree> original2TranslatedBody = new HashMap<Tree, Tree>();
            this.scanForNameClash(methodInvocationPath, body, methodElement, original2TranslatedBody);
            if (this.problem != null && this.problem.isFatal()) {
                return node;
            }
            TreeUtilities treeUtilities = this.workingCopy.getTreeUtilities();
            body = (BlockTree)treeUtilities.translate((Tree)body, original2TranslatedBody);
            final Boolean[] multiplereturn = new Boolean[]{null};
            new ErrorAwareTreeScanner<Void, Void>(){

                public Void scan(Tree node, Void p) {
                    if (Boolean.TRUE == multiplereturn[0]) {
                        return null;
                    }
                    return (Void)super.scan(node, (Object)p);
                }

                public Void visitNewClass(NewClassTree node, Void p) {
                    return null;
                }

                public Void visitReturn(ReturnTree node, Void p) {
                    multiplereturn[0] = multiplereturn[0] == null ? Boolean.FALSE : Boolean.TRUE;
                    return (Void)super.visitReturn(node, (Object)p);
                }
            }.scan((Tree)body, null);
            if (this.hasParameters) {
                HashMap<Tree, Tree> original2TranslatedBody2 = new HashMap<Tree, Tree>();
                this.replaceParametersWithArguments(original2TranslatedBody2, method, node, methodInvocationPath, body, newStatementList);
                body = (BlockTree)treeUtilities.translate((Tree)body, original2TranslatedBody2);
            }
            TreePath methodPath = this.trees.getPath(methodElement);
            TreePath bodyPath = new TreePath(methodPath, this.methodTree.getBody());
            Scope scope = this.workingCopy.getTrees().getScope(methodInvocationPath);
            ExpressionTree methodSelect = node.getMethodSelect();
            methodSelect = methodSelect.getKind() == Tree.Kind.MEMBER_SELECT ? ((MemberSelectTree)methodSelect).getExpression() : null;
            for (int i = 0; i < body.getStatements().size() - 1; ++i) {
                StatementTree statement = body.getStatements().get(i);
                if (!inSameClass || invokeOnInstance || inStatic) {
                    statement = (StatementTree)this.fixReferences(statement, new TreePath(bodyPath, statement), method, scope, methodSelect);
                    if (!inSameClass) {
                        statement = (StatementTree)genUtils.importFQNs((Tree)statement);
                    }
                }
                newStatementList.add(statement);
            }
            Tree parent = methodInvocationPath.getParentPath().getLeaf();
            Tree grandparent = null;
            if (parent.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
                methodInvocation = node;
            } else {
                grandparent = methodInvocationPath.getParentPath().getParentPath().getLeaf();
                switch (grandparent.getKind()) {
                    case FOR_LOOP: 
                    case ENHANCED_FOR_LOOP: 
                    case WHILE_LOOP: 
                    case DO_WHILE_LOOP: 
                    case IF: {
                        methodInvocation = grandparent;
                        break;
                    }
                    default: {
                        methodInvocation = parent;
                    }
                }
            }
            Tree lastStatement = body.getStatements().size() > 0 ? (Tree)body.getStatements().get(body.getStatements().size() - 1) : null;
            if (lastStatement != null && (!inSameClass || invokeOnInstance || inStatic)) {
                lastStatement = this.fixReferences(lastStatement, new TreePath(bodyPath, lastStatement), method, scope, methodSelect);
                if (!inSameClass) {
                    lastStatement = genUtils.importFQNs(lastStatement);
                }
            }
            if (Boolean.TRUE == multiplereturn[0]) {
                if (parent.getKind() == Tree.Kind.RETURN) {
                    Map<Tree, List<StatementTree>> addedStatementsForBlock = this.newStatsQueue.getLast();
                    Map<Tree, Tree> translateMap = this.translateQueue.getLast();
                    List<StatementTree> stats = addedStatementsForBlock.get(statementTree);
                    if (stats == null) {
                        stats = new LinkedList<StatementTree>();
                        addedStatementsForBlock.put(statementTree, stats);
                    }
                    stats.addAll(newStatementList);
                    genUtils.copyComments(methodInvocation, lastStatement, true);
                    List comments = this.workingCopy.getTreeUtilities().getComments(methodInvocation, false);
                    for (Comment comment : comments) {
                        this.make.addComment(lastStatement, Comment.create((Comment.Style)comment.style(), (String)comment.getText()), false);
                    }
                    translateMap.put(parent, lastStatement);
                    return value;
                }
                SourcePositions positions = this.workingCopy.getTrees().getSourcePositions();
                long startPosition = positions.getStartPosition(this.workingCopy.getCompilationUnit(), node);
                long lineNumber = this.workingCopy.getCompilationUnit().getLineMap().getLineNumber(startPosition);
                String source = FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject()) + ':' + lineNumber;
                this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(true, Bundle.ERR_InlineMethodMultipleReturn(source)));
                return value;
            }
            HashMap<Tree, Tree> translateMap = this.translateQueue.size() > 0 ? this.translateQueue.getLast() : this.original2Translated;
            lastStatement = this.translateLastStatement(genUtils, parent, grandparent, newStatementList, lastStatement, node, methodInvocationPath, method, translateMap);
            Element element = this.workingCopy.getTrees().getElement(statementPath);
            if (element != null && element.getKind() == ElementKind.FIELD) {
                if (!newStatementList.isEmpty()) {
                    SourcePositions positions = this.workingCopy.getTrees().getSourcePositions();
                    long startPosition = positions.getStartPosition(this.workingCopy.getCompilationUnit(), node);
                    long lineNumber = this.workingCopy.getCompilationUnit().getLineMap().getLineNumber(startPosition);
                    String source = FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject()) + ':' + lineNumber;
                    this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, Bundle.WRN_InlineMethodMultipleLines(source)));
                } else {
                    if (lastStatement instanceof StatementTree) {
                        SourcePositions positions = this.workingCopy.getTrees().getSourcePositions();
                        long startPosition = positions.getStartPosition(this.workingCopy.getCompilationUnit(), node);
                        long lineNumber = this.workingCopy.getCompilationUnit().getLineMap().getLineNumber(startPosition);
                        String source = FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject()) + ':' + lineNumber;
                        this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(true, Bundle.ERR_InlineMethodNoLastReturn(source)));
                        return value;
                    }
                    genUtils.copyComments(methodInvocation, lastStatement, true);
                    List comments = this.workingCopy.getTreeUtilities().getComments(methodInvocation, false);
                    for (Comment comment : comments) {
                        this.make.addComment(lastStatement, Comment.create((Comment.Style)comment.style(), (String)comment.getText()), false);
                    }
                    this.rewrite(methodInvocation, lastStatement);
                }
            } else {
                if (lastStatement instanceof StatementTree && parent.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
                    SourcePositions positions = this.workingCopy.getTrees().getSourcePositions();
                    long startPosition = positions.getStartPosition(this.workingCopy.getCompilationUnit(), node);
                    long lineNumber = this.workingCopy.getCompilationUnit().getLineMap().getLineNumber(startPosition);
                    String source = FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject()) + ':' + lineNumber;
                    this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(true, Bundle.ERR_InlineMethodNoLastReturn(source)));
                    return value;
                }
                Map<Tree, List<StatementTree>> addedStatementsForBlock = this.newStatsQueue.getLast();
                List<StatementTree> stats = addedStatementsForBlock.get(statementTree);
                if (stats == null) {
                    stats = new LinkedList<StatementTree>();
                    addedStatementsForBlock.put(statementTree, stats);
                }
                stats.addAll(newStatementList);
                genUtils.copyComments(methodInvocation, lastStatement, true);
                List comments = this.workingCopy.getTreeUtilities().getComments(methodInvocation, false);
                for (Comment comment : comments) {
                    this.make.addComment(lastStatement, Comment.create((Comment.Style)comment.style(), (String)comment.getText()), false);
                }
                translateMap.put(methodInvocation, lastStatement == null ? this.make.EmptyStatement() : lastStatement);
            }
        }
        return value;
    }

    private boolean isInStaticContext(TreePath methodInvocationPath) {
        TreePath parent;
        for (parent = methodInvocationPath.getParentPath(); parent != null && parent.getLeaf().getKind() != Tree.Kind.METHOD; parent = parent.getParentPath()) {
        }
        return parent != null && ((MethodTree)parent.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.STATIC);
    }

    private Tree fixReferences(Tree tree, TreePath treePath, final ExecutableElement method, final Scope scope, final ExpressionTree methodSelect) {
        final HashMap orig2trans = new HashMap();
        final ElementUtilities elementUtilities = this.workingCopy.getElementUtilities();
        final TypeElement bodyEnclosingTypeElement = elementUtilities.enclosingTypeElement((Element)method);
        ErrorAwareTreePathScanner<Void, ExecutableElement> idScan = new ErrorAwareTreePathScanner<Void, ExecutableElement>(){

            public Void visitIdentifier(IdentifierTree node, ExecutableElement p) {
                TreePath currentPath = this.getCurrentPath();
                if (currentPath.getParentPath().getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
                    return (Void)super.visitIdentifier(node, (Object)p);
                }
                Element el = InlineMethodTransformer.this.trees.getElement(currentPath);
                if (el != null) {
                    TypeMirror targetType = el.getEnclosingElement().asType();
                    if (methodSelect != null && targetType != null && targetType.getKind() == TypeKind.DECLARED && el.getEnclosingElement() != method && !InlineMethodTransformer.this.workingCopy.getTrees().isAccessible(scope, el, (DeclaredType)targetType)) {
                        InlineMethodTransformer.this.problem = JavaPluginUtils.chainProblems(InlineMethodTransformer.this.problem, new Problem(false, Bundle.WRN_InlineNotAccessible(el, targetType)));
                    }
                    TypeElement invocationEnclosingTypeElement = elementUtilities.enclosingTypeElement(el);
                    if (el.getKind() != ElementKind.LOCAL_VARIABLE && bodyEnclosingTypeElement.equals(invocationEnclosingTypeElement)) {
                        if (el.getModifiers().contains((Object)Modifier.STATIC)) {
                            ExpressionTree newTree = InlineMethodTransformer.this.make.QualIdent(el);
                            orig2trans.put(node, newTree);
                        } else if (methodSelect != null) {
                            MemberSelectTree newTree = InlineMethodTransformer.this.make.MemberSelect(methodSelect, el);
                            orig2trans.put(node, newTree);
                        }
                    }
                }
                return (Void)super.visitIdentifier(node, (Object)p);
            }

            public Void visitMethodInvocation(MethodInvocationTree node, ExecutableElement p) {
                TreePath currentPath = this.getCurrentPath();
                if (currentPath.getParentPath().getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
                    return (Void)super.visitMethodInvocation(node, (Object)p);
                }
                Element el = InlineMethodTransformer.this.trees.getElement(currentPath);
                if (el != null && el != p) {
                    TypeElement invocationEnclosingTypeElement;
                    DeclaredType declaredType = InlineMethodTransformer.this.workingCopy.getTypes().getDeclaredType(scope.getEnclosingClass(), new TypeMirror[0]);
                    if (methodSelect != null && el.getEnclosingElement() != method && !InlineMethodTransformer.this.workingCopy.getTrees().isAccessible(scope, el, declaredType)) {
                        InlineMethodTransformer.this.problem = JavaPluginUtils.chainProblems(InlineMethodTransformer.this.problem, new Problem(false, Bundle.WRN_InlineNotAccessible(el, declaredType)));
                    }
                    if (bodyEnclosingTypeElement.equals(invocationEnclosingTypeElement = elementUtilities.enclosingTypeElement(el))) {
                        if (el.getModifiers().contains((Object)Modifier.STATIC)) {
                            ExpressionTree newTree = InlineMethodTransformer.this.make.QualIdent(el);
                            orig2trans.put(node.getMethodSelect(), newTree);
                        } else {
                            ExpressionTree methodInvocationSelect = node.getMethodSelect();
                            if (methodInvocationSelect.getKind() == Tree.Kind.MEMBER_SELECT) {
                                ExpressionTree expression = ((MemberSelectTree)methodInvocationSelect).getExpression();
                                String isThis = expression.toString();
                                if (isThis.equals("this") || isThis.endsWith(".this")) {
                                    if (methodSelect == null) {
                                        MemberSelectTree memberSelect = InlineMethodTransformer.this.make.MemberSelect(InlineMethodTransformer.this.workingCopy.getTreeUtilities().parseExpression(bodyEnclosingTypeElement.getSimpleName() + ".this", new SourcePositions[1]), el);
                                        orig2trans.put(node, memberSelect);
                                    } else {
                                        orig2trans.put(expression, methodSelect);
                                    }
                                } else if (methodSelect != null) {
                                    MemberSelectTree newTree = InlineMethodTransformer.this.make.MemberSelect(methodSelect, el);
                                    orig2trans.put(node, newTree);
                                }
                            } else if (methodSelect != null) {
                                MemberSelectTree newTree = InlineMethodTransformer.this.make.MemberSelect(methodSelect, el);
                                orig2trans.put(methodInvocationSelect, newTree);
                            }
                        }
                    }
                }
                if (el != null && el == p) {
                    return null;
                }
                return (Void)super.visitMethodInvocation(node, (Object)p);
            }

            public Void visitMemberSelect(MemberSelectTree node, ExecutableElement p) {
                TreePath currentPath = this.getCurrentPath();
                Element el = InlineMethodTransformer.this.trees.getElement(currentPath);
                if (el != null && el.getKind() != ElementKind.PACKAGE) {
                    TypeElement invocationEnclosingTypeElement;
                    DeclaredType declaredType = InlineMethodTransformer.this.workingCopy.getTypes().getDeclaredType(scope.getEnclosingClass(), new TypeMirror[0]);
                    if (methodSelect != null && el.getEnclosingElement() != method && !InlineMethodTransformer.this.workingCopy.getTrees().isAccessible(scope, el, declaredType)) {
                        InlineMethodTransformer.this.problem = JavaPluginUtils.chainProblems(InlineMethodTransformer.this.problem, new Problem(false, Bundle.WRN_InlineNotAccessible(el, declaredType)));
                    }
                    if (bodyEnclosingTypeElement.equals(invocationEnclosingTypeElement = elementUtilities.enclosingTypeElement(el))) {
                        if (el.getModifiers().contains((Object)Modifier.STATIC)) {
                            ExpressionTree newTree = InlineMethodTransformer.this.make.QualIdent(el);
                            orig2trans.put(node, newTree);
                        } else {
                            ExpressionTree expression = node.getExpression();
                            String isThis = expression.toString();
                            if (isThis.equals("this") || isThis.endsWith(".this")) {
                                if (methodSelect == null) {
                                    MemberSelectTree memberSelect = InlineMethodTransformer.this.make.MemberSelect(InlineMethodTransformer.this.workingCopy.getTreeUtilities().parseExpression(bodyEnclosingTypeElement.getSimpleName() + ".this", new SourcePositions[1]), el);
                                    orig2trans.put(node, memberSelect);
                                } else {
                                    orig2trans.put(expression, methodSelect);
                                }
                            } else if (methodSelect != null) {
                                MemberSelectTree newTree = InlineMethodTransformer.this.make.MemberSelect(methodSelect, el);
                                orig2trans.put(node, newTree);
                            }
                        }
                    }
                }
                return (Void)super.visitMemberSelect(node, (Object)p);
            }
        };
        idScan.scan(treePath, (Object)method);
        Tree result = this.workingCopy.getTreeUtilities().translate(tree, orig2trans);
        return result;
    }

    private void scanForNameClash(final TreePath methodInvocationPath, Tree body, Element p, final HashMap<Tree, Tree> original2TranslatedBody) {
        Element resolved = this.tph.getElementHandle().resolve((CompilationInfo)this.workingCopy);
        final CompilationUnitTree compilationUnitTree = this.workingCopy.getTrees().getPath(resolved).getCompilationUnit();
        final LinkedList renames = new LinkedList();
        ErrorAwareTreeScanner<Void, ExecutableElement> nameClashScanner = new ErrorAwareTreeScanner<Void, ExecutableElement>(){

            public Void visitVariable(VariableTree node, ExecutableElement p) {
                Element variable;
                TreePath path = InlineMethodTransformer.this.trees.getPath(compilationUnitTree, node);
                if (!(path == null || (variable = InlineMethodTransformer.this.trees.getElement(path)) == null || variable.getKind() == ElementKind.PARAMETER && p.getParameters().contains((VariableElement)variable))) {
                    String varName = node.getName().toString();
                    String uniqueName = JavaPluginUtils.makeNameUnique((CompilationInfo)InlineMethodTransformer.this.workingCopy, InlineMethodTransformer.this.workingCopy.getTrees().getScope(methodInvocationPath), varName, InlineMethodTransformer.this.definedIds);
                    if (uniqueName == null ? varName != null : !uniqueName.equals(varName)) {
                        original2TranslatedBody.put(node, InlineMethodTransformer.this.make.setLabel((Tree)node, (CharSequence)uniqueName));
                        renames.add(Pair.of((Object)variable, (Object)uniqueName));
                        InlineMethodTransformer.this.definedIds.add(uniqueName);
                    } else {
                        InlineMethodTransformer.this.definedIds.add(varName);
                    }
                }
                return (Void)super.visitVariable(node, (Object)p);
            }

            public Void visitAssignment(AssignmentTree node, ExecutableElement p) {
                this.checkParameter(node.getVariable());
                return (Void)super.visitAssignment(node, (Object)p);
            }

            public Void visitCompoundAssignment(CompoundAssignmentTree node, ExecutableElement p) {
                this.checkParameter(node.getVariable());
                return (Void)super.visitCompoundAssignment(node, (Object)p);
            }

            public Void visitUnary(UnaryTree node, ExecutableElement p) {
                this.checkParameter(node.getExpression());
                return (Void)super.visitUnary(node, (Object)p);
            }

            private void checkParameter(Tree node) {
                Element variable;
                TreePath path = InlineMethodTransformer.this.trees.getPath(compilationUnitTree, node);
                if (path != null && (variable = InlineMethodTransformer.this.trees.getElement(path)) != null && variable.getKind() == ElementKind.PARAMETER) {
                    InlineMethodTransformer.this.changedParamters.add(variable);
                }
            }
        };
        nameClashScanner.scan(body, (Object)((ExecutableElement)p));
        ErrorAwareTreeScanner<Void, Pair<Element, String>> idScan = new ErrorAwareTreeScanner<Void, Pair<Element, String>>(){

            public Void visitIdentifier(IdentifierTree node, Pair<Element, String> p) {
                TreePath path = InlineMethodTransformer.this.trees.getPath(compilationUnitTree, node);
                Element el = null;
                if (path != null) {
                    el = InlineMethodTransformer.this.trees.getElement(path);
                }
                if (((Element)p.first()).equals(el)) {
                    original2TranslatedBody.put(node, InlineMethodTransformer.this.make.setLabel((Tree)node, (CharSequence)p.second()));
                }
                return (Void)super.visitIdentifier(node, p);
            }
        };
        for (Pair pair : renames) {
            idScan.scan(body, (Object)pair);
        }
    }

    private TreePath findCorrespondingStatement(TreePath methodInvocationPath) {
        TreePath statementPath;
        block3: for (statementPath = methodInvocationPath; statementPath != null; statementPath = statementPath.getParentPath()) {
            if (statementPath.getParentPath() == null) continue;
            switch (statementPath.getParentPath().getLeaf().getKind()) {
                case BLOCK: 
                case CLASS: {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        return statementPath;
    }

    private void replaceParametersWithArguments(final HashMap<Tree, Tree> original2TranslatedBody, ExecutableElement el, MethodInvocationTree node, TreePath methodInvocationPath, BlockTree body, List<StatementTree> newVars) {
        Element resolved = this.tph.getElementHandle().resolve((CompilationInfo)this.workingCopy);
        final CompilationUnitTree compilationUnitTree = this.workingCopy.getTrees().getPath(resolved).getCompilationUnit();
        LinkedList<Pair> renames = new LinkedList<Pair>();
        ErrorAwareTreeScanner<Void, Pair<VariableElement, ExpressionTree>> idScan = new ErrorAwareTreeScanner<Void, Pair<VariableElement, ExpressionTree>>(){

            public Void visitIdentifier(IdentifierTree node, Pair<VariableElement, ExpressionTree> p) {
                TreePath currentPath = InlineMethodTransformer.this.trees.getPath(compilationUnitTree, node);
                Element el = null;
                if (currentPath != null) {
                    el = InlineMethodTransformer.this.trees.getElement(currentPath);
                }
                if (((VariableElement)p.first()).equals(el)) {
                    original2TranslatedBody.put(node, p.second());
                }
                return (Void)super.visitIdentifier(node, p);
            }
        };
        for (int i = 0; i < el.getParameters().size(); ++i) {
            VariableElement element = el.getParameters().get(i);
            if (el.isVarArgs() && el.getParameters().size() == i + 1) {
                ArrayType asType = (ArrayType)element.asType();
                Tree type = this.make.Type(asType.getComponentType());
                Tree arraytype = this.make.Type((TypeMirror)asType);
                LinkedList<? extends ExpressionTree> arguments = new LinkedList<ExpressionTree>();
                if (node.getArguments().size() > i) {
                    arguments.addAll(node.getArguments().subList(i, node.getArguments().size()));
                }
                String varName = element.getSimpleName().toString();
                String uniqueName = JavaPluginUtils.makeNameUnique((CompilationInfo)this.workingCopy, this.workingCopy.getTrees().getScope(methodInvocationPath), varName, this.definedIds);
                if (uniqueName == null ? varName != null : !uniqueName.equals(varName)) {
                    renames.add(Pair.of((Object)element, (Object)uniqueName));
                    this.definedIds.add(uniqueName);
                } else {
                    this.definedIds.add(varName);
                }
                newVars.add(this.make.Variable(this.make.Modifiers(element.getModifiers()), (CharSequence)((uniqueName == null ? varName != null : !uniqueName.equals(varName)) ? uniqueName : varName), arraytype, (ExpressionTree)this.make.NewArray(type, Collections.EMPTY_LIST, arguments)));
                continue;
            }
            ExpressionTree argument = node.getArguments().get(i);
            if (!this.translateQueue.isEmpty() && this.translateQueue.getLast().containsKey(argument)) {
                argument = (ExpressionTree)this.translateQueue.getLast().get(argument);
            }
            if (LITERALS.contains((Object)argument.getKind()) && this.changedParamters.contains(element)) {
                Tree arraytype = this.make.Type(element.asType());
                String varName = element.getSimpleName().toString();
                String uniqueName = JavaPluginUtils.makeNameUnique((CompilationInfo)this.workingCopy, this.workingCopy.getTrees().getScope(methodInvocationPath), varName, this.definedIds);
                if (uniqueName == null ? varName != null : !uniqueName.equals(varName)) {
                    renames.add(Pair.of((Object)element, (Object)uniqueName));
                    this.definedIds.add(uniqueName);
                } else {
                    this.definedIds.add(varName);
                }
                newVars.add(this.make.Variable(this.make.Modifiers(element.getModifiers()), (CharSequence)((uniqueName == null ? varName != null : !uniqueName.equals(varName)) ? uniqueName : varName), arraytype, argument));
                continue;
            }
            Pair pair = Pair.of((Object)element, (Object)argument);
            idScan.scan((Tree)body, (Object)pair);
        }
        ErrorAwareTreeScanner<Void, Pair<Element, String>> renameScan = new ErrorAwareTreeScanner<Void, Pair<Element, String>>(){

            public Void visitIdentifier(IdentifierTree node, Pair<Element, String> p) {
                TreePath path = InlineMethodTransformer.this.trees.getPath(compilationUnitTree, node);
                Element el = null;
                if (path != null) {
                    el = InlineMethodTransformer.this.trees.getElement(path);
                }
                if (((Element)p.first()).equals(el)) {
                    original2TranslatedBody.put(node, InlineMethodTransformer.this.make.setLabel((Tree)node, (CharSequence)p.second()));
                }
                return (Void)super.visitIdentifier(node, p);
            }
        };
        for (Pair pair : renames) {
            renameScan.scan((Tree)body, (Object)pair);
        }
    }

    private Tree translateLastStatement(GeneratorUtilities genUtils, Tree parent, Tree grandparent, List<StatementTree> newStatementList, Tree lastStatement, Tree node, TreePath location, Element method, Map<Tree, Tree> translateMap) {
        Tree result = lastStatement;
        TreeDuplicator duplicator = new TreeDuplicator(this.make, genUtils);
        if (parent.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            if (result != null) {
                boolean needsParentheses;
                switch (result.getKind()) {
                    case EXPRESSION_STATEMENT: {
                        result = ((ExpressionStatementTree)result).getExpression();
                        break;
                    }
                    case RETURN: {
                        result = ((ReturnTree)result).getExpression();
                        break;
                    }
                }
                if (result instanceof ExpressionTree && (needsParentheses = OperatorPrecedence.needsParentheses(location, method, (ExpressionTree)result, this.workingCopy))) {
                    result = this.workingCopy.getTreeMaker().Parenthesized((ExpressionTree)result);
                }
            }
        } else {
            if (result != null && result.getKind() == Tree.Kind.RETURN) {
                ExpressionTree returnExpression = ((ReturnTree)result).getExpression();
                switch (returnExpression.getKind()) {
                    case ASSIGNMENT: 
                    case PREFIX_INCREMENT: 
                    case PREFIX_DECREMENT: 
                    case POSTFIX_DECREMENT: 
                    case POSTFIX_INCREMENT: 
                    case METHOD_INVOCATION: 
                    case NEW_CLASS: 
                    case NEW_ARRAY: {
                        result = this.make.ExpressionStatement(returnExpression);
                        break;
                    }
                    default: {
                        result = this.make.EmptyStatement();
                        SourcePositions positions = this.workingCopy.getTrees().getSourcePositions();
                        long startPosition = positions.getStartPosition(this.workingCopy.getCompilationUnit(), node);
                        long lineNumber = this.workingCopy.getCompilationUnit().getLineMap().getLineNumber(startPosition);
                        String source = FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject()) + ':' + lineNumber;
                        this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, Bundle.WRN_InlineChangeReturn(source)));
                    }
                }
            }
            switch (grandparent.getKind()) {
                case FOR_LOOP: {
                    StatementTree statement;
                    Tree newTree;
                    ForLoopTree forLoopTree = (ForLoopTree)grandparent;
                    if (translateMap.containsKey(grandparent) && (newTree = translateMap.get(grandparent)).getKind() == Tree.Kind.FOR_LOOP) {
                        forLoopTree = (ForLoopTree)newTree;
                    }
                    if ((statement = forLoopTree.getStatement()) == parent) {
                        this.addResultToStatementList(result, newStatementList);
                        statement = this.make.Block(newStatementList, false);
                        newStatementList.clear();
                    }
                    List<? extends ExpressionStatementTree> updates = forLoopTree.getUpdate();
                    LinkedList<ExpressionStatementTree> newUpdates = new LinkedList<ExpressionStatementTree>();
                    for (ExpressionStatementTree expressionStatementTree : updates) {
                        if (expressionStatementTree == parent) {
                            this.addResultToStatementList(result, newStatementList);
                            for (StatementTree statementTree : newStatementList) {
                                if (statementTree.getKind() != Tree.Kind.EXPRESSION_STATEMENT) break;
                                newUpdates.add((ExpressionStatementTree)statementTree);
                            }
                            newStatementList.clear();
                            continue;
                        }
                        newUpdates.add(expressionStatementTree);
                    }
                    List<? extends StatementTree> initializers = forLoopTree.getInitializer();
                    LinkedList<StatementTree> linkedList = new LinkedList<StatementTree>();
                    for (StatementTree statementTree : initializers) {
                        if (statementTree == parent) {
                            this.addResultToStatementList(result, newStatementList);
                            for (StatementTree statementTree1 : newStatementList) {
                                if (statementTree1.getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
                                    linkedList.add((ExpressionStatementTree)statementTree1);
                                    continue;
                                }
                                if (statementTree1.getKind() != Tree.Kind.VARIABLE) break;
                                linkedList.add((VariableTree)statementTree1);
                            }
                            newStatementList.clear();
                            continue;
                        }
                        linkedList.add(statementTree);
                    }
                    result = this.make.ForLoop(linkedList, forLoopTree.getCondition(), newUpdates, statement);
                    break;
                }
                case ENHANCED_FOR_LOOP: {
                    EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)grandparent;
                    StatementTree statement = enhancedForLoopTree.getStatement();
                    if (statement == parent) {
                        this.addResultToStatementList(result, newStatementList);
                        statement = this.make.Block(newStatementList, false);
                        newStatementList.clear();
                    }
                    result = this.make.EnhancedForLoop(enhancedForLoopTree.getVariable(), enhancedForLoopTree.getExpression(), statement);
                    break;
                }
                case WHILE_LOOP: {
                    WhileLoopTree whileLoopTree = (WhileLoopTree)grandparent;
                    StatementTree statement = whileLoopTree.getStatement();
                    if (statement == parent) {
                        this.addResultToStatementList(result, newStatementList);
                        statement = this.make.Block(newStatementList, false);
                        newStatementList.clear();
                    }
                    result = this.make.WhileLoop(whileLoopTree.getCondition(), statement);
                    break;
                }
                case DO_WHILE_LOOP: {
                    DoWhileLoopTree doWhileLoopTree = (DoWhileLoopTree)grandparent;
                    StatementTree statement = doWhileLoopTree.getStatement();
                    if (statement == parent) {
                        this.addResultToStatementList(result, newStatementList);
                        statement = this.make.Block(newStatementList, false);
                        newStatementList.clear();
                    }
                    result = this.make.DoWhileLoop(doWhileLoopTree.getCondition(), statement);
                    break;
                }
                case IF: {
                    StatementTree elseStatement;
                    IfTree ifTree = (IfTree)grandparent;
                    StatementTree thenStatement = ifTree.getThenStatement();
                    if (thenStatement == parent) {
                        this.addResultToStatementList(result, newStatementList);
                        thenStatement = this.make.Block(newStatementList, false);
                        newStatementList.clear();
                    }
                    if ((elseStatement = ifTree.getElseStatement()) == parent) {
                        this.addResultToStatementList(result, newStatementList);
                        elseStatement = this.make.Block(newStatementList, false);
                        newStatementList.clear();
                    }
                    result = this.make.If(ifTree.getCondition(), thenStatement, elseStatement);
                }
            }
        }
        if (result != null) {
            result = duplicator.duplicate(result);
            genUtils.copyComments(lastStatement, result, true);
            genUtils.copyComments(lastStatement, result, false);
        }
        return result;
    }

    private void addResultToStatementList(Tree result, List<StatementTree> newStatementList) {
        if (result != null) {
            newStatementList.add((StatementTree)result);
        }
    }
}

