/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public class MockServices {
    private static final Logger LOG = Logger.getLogger(MockServices.class.getName());

    private MockServices() {
    }

    public static void setServices(Class<?> ... services) throws IllegalArgumentException {
        int x;
        try {
            if (System.getProperty("netbeans.home") != null && System.getProperty("netbeans.user") != null) {
                Class<?> mainLookup = MockServices.forName("org.netbeans.core.startup.MainLookup");
                ServiceClassLoader l = new ServiceClassLoader(services, Thread.currentThread().getContextClassLoader(), false);
                Method sClsLoaderChanged = mainLookup.getDeclaredMethod("systemClassLoaderChanged", ClassLoader.class);
                sClsLoaderChanged.setAccessible(true);
                sClsLoaderChanged.invoke(null, l);
                return;
            }
        }
        catch (ClassNotFoundException mainLookup) {
        }
        catch (Exception exc) {
            LOG.log(Level.WARNING, "MainLookup couldn't be notified about the context class loader change", exc);
        }
        ServiceClassLoader l = new ServiceClassLoader(services);
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        while (g.getParent() != null) {
            g = g.getParent();
        }
        while (true) {
            int s;
            Thread[] ts;
            if ((x = g.enumerate(ts = new Thread[s = g.activeCount() + 1], true)) < s) {
                for (int i = 0; i < x; ++i) {
                    ts[i].setContextClassLoader(l);
                }
                break;
            }
            LOG.fine("Race condition getting all threads, restarting...");
        }
        LOG.log(Level.FINE, "Set context class loader on {0} threads", x);
        try {
            Class<?> mainLookup = Class.forName("org.netbeans.core.startup.MainLookup");
            Method sClsLoaderChanged = mainLookup.getDeclaredMethod("systemClassLoaderChanged", ClassLoader.class);
            sClsLoaderChanged.setAccessible(true);
            sClsLoaderChanged.invoke(null, l);
        }
        catch (ClassNotFoundException mainLookup) {
        }
        catch (Exception exc) {
            LOG.log(Level.WARNING, "MainLookup couldn't be notified about the context class loader change", exc);
        }
        try {
            Class<?> lookup = Class.forName("org.openide.util.Lookup");
            Method defaultLookup = lookup.getDeclaredMethod("resetDefaultLookup", new Class[0]);
            defaultLookup.setAccessible(true);
            defaultLookup.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException lookup) {
        }
        catch (Exception x2) {
            LOG.log(Level.WARNING, "Could not reset Lookup.getDefault()", x2);
        }
    }

    private static Class<?> forName(String name) throws ClassNotFoundException {
        ClassLoader l = Thread.currentThread().getContextClassLoader();
        if (l != null) {
            try {
                return Class.forName(name, true, l);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(name);
    }

    private static final class ServiceClassLoader
    extends ClassLoader {
        private final Class<?>[] services;

        public ServiceClassLoader(Class<?>[] services) {
            this(services, MockServices.class.getClassLoader(), true);
        }

        public ServiceClassLoader(Class<?>[] services, ClassLoader l, boolean test) {
            super(l);
            for (Class<?> c : services) {
                try {
                    int mods;
                    if (test) {
                        Assert.assertEquals(c, this.getParent().loadClass(c.getName()));
                    }
                    if (!Modifier.isPublic(mods = c.getModifiers()) || Modifier.isAbstract(mods)) {
                        throw new IllegalArgumentException("Class " + c.getName() + " must be public");
                    }
                    c.getConstructor(new Class[0]);
                }
                catch (IllegalArgumentException x) {
                    throw x;
                }
                catch (NoSuchMethodException x) {
                    throw (IllegalArgumentException)new IllegalArgumentException("Class " + c.getName() + " has no public no-arg constructor").initCause(x);
                }
                catch (Exception x) {
                    throw (AssertionFailedError)new AssertionFailedError(x.toString()).initCause((Throwable)x);
                }
            }
            this.services = services;
        }

        @Override
        public URL getResource(String name) {
            Enumeration<URL> r;
            try {
                r = this.getResources(name);
            }
            catch (IOException x) {
                return null;
            }
            return r.hasMoreElements() ? r.nextElement() : null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (name.equals("META-INF/services/org.openide.util.Lookup") || name.equals("META-INF/services/org.openide.util.Lookup$Provider")) {
                return Collections.enumeration(Collections.emptySet());
            }
            final Enumeration<URL> supe = super.getResources(name);
            String prefix = "META-INF/services/";
            if (name.startsWith(prefix)) {
                try {
                    Class<?> xface = this.loadClass(name.substring(prefix.length()));
                    ArrayList<String> impls = new ArrayList<String>();
                    for (Class<?> c : this.services) {
                        boolean assignable = xface.isAssignableFrom(c);
                        if (!assignable) continue;
                        impls.add(c.getName());
                    }
                    if (!impls.isEmpty()) {
                        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
                        for (String impl : impls) {
                            pw.println(impl);
                            pw.println("#position=100");
                        }
                        pw.close();
                        final URL u = new URL("metainfservices", null, 0, xface.getName(), new URLStreamHandler(){

                            @Override
                            protected URLConnection openConnection(URL _u) throws IOException {
                                return new URLConnection(_u){

                                    @Override
                                    public void connect() throws IOException {
                                    }

                                    @Override
                                    public InputStream getInputStream() throws IOException {
                                        return new ByteArrayInputStream(baos.toByteArray());
                                    }
                                };
                            }
                        });
                        return new Enumeration<URL>(){
                            private boolean parent = false;

                            @Override
                            public boolean hasMoreElements() {
                                return !this.parent || supe.hasMoreElements();
                            }

                            @Override
                            public URL nextElement() throws NoSuchElementException {
                                if (this.parent) {
                                    return (URL)supe.nextElement();
                                }
                                this.parent = true;
                                return u;
                            }
                        };
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return supe;
        }
    }
}

