/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.ClassVariable;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorVisitor;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InterfaceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.ClassFieldVariable;
import org.netbeans.modules.debugger.jpda.models.ClassVariableImpl;
import org.netbeans.modules.debugger.jpda.models.FieldVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ObjectFieldVariable;
import org.netbeans.modules.debugger.jpda.models.SuperVariable;

public class JPDAClassTypeImpl
implements JPDAClassType {
    private static final Logger loggerValue = Logger.getLogger("org.netbeans.modules.debugger.jpda.getValue");
    private final JPDADebuggerImpl debugger;
    private final ReferenceType classType;

    public JPDAClassTypeImpl(JPDADebuggerImpl debugger, ReferenceType classType) {
        this.debugger = debugger;
        this.classType = classType;
    }

    protected final JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    public ReferenceType getType() {
        return this.classType;
    }

    public String getName() {
        return this.classType.name();
    }

    public String getSourceName() throws AbsentInformationException {
        return this.classType.sourceName();
    }

    public ClassVariable classObject() {
        ClassObjectReference co;
        try {
            co = ReferenceTypeWrapper.classObject(this.classType);
        }
        catch (InternalExceptionWrapper | ObjectCollectedExceptionWrapper | UnsupportedOperationExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            co = null;
        }
        return new ClassVariableImpl(this.debugger, co, "");
    }

    public ObjectVariable getClassLoader() {
        ClassLoaderReference cl;
        try {
            cl = ReferenceTypeWrapper.classLoader(this.classType);
        }
        catch (InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            cl = null;
        }
        return new AbstractObjectVariable(this.debugger, cl, "Loader " + this.getName());
    }

    public Super getSuperClass() {
        if (this.classType instanceof ClassType) {
            try {
                ClassType superClass = ClassTypeWrapper.superclass((ClassType)this.classType);
                if (superClass == null) {
                    return null;
                }
                return new SuperVariable(this.debugger, null, superClass, this.getName());
            }
            catch (InternalExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
                return null;
            }
        }
        return null;
    }

    public List<JPDAClassType> getSubClasses() {
        if (this.classType instanceof ClassType) {
            List<ClassType> subclasses = ClassTypeWrapper.subclasses0((ClassType)this.classType);
            return this.getTypes(subclasses);
        }
        if (this.classType instanceof InterfaceType) {
            List<InterfaceType> subinterfaces = InterfaceTypeWrapper.subinterfaces0((InterfaceType)this.classType);
            List<ClassType> implementors = InterfaceTypeWrapper.implementors0((InterfaceType)this.classType);
            int ss = subinterfaces.size();
            int is = implementors.size();
            if (ss > 0 || is > 0) {
                ArrayList<JPDAClassType> subClasses = new ArrayList<JPDAClassType>(ss + is);
                for (InterfaceType interfaceType : subinterfaces) {
                    subClasses.add(this.debugger.getClassType(interfaceType));
                }
                for (ClassType classType : implementors) {
                    subClasses.add(this.debugger.getClassType(classType));
                }
                return Collections.unmodifiableList(subClasses);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public List<JPDAClassType> getAllInterfaces() {
        if (this.classType instanceof ClassType) {
            try {
                List<InterfaceType> allInterfaces = ClassTypeWrapper.allInterfaces0((ClassType)this.classType);
                return this.getTypes(allInterfaces);
            }
            catch (ClassNotPreparedExceptionWrapper allInterfaces) {}
        } else if (this.classType instanceof InterfaceType) {
            try {
                ArrayList<InterfaceType> allInterfaces = new ArrayList<InterfaceType>();
                ArrayList<InterfaceType> processedInterfaces = new ArrayList<InterfaceType>();
                List<InterfaceType> directInterfaces = InterfaceTypeWrapper.superinterfaces0((InterfaceType)this.classType);
                allInterfaces.addAll(directInterfaces);
                while (processedInterfaces.size() < allInterfaces.size()) {
                    InterfaceType it = (InterfaceType)allInterfaces.get(processedInterfaces.size());
                    directInterfaces = InterfaceTypeWrapper.superinterfaces0(it);
                    for (InterfaceType di : directInterfaces) {
                        if (allInterfaces.contains(di)) continue;
                        allInterfaces.add(di);
                    }
                    processedInterfaces.add(it);
                }
                return this.getTypes(allInterfaces);
            }
            catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
                // empty catch block
            }
        }
        return Collections.EMPTY_LIST;
    }

    public List<JPDAClassType> getDirectInterfaces() {
        if (this.classType instanceof ClassType) {
            try {
                List<InterfaceType> directInterfaces = ClassTypeWrapper.interfaces0((ClassType)this.classType);
                return this.getTypes(directInterfaces);
            }
            catch (ClassNotPreparedExceptionWrapper directInterfaces) {}
        } else if (this.classType instanceof InterfaceType) {
            try {
                List<InterfaceType> directInterfaces = InterfaceTypeWrapper.superinterfaces0((InterfaceType)this.classType);
                return this.getTypes(directInterfaces);
            }
            catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
                // empty catch block
            }
        }
        return Collections.EMPTY_LIST;
    }

    private List<JPDAClassType> getTypes(Collection<? extends ReferenceType> types) {
        if (types.size() > 0) {
            types = new LinkedHashSet<ReferenceType>(types);
            ArrayList<JPDAClassType> interfaces = new ArrayList<JPDAClassType>(types.size());
            for (ReferenceType referenceType : types) {
                interfaces.add(this.debugger.getClassType(referenceType));
            }
            return Collections.unmodifiableList(interfaces);
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isInstanceOf(String className) {
        List<ReferenceType> classTypes;
        try {
            classTypes = VirtualMachineWrapper.classesByName(MirrorWrapper.virtualMachine(this.classType), className);
        }
        catch (InternalExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            return false;
        }
        for (ReferenceType rt : classTypes) {
            try {
                if (!EvaluatorVisitor.instanceOf(this.classType, rt)) continue;
                return true;
            }
            catch (VMDisconnectedException vmdex) {
                return false;
            }
            catch (InternalException internalException) {
            }
        }
        return false;
    }

    public List<org.netbeans.api.debugger.jpda.Field> staticFields() {
        List<Field> allFieldsOrig;
        try {
            allFieldsOrig = ReferenceTypeWrapper.allFields0(this.classType);
        }
        catch (ClassNotPreparedExceptionWrapper ex) {
            return Collections.emptyList();
        }
        ArrayList<org.netbeans.api.debugger.jpda.Field> staticFields = new ArrayList<org.netbeans.api.debugger.jpda.Field>();
        String parentID = this.getName();
        for (int i = 0; i < allFieldsOrig.size(); ++i) {
            Object value = null;
            Field origField = allFieldsOrig.get(i);
            try {
                if (!TypeComponentWrapper.isStatic(origField)) continue;
                if (origField.signature().length() == 1) {
                    staticFields.add(new FieldVariable(this.debugger, origField, parentID, null));
                    continue;
                }
                ObjectFieldVariable ofv = TypeComponentWrapper.declaringType(origField) instanceof ClassType ? new ClassFieldVariable(this.debugger, origField, parentID, JPDADebuggerImpl.getGenericSignature(origField), null) : new ObjectFieldVariable(this.debugger, origField, parentID, JPDADebuggerImpl.getGenericSignature(origField), null);
                staticFields.add(ofv);
                continue;
            }
            catch (InternalExceptionWrapper ofv) {
                continue;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return Collections.emptyList();
            }
        }
        return staticFields;
    }

    public Variable invokeMethod(String methodName, String signature, Variable[] arguments) throws NoSuchMethodException, InvalidExpressionException {
        return this.invokeMethod(null, methodName, signature, arguments);
    }

    public Variable invokeMethod(JPDAThread thread, String methodName, String signature, Variable[] arguments) throws NoSuchMethodException, InvalidExpressionException {
        try {
            int j;
            int jj;
            List<Method> l;
            if (!(this.classType instanceof ClassType)) {
                throw new NoSuchMethodException(this.classType + " is not ClassType");
            }
            ClassType ct = (ClassType)this.classType;
            Method method = null;
            if (signature != null) {
                method = ClassTypeWrapper.concreteMethodByName(ct, methodName, signature);
            } else {
                l = ReferenceTypeWrapper.methodsByName(ct, methodName);
                jj = l.size();
                for (j = 0; j < jj; ++j) {
                    if (MethodWrapper.isAbstract(l.get(j)) || !MethodWrapper.argumentTypeNames(l.get(j)).isEmpty()) continue;
                    method = l.get(j);
                    break;
                }
            }
            if (method == null) {
                l = ReferenceTypeWrapper.methodsByName(ct, methodName);
                jj = l.size();
                loggerValue.log(Level.INFO, "No method {0}.{1} with signature {2}", new Object[]{TypeWrapper.name(ct), methodName, signature});
                loggerValue.info("Found following methods with signatures:");
                for (j = 0; j < jj; ++j) {
                    loggerValue.info(TypeComponentWrapper.signature(l.get(j)));
                }
                throw new NoSuchMethodException(TypeWrapper.name(ct) + "." + methodName + " : " + signature);
            }
            Value[] vs = new Value[arguments.length];
            int k = arguments.length;
            for (int i = 0; i < k; ++i) {
                vs[i] = arguments[i] == null ? null : ((AbstractVariable)arguments[i]).getInnerValue();
            }
            Value v = this.getDebugger().invokeMethod((JPDAThreadImpl)thread, ct, method, vs);
            if (v instanceof ObjectReference) {
                return new AbstractObjectVariable(this.getDebugger(), (ObjectReference)v, this.getName() + method + "^");
            }
            return new AbstractVariable(this.getDebugger(), v, this.getName() + method);
        }
        catch (ClassNotPreparedExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            return null;
        }
    }

    public long getInstanceCount() {
        try {
            long[] counts = VirtualMachineWrapper.instanceCounts(MirrorWrapper.virtualMachine(this.classType), Collections.singletonList(this.classType));
            return counts[0];
        }
        catch (InternalExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            return 0L;
        }
    }

    public List<ObjectVariable> getInstances(long maxInstances) {
        List<ObjectReference> instances;
        try {
            instances = ReferenceTypeWrapper.instances(this.classType, maxInstances);
        }
        catch (InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            return Collections.emptyList();
        }
        return new AbstractList<ObjectVariable>(){

            @Override
            public ObjectVariable get(int i) {
                ObjectReference obj = (ObjectReference)instances.get(i);
                return new AbstractObjectVariable(JPDAClassTypeImpl.this.debugger, obj, JPDAClassTypeImpl.this.classType.name() + " instance " + i);
            }

            @Override
            public int size() {
                return instances.size();
            }
        };
    }

    public boolean equals(Object o) {
        if (!(o instanceof JPDAClassTypeImpl)) {
            return false;
        }
        return this.classType.equals(((JPDAClassTypeImpl)o).classType);
    }

    public int hashCode() {
        return this.classType.hashCode() + 1000;
    }
}

