/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot;

import ch.qos.logback.classic.Level;
import java.util.ArrayList;
import java.util.List;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.Netshot;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.credentials.DeviceCliAccount;
import onl.netfishers.netshot.device.credentials.DeviceCredentialSet;
import onl.netfishers.netshot.device.credentials.DeviceSnmpCommunity;
import onl.netfishers.netshot.device.credentials.DeviceSshAccount;
import onl.netfishers.netshot.device.credentials.DeviceTelnetAccount;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class DeviceListExtractor
extends Netshot {
    private static Logger logger = LoggerFactory.getLogger(DeviceListExtractor.class);

    protected static boolean initLogging() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        System.setProperty("org.jboss.logging.provider", "slf4j");
        rootLogger.setLevel(Level.WARN);
        return true;
    }

    public static void main(String[] args) {
        System.out.println("Netshot Device List Extractor -- extracts and formats device data.");
        System.out.println(String.format("Based on Netshot version %s.", "0.11.0"));
        logger.info("Starting now.");
        if (!Netshot.initConfig()) {
            System.exit(1);
        }
        if (!DeviceListExtractor.initLogging()) {
            System.exit(1);
        }
        StringBuffer output = new StringBuffer();
        try {
            logger.info("Initializing access to the database.");
            Database.init();
            logger.info("Requesting data from the DB...");
            Session session = Database.getSession();
            List devices = session.createQuery("select d from Device d where d.status = :enabled").setParameter("enabled", (Object)Device.Status.INPRODUCTION).list();
            for (Device device : devices) {
                DeviceCliAccount cliAccount = null;
                DeviceSnmpCommunity community = null;
                for (DeviceCredentialSet credentialSet : device.getCredentialSets()) {
                    if (credentialSet instanceof DeviceSshAccount) {
                        cliAccount = (DeviceSshAccount)credentialSet;
                        continue;
                    }
                    if (cliAccount == null && credentialSet instanceof DeviceTelnetAccount) {
                        cliAccount = (DeviceTelnetAccount)credentialSet;
                        continue;
                    }
                    if (!(credentialSet instanceof DeviceSnmpCommunity)) continue;
                    community = (DeviceSnmpCommunity)credentialSet;
                }
                if (cliAccount == null) {
                    logger.warn(String.format("No CLI account found for device %s.", device.getName()));
                }
                if (community == null) {
                    logger.warn(String.format("No SNMP community found for device %s.", device.getName()));
                }
                ArrayList<String> fields = new ArrayList<String>();
                fields.add(device.getMgmtAddress().getInetAddress().getHostAddress());
                fields.add(device.getName());
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add(community == null ? "" : community.getCommunity());
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add(cliAccount == null ? "" : cliAccount.getUsername());
                fields.add(cliAccount == null ? "" : cliAccount.getPassword());
                fields.add(cliAccount == null ? "" : cliAccount.getSuperPassword());
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                fields.add("");
                output.append(String.join((CharSequence)";", fields));
                output.append("\n");
            }
            System.out.println(output);
        }
        catch (Exception e) {
            System.err.println("NETSHOT FATAL ERROR: " + e.getMessage());
            System.exit(1);
        }
    }
}

