/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec2(10ul, 12ul) / 3ul) => u64vec2(3ul, 4ul)
 * (u64vec2(10ul, 12ul) / 1192ul) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) / 1048576ul) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) / 4251475ul) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) / 29852643761ul) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) / 4398046511104ul) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) / 3948976685146ul) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) / 135763469567146206ul) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) / 11654173250180970009ul) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) / 3ul) => u64vec2(14ul, 16ul)
 * (u64vec2(42ul, 48ul) / 1192ul) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) / 1048576ul) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) / 4251475ul) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) / 29852643761ul) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) / 4398046511104ul) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) / 3948976685146ul) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) / 135763469567146206ul) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) / 11654173250180970009ul) => u64vec2(0ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec2(10ul, 12ul) / 3ul), u64vec2(3ul, 4ul))) ? 1 : -1] array0;
  float[all(equal((u64vec2(10ul, 12ul) / 1192ul), u64vec2(0ul, 0ul))) ? 1 : -1] array1;
  float[all(equal((u64vec2(10ul, 12ul) / 1048576ul), u64vec2(0ul, 0ul))) ? 1 : -1] array2;
  float[all(equal((u64vec2(10ul, 12ul) / 4251475ul), u64vec2(0ul, 0ul))) ? 1 : -1] array3;
  float[all(equal((u64vec2(10ul, 12ul) / 29852643761ul), u64vec2(0ul, 0ul))) ? 1 : -1] array4;
  float[all(equal((u64vec2(10ul, 12ul) / 4398046511104ul), u64vec2(0ul, 0ul))) ? 1 : -1] array5;
  float[all(equal((u64vec2(10ul, 12ul) / 3948976685146ul), u64vec2(0ul, 0ul))) ? 1 : -1] array6;
  float[all(equal((u64vec2(10ul, 12ul) / 135763469567146206ul), u64vec2(0ul, 0ul))) ? 1 : -1] array7;
  float[all(equal((u64vec2(10ul, 12ul) / 11654173250180970009ul), u64vec2(0ul, 0ul))) ? 1 : -1] array8;
  float[all(equal((u64vec2(42ul, 48ul) / 3ul), u64vec2(14ul, 16ul))) ? 1 : -1] array9;
  float[all(equal((u64vec2(42ul, 48ul) / 1192ul), u64vec2(0ul, 0ul))) ? 1 : -1] array10;
  float[all(equal((u64vec2(42ul, 48ul) / 1048576ul), u64vec2(0ul, 0ul))) ? 1 : -1] array11;
  float[all(equal((u64vec2(42ul, 48ul) / 4251475ul), u64vec2(0ul, 0ul))) ? 1 : -1] array12;
  float[all(equal((u64vec2(42ul, 48ul) / 29852643761ul), u64vec2(0ul, 0ul))) ? 1 : -1] array13;
  float[all(equal((u64vec2(42ul, 48ul) / 4398046511104ul), u64vec2(0ul, 0ul))) ? 1 : -1] array14;
  float[all(equal((u64vec2(42ul, 48ul) / 3948976685146ul), u64vec2(0ul, 0ul))) ? 1 : -1] array15;
  float[all(equal((u64vec2(42ul, 48ul) / 135763469567146206ul), u64vec2(0ul, 0ul))) ? 1 : -1] array16;
  float[all(equal((u64vec2(42ul, 48ul) / 11654173250180970009ul), u64vec2(0ul, 0ul))) ? 1 : -1] array17;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
