/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * lessThan(uvec4(0u, 0u, 0u, 0u), uvec4(0u, 1u, 2u, 5u)) => bvec4(false, true, true, true)
 * lessThan(uvec4(0u, 1u, 1u, 1u), uvec4(34u, 0u, 1u, 2u)) => bvec4(true, false, false, true)
 * lessThan(uvec4(1u, 1u, 2u, 2u), uvec4(5u, 34u, 0u, 1u)) => bvec4(true, true, false, false)
 * lessThan(uvec4(2u, 2u, 2u, 5u), uvec4(2u, 5u, 34u, 0u)) => bvec4(false, true, true, false)
 * lessThan(uvec4(5u, 5u, 5u, 5u), uvec4(1u, 2u, 5u, 34u)) => bvec4(false, false, false, true)
 * lessThan(uvec4(34u, 34u, 34u, 34u), uvec4(0u, 1u, 2u, 5u)) => bvec4(false, false, false, false)
 * lessThan(uvec4(34u, 0u, 0u, 0u), uvec4(34u, 0u, 1u, 2u)) => bvec4(false, false, true, true)
 */
#version 130

void main()
{
  float[all(equal(lessThan(uvec4(0u, 0u, 0u, 0u), uvec4(0u, 1u, 2u, 5u)), bvec4(false, true, true, true))) ? 1 : -1] array0;
  float[all(equal(lessThan(uvec4(0u, 1u, 1u, 1u), uvec4(34u, 0u, 1u, 2u)), bvec4(true, false, false, true))) ? 1 : -1] array1;
  float[all(equal(lessThan(uvec4(1u, 1u, 2u, 2u), uvec4(5u, 34u, 0u, 1u)), bvec4(true, true, false, false))) ? 1 : -1] array2;
  float[all(equal(lessThan(uvec4(2u, 2u, 2u, 5u), uvec4(2u, 5u, 34u, 0u)), bvec4(false, true, true, false))) ? 1 : -1] array3;
  float[all(equal(lessThan(uvec4(5u, 5u, 5u, 5u), uvec4(1u, 2u, 5u, 34u)), bvec4(false, false, false, true))) ? 1 : -1] array4;
  float[all(equal(lessThan(uvec4(34u, 34u, 34u, 34u), uvec4(0u, 1u, 2u, 5u)), bvec4(false, false, false, false))) ? 1 : -1] array5;
  float[all(equal(lessThan(uvec4(34u, 0u, 0u, 0u), uvec4(34u, 0u, 1u, 2u)), bvec4(false, false, true, true))) ? 1 : -1] array6;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length());
}
