/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StringLiteralExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertVariadicParamIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.convert.variadic.param", new Object[0]);
        if (string == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.convert.variadic.param", new Object[0]);
        if (string == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (function != null) {
            if (LanguageLevel.forElement(function).isPython2() && function.getParameterList().hasPositionalContainer()) {
                return false;
            }
            boolean caretInParameterList = PsiTreeUtil.isAncestor((PsiElement)function.getParameterList(), (PsiElement)element, (boolean)true);
            Trinity<List<PyReferenceExpression>, List<PyCallExpression>, List<PySubscriptionExpression>> usages = ConvertVariadicParamIntention.findKeywordContainerUsages(function);
            HashSet references = new HashSet((Collection)usages.getFirst());
            boolean available = false;
            for (PyCallExpression call : (List)usages.getSecond()) {
                if ((caretInParameterList || PsiTreeUtil.isAncestor((PsiElement)call, (PsiElement)element, (boolean)true)) && ConvertVariadicParamIntention.getIndexValueToReplace(call) != null) {
                    available = true;
                }
                references.remove(call.getReceiver(null));
            }
            for (PySubscriptionExpression subscription : (List)usages.getThird()) {
                if ((caretInParameterList || PsiTreeUtil.isAncestor((PsiElement)subscription, (PsiElement)element, (boolean)true)) && ConvertVariadicParamIntention.getIndexValueToReplace(subscription) != null) {
                    available = true;
                }
                references.remove(subscription.getOperand());
            }
            return available && references.isEmpty();
        }
        return false;
    }

    @Nullable
    private static PyParameter getKeywordContainer(@NotNull PyParameterList parameterList) {
        if (parameterList == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(3);
        }
        return StreamEx.of((Object[])parameterList.getParameters()).select(PyNamedParameter.class).findFirst(PyNamedParameter::isKeywordContainer).orElse(null);
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement element;
        PyFunction function;
        if (project == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(4);
        }
        if ((function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(element = file.findElementAt(editor.getCaretModel().getOffset())), PyFunction.class)) != null) {
            ConvertVariadicParamIntention.replaceKeywordContainerSubscriptions(function, project);
            ConvertVariadicParamIntention.replaceKeywordContainerCalls(function, project);
        }
    }

    @NotNull
    private static Trinity<List<PyReferenceExpression>, List<PyCallExpression>, List<PySubscriptionExpression>> findKeywordContainerUsages(@NotNull PyFunction function) {
        PyParameter keywordContainer;
        if (function == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(5);
        }
        if ((keywordContainer = ConvertVariadicParamIntention.getKeywordContainer(function.getParameterList())) == null) {
            Trinity trinity = new Trinity(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            if (trinity == null) {
                ConvertVariadicParamIntention.$$$reportNull$$$0(6);
            }
            return trinity;
        }
        ArrayList all = new ArrayList();
        ArrayList calls = new ArrayList();
        ArrayList subscriptions = new ArrayList();
        SyntaxTraverser.psiTraverser((PsiElement)function.getStatementList()).forEach(e -> {
            if (e instanceof PyReferenceExpression && ((PyReferenceExpression)e).getReference().isReferenceTo((PsiElement)keywordContainer)) {
                all.add((PyReferenceExpression)e);
            } else if (ConvertVariadicParamIntention.isKeywordContainerCall(e, keywordContainer)) {
                calls.add((PyCallExpression)e);
            } else if (ConvertVariadicParamIntention.isKeywordContainerSubscription(e, keywordContainer)) {
                subscriptions.add((PySubscriptionExpression)e);
            }
        });
        Trinity trinity = new Trinity(all, calls, subscriptions);
        if (trinity == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(7);
        }
        return trinity;
    }

    @Nullable
    private static String getIndexValueToReplace(@NotNull PySubscriptionExpression subscription) {
        if (subscription == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(8);
        }
        return Optional.ofNullable(subscription.getIndexExpression()).map(indexExpression -> PyUtil.as(indexExpression, PyStringLiteralExpression.class)).map(StringLiteralExpression::getStringValue).filter(PyNames::isIdentifier).orElse(null);
    }

    @Nullable
    private static String getIndexValueToReplace(@NotNull PyCallExpression call) {
        if (call == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(9);
        }
        return Optional.of(call.getArguments()).map(ArrayUtil::getFirstElement).map(firstArgument -> PyUtil.as(firstArgument, PyStringLiteralExpression.class)).map(StringLiteralExpression::getStringValue).filter(PyNames::isIdentifier).orElse(null);
    }

    private static void replaceKeywordContainerSubscriptions(@NotNull PyFunction function, @NotNull Project project) {
        PyParameter keywordContainer;
        if (function == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(11);
        }
        if ((keywordContainer = ConvertVariadicParamIntention.getKeywordContainer(function.getParameterList())) == null) {
            return;
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)function.getStatementList()).filter(e -> ConvertVariadicParamIntention.isKeywordContainerSubscription(e, keywordContainer))).filter(PySubscriptionExpression.class).forEach(subscription -> {
            String indexValue;
            if (function == null) {
                ConvertVariadicParamIntention.$$$reportNull$$$0(24);
            }
            if ((indexValue = ConvertVariadicParamIntention.getIndexValueToReplace(subscription)) != null) {
                PyExpression parameter = elementGenerator.createExpressionFromText(LanguageLevel.forElement(function), indexValue);
                ConvertVariadicParamIntention.insertParameter(function.getParameterList(), parameter, false, elementGenerator);
                subscription.replace((PsiElement)parameter);
            }
        });
    }

    private static void replaceKeywordContainerCalls(@NotNull PyFunction function, @NotNull Project project) {
        PyParameter keywordContainer;
        if (function == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(12);
        }
        if (project == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(13);
        }
        if ((keywordContainer = ConvertVariadicParamIntention.getKeywordContainer(function.getParameterList())) == null) {
            return;
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)function.getStatementList()).filter(e -> ConvertVariadicParamIntention.isKeywordContainerCall(e, keywordContainer))).filter(PyCallExpression.class).forEach(call -> {
            PyNamedParameter parameter;
            String indexValue;
            if (function == null) {
                ConvertVariadicParamIntention.$$$reportNull$$$0(23);
            }
            if ((indexValue = ConvertVariadicParamIntention.getIndexValueToReplace(call)) != null && (parameter = ConvertVariadicParamIntention.createParameter(elementGenerator, call, indexValue)) != null) {
                PyExpression parameterUsage = elementGenerator.createExpressionFromText(LanguageLevel.forElement(function), indexValue);
                ConvertVariadicParamIntention.insertParameter(function.getParameterList(), parameter, parameter.hasDefaultValue(), elementGenerator);
                call.replace((PsiElement)parameterUsage);
            }
        });
    }

    private static boolean isKeywordContainerSubscription(@Nullable PsiElement element, @NotNull PyParameter keywordContainer) {
        PyExpression operand;
        if (keywordContainer == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(14);
        }
        if (element instanceof PySubscriptionExpression && (operand = ((PySubscriptionExpression)element).getOperand()) instanceof PyReferenceExpression) {
            return ((PyReferenceExpression)operand).getReference().isReferenceTo((PsiElement)keywordContainer);
        }
        return false;
    }

    private static boolean isKeywordContainerCall(@Nullable PsiElement element, @NotNull PyParameter keywordContainer) {
        PyQualifiedExpression qualifiedCallee;
        PyExpression qualifier;
        PyExpression callee;
        if (keywordContainer == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(15);
        }
        if (element instanceof PyCallExpression && (callee = ((PyCallExpression)element).getCallee()) instanceof PyQualifiedExpression && (qualifier = (qualifiedCallee = (PyQualifiedExpression)callee).getQualifier()) instanceof PyReferenceExpression) {
            return ((PyReferenceExpression)qualifier).getReference().isReferenceTo((PsiElement)keywordContainer) && ArrayUtil.contains((String)qualifiedCallee.getReferencedName(), (String[])new String[]{"get", "pop", "__getitem__"});
        }
        return false;
    }

    private static void insertParameter(@NotNull PyParameterList parameterList, @NotNull PyElement parameter, boolean hasDefaultValue, @NotNull PyElementGenerator elementGenerator) {
        if (parameterList == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(16);
        }
        if (parameter == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(17);
        }
        if (elementGenerator == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(18);
        }
        PyElement placeToInsertParameter = ConvertVariadicParamIntention.findCompatiblePlaceToInsertParameter(parameterList, hasDefaultValue);
        parameterList.addBefore((PsiElement)parameter, (PsiElement)placeToInsertParameter);
        parameterList.addBefore((PsiElement)elementGenerator.createComma(), (PsiElement)placeToInsertParameter);
    }

    @Nullable
    private static PyNamedParameter createParameter(@NotNull PyElementGenerator elementGenerator, @NotNull PyCallExpression call, @NotNull String parameterName) {
        PyExpression[] arguments;
        if (elementGenerator == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(19);
        }
        if (call == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(20);
        }
        if (parameterName == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(21);
        }
        if ((arguments = call.getArguments()).length > 1) {
            PyExpression argument = PyUtil.peelArgument(arguments[1]);
            return argument == null ? null : elementGenerator.createParameter(parameterName + "=" + argument.getText());
        }
        PyQualifiedExpression callee = PyUtil.as(call.getCallee(), PyQualifiedExpression.class);
        if (callee != null && "get".equals(callee.getReferencedName())) {
            return elementGenerator.createParameter(parameterName + "=" + "None");
        }
        return elementGenerator.createParameter(parameterName);
    }

    @Nullable
    private static PyElement findCompatiblePlaceToInsertParameter(@NotNull PyParameterList parameterList, boolean hasDefaultValue) {
        if (parameterList == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(22);
        }
        if (hasDefaultValue) {
            return ConvertVariadicParamIntention.getKeywordContainer(parameterList);
        }
        List<PyParameter> parameters2 = Arrays.asList(parameterList.getParameters());
        for (Pair currentAndNext : ContainerUtil.zip(parameters2, parameters2.subList(1, parameters2.size()))) {
            PyParameter current = (PyParameter)currentAndNext.getFirst();
            if (!(current instanceof PyNamedParameter) || !((PyNamedParameter)current).isPositionalContainer()) continue;
            return (PyElement)currentAndNext.getSecond();
        }
        return (PyElement)ContainerUtil.find((Object[])parameterList.getParameters(), p -> p.hasDefaultValue() || p instanceof PyNamedParameter && ((PyNamedParameter)p).isKeywordContainer());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/ConvertVariadicParamIntention";
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subscription";
                break;
            }
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordContainer";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementGenerator";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/ConvertVariadicParamIntention";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findKeywordContainerUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordContainer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findKeywordContainerUsages";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIndexValueToReplace";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceKeywordContainerSubscriptions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceKeywordContainerCalls";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isKeywordContainerSubscription";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isKeywordContainerCall";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "insertParameter";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findCompatiblePlaceToInsertParameter";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$replaceKeywordContainerCalls$6";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$replaceKeywordContainerSubscriptions$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

