/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.Maps;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PathMapper;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PydevConsoleWithFileRunnerImpl;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonRunConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PydevConsoleRunnerFactory
extends PythonConsoleRunnerFactory {
    protected ConsoleParameters createConsoleParameters(@NotNull Project project, @Nullable Module contextModule) {
        if (project == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(0);
        }
        Pair<Sdk, Module> sdkAndModule = PydevConsoleRunner.findPythonSdkAndModule(project, contextModule);
        Module module2 = (Module)sdkAndModule.second;
        Sdk sdk = (Sdk)sdkAndModule.first;
        PyConsoleOptions.PyConsoleSettings settingsProvider = PyConsoleOptions.getInstance(project).getPythonConsoleSettings();
        PyRemotePathMapper pathMapper = PydevConsoleRunner.getPathMapper(project, sdk, settingsProvider);
        String workingDir = PydevConsoleRunnerFactory.getWorkingDir(project, module2, (PathMapper)pathMapper, settingsProvider);
        String[] setupFragment = PydevConsoleRunnerFactory.createSetupFragment(module2, workingDir, (PathMapper)pathMapper, settingsProvider);
        HashMap envs = Maps.newHashMap(settingsProvider.getEnvs());
        PydevConsoleRunnerFactory.putIPythonEnvFlag(project, envs);
        Consumer rerunAction = title -> {
            PydevConsoleRunner runner;
            if (project == null) {
                PydevConsoleRunnerFactory.$$$reportNull$$$0(17);
            }
            if ((runner = this.createConsoleRunner(project, module2)) instanceof PydevConsoleRunnerImpl) {
                ((PydevConsoleRunnerImpl)runner).setConsoleTitle((String)title);
            }
            runner.run(true);
        };
        return new ConsoleParameters(project, sdk, workingDir, envs, PyConsoleType.PYTHON, settingsProvider, (Consumer<String>)rerunAction, setupFragment);
    }

    @Override
    @NotNull
    public PydevConsoleRunner createConsoleRunner(@NotNull Project project, @Nullable Module contextModule) {
        if (project == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(1);
        }
        ConsoleParameters consoleParameters = this.createConsoleParameters(project, contextModule);
        PydevConsoleRunner pydevConsoleRunner = this.createConsoleRunner(project, consoleParameters.mySdk, consoleParameters.myWorkingDir, consoleParameters.myEnvs, consoleParameters.myConsoleType, consoleParameters.mySettingsProvider, consoleParameters.myRerunAction, consoleParameters.mySetupFragment);
        if (pydevConsoleRunner == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(2);
        }
        return pydevConsoleRunner;
    }

    public static void putIPythonEnvFlag(@NotNull Project project, Map<String, String> envs) {
        if (project == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(3);
        }
        String ipythonEnabled = PyConsoleOptions.getInstance(project).isIpythonEnabled() ? "True" : "False";
        envs.put("IPYTHONENABLE", ipythonEnabled);
    }

    @Nullable
    public static String getWorkingDir(@NotNull Project project, @Nullable Module module2, @Nullable PathMapper pathMapper, PyConsoleOptions.PyConsoleSettings settingsProvider) {
        String workingDir;
        if (project == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)(workingDir = settingsProvider.getWorkingDirectory()))) {
            VirtualFile[] roots;
            if (module2 != null && ModuleRootManager.getInstance((Module)module2).getContentRoots().length > 0) {
                workingDir = ModuleRootManager.getInstance((Module)module2).getContentRoots()[0].getPath();
            } else if (ModuleManager.getInstance((Project)project).getModules().length > 0 && (roots = ModuleRootManager.getInstance((Module)ModuleManager.getInstance((Project)project).getModules()[0]).getContentRoots()).length > 0) {
                workingDir = roots[0].getPath();
            }
        }
        if (pathMapper != null && workingDir != null) {
            workingDir = pathMapper.convertToRemote(workingDir);
        }
        return workingDir;
    }

    public static String[] createSetupFragment(@Nullable Module module2, @Nullable String workingDir, @Nullable PathMapper pathMapper, PyConsoleOptions.PyConsoleSettings settingsProvider) {
        String[] setupFragment;
        String customStartScript = settingsProvider.getCustomStartScript();
        if (customStartScript.trim().length() > 0) {
            customStartScript = "\n" + customStartScript;
        }
        List pythonPath = PythonCommandLineState.collectPythonPath(module2, settingsProvider.shouldAddContentRoots(), settingsProvider.shouldAddSourceRoots());
        if (pathMapper != null) {
            pythonPath = pathMapper.convertToRemote(pythonPath);
        }
        String selfPathAppend = PydevConsoleRunner.constructPyPathAndWorkingDirCommand(pythonPath, workingDir, customStartScript);
        BuildoutFacet facet = null;
        if (module2 != null) {
            facet = BuildoutFacet.getInstance(module2);
        }
        if (facet != null) {
            List path = facet.getAdditionalPythonPath();
            if (pathMapper != null) {
                path = pathMapper.convertToRemote(path);
            }
            String prependStatement = facet.getPathPrependStatement(path);
            setupFragment = new String[]{prependStatement, selfPathAppend};
        } else {
            setupFragment = new String[]{selfPathAppend};
        }
        return setupFragment;
    }

    @NotNull
    protected PydevConsoleRunner createConsoleRunner(@NotNull Project project, @Nullable Sdk sdk, @Nullable String workingDir, @NotNull Map<String, String> envs, @NotNull PyConsoleType consoleType, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull Consumer<? super String> rerunAction, String ... setupFragment) {
        if (project == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(5);
        }
        if (envs == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(6);
        }
        if (consoleType == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(7);
        }
        if (settingsProvider == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(8);
        }
        if (rerunAction == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(9);
        }
        if (setupFragment == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(10);
        }
        PydevConsoleRunnerImpl pydevConsoleRunnerImpl = new PydevConsoleRunnerImpl(project, sdk, consoleType, workingDir, envs, settingsProvider, rerunAction, setupFragment);
        if (pydevConsoleRunnerImpl == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(11);
        }
        return pydevConsoleRunnerImpl;
    }

    @Override
    @NotNull
    public PydevConsoleRunner createConsoleRunnerWithFile(@NotNull Project project, @Nullable Module contextModule, final @Nullable String runFileText, @NotNull PythonRunConfiguration config) {
        if (project == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(12);
        }
        if (config == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(13);
        }
        ConsoleParameters consoleParameters = this.createConsoleParameters(project, contextModule);
        Consumer rerunAction = title -> {
            PydevConsoleRunner runner;
            if (project == null) {
                PydevConsoleRunnerFactory.$$$reportNull$$$0(15);
            }
            if (config == null) {
                PydevConsoleRunnerFactory.$$$reportNull$$$0(16);
            }
            if ((runner = this.createConsoleRunnerWithFile(project, contextModule, runFileText, config)) instanceof PydevConsoleRunnerImpl) {
                ((PydevConsoleRunnerImpl)runner).setConsoleTitle((String)title);
            }
            final PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance(project);
            runner.addConsoleListener(new PydevConsoleRunner.ConsoleListener(){

                @Override
                public void handleConsoleInitialized(@NotNull LanguageConsoleView consoleView) {
                    if (consoleView == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (consoleView instanceof PyCodeExecutor) {
                        ((PyCodeExecutor)consoleView).executeCode(runFileText, null);
                        if (toolWindow != null) {
                            toolWindow.getToolWindow().show(null);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/jetbrains/python/console/PydevConsoleRunnerFactory$1", "handleConsoleInitialized"));
                }
            });
            runner.run(true);
        };
        Sdk sdk = config.getSdk() != null ? config.getSdk() : consoleParameters.mySdk;
        String workingDir = config.getWorkingDirectory() != null ? config.getWorkingDirectory() : consoleParameters.myWorkingDir;
        PydevConsoleWithFileRunnerImpl pydevConsoleWithFileRunnerImpl = new PydevConsoleWithFileRunnerImpl(project, sdk, consoleParameters.myConsoleType, config.getName(), workingDir, consoleParameters.myEnvs, consoleParameters.mySettingsProvider, (Consumer<String>)rerunAction, config, consoleParameters.mySetupFragment);
        if (pydevConsoleWithFileRunnerImpl == null) {
            PydevConsoleRunnerFactory.$$$reportNull$$$0(14);
        }
        return pydevConsoleWithFileRunnerImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunAction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupFragment";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerFactory";
                break;
            }
            case 2: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleRunner";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleRunnerWithFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleParameters";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleRunner";
                break;
            }
            case 2: 
            case 11: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putIPythonEnvFlag";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDir";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleRunnerWithFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createConsoleRunnerWithFile$1";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createConsoleParameters$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class ConsoleParameters {
        @NotNull
        Project myProject;
        @Nullable
        Sdk mySdk;
        @Nullable
        String myWorkingDir;
        @NotNull
        Map<String, String> myEnvs;
        @NotNull
        PyConsoleType myConsoleType;
        @NotNull
        PyConsoleOptions.PyConsoleSettings mySettingsProvider;
        @NotNull
        Consumer<String> myRerunAction;
        @NotNull
        String[] mySetupFragment;

        public ConsoleParameters(@NotNull Project project, @Nullable Sdk sdk, @Nullable String workingDir, @NotNull Map<String, String> envs, @NotNull PyConsoleType consoleType, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull Consumer<String> rerunAction, @NotNull String[] setupFragment) {
            if (project == null) {
                ConsoleParameters.$$$reportNull$$$0(0);
            }
            if (envs == null) {
                ConsoleParameters.$$$reportNull$$$0(1);
            }
            if (consoleType == null) {
                ConsoleParameters.$$$reportNull$$$0(2);
            }
            if (settingsProvider == null) {
                ConsoleParameters.$$$reportNull$$$0(3);
            }
            if (rerunAction == null) {
                ConsoleParameters.$$$reportNull$$$0(4);
            }
            if (setupFragment == null) {
                ConsoleParameters.$$$reportNull$$$0(5);
            }
            this.myProject = project;
            this.mySdk = sdk;
            this.myWorkingDir = workingDir;
            this.myEnvs = envs;
            this.myConsoleType = consoleType;
            this.mySettingsProvider = settingsProvider;
            this.myRerunAction = rerunAction;
            this.mySetupFragment = setupFragment;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "envs";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consoleType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settingsProvider";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rerunAction";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "setupFragment";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/console/PydevConsoleRunnerFactory$ConsoleParameters";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

