/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PyDocumentationSettings")
public class PyDocumentationSettings
implements PersistentStateComponent<PyDocumentationSettings> {
    public static final DocStringFormat DEFAULT_DOCSTRING_FORMAT = DocStringFormat.REST;
    @NotNull
    private DocStringFormat myDocStringFormat = DEFAULT_DOCSTRING_FORMAT;
    private boolean myAnalyzeDoctest = true;
    private boolean myRenderExternalDocumentation;

    public static PyDocumentationSettings getInstance(@NotNull Module module2) {
        if (module2 == null) {
            PyDocumentationSettings.$$$reportNull$$$0(0);
        }
        return (PyDocumentationSettings)ModuleServiceManager.getService((Module)module2, PyDocumentationSettings.class);
    }

    public boolean isNumpyFormat(PsiFile file) {
        return this.isFormat(file, DocStringFormat.NUMPY);
    }

    public boolean isPlain(PsiFile file) {
        return this.isFormat(file, DocStringFormat.PLAIN);
    }

    private boolean isFormat(@Nullable PsiFile file, @NotNull DocStringFormat format) {
        if (format == null) {
            PyDocumentationSettings.$$$reportNull$$$0(1);
        }
        return file instanceof PyFile ? this.getFormatForFile(file) == format : this.myDocStringFormat == format;
    }

    @NotNull
    public DocStringFormat getFormatForFile(@NotNull PsiFile file) {
        DocStringFormat fileFormat;
        if (file == null) {
            PyDocumentationSettings.$$$reportNull$$$0(2);
        }
        DocStringFormat docStringFormat = (fileFormat = PyDocumentationSettings.getFormatFromDocformatAttribute(file)) != null && fileFormat != DocStringFormat.PLAIN ? fileFormat : this.myDocStringFormat;
        if (docStringFormat == null) {
            PyDocumentationSettings.$$$reportNull$$$0(3);
        }
        return docStringFormat;
    }

    @Nullable
    public static DocStringFormat getFormatFromDocformatAttribute(@NotNull PsiFile file) {
        DocStringFormat fileFormat;
        List words;
        String docformat;
        PyTargetExpression expr;
        if (file == null) {
            PyDocumentationSettings.$$$reportNull$$$0(4);
        }
        if (file instanceof PyFile && (expr = ((PyFile)file).findTopLevelAttribute("__docformat__")) != null && (docformat = PyPsiUtils.strValue(expr.findAssignedValue())) != null && (words = StringUtil.split((String)docformat, (String)" ")).size() > 0 && (fileFormat = DocStringFormat.fromName((String)words.get(0))) != null) {
            return fileFormat;
        }
        return null;
    }

    @Transient
    @NotNull
    public DocStringFormat getFormat() {
        DocStringFormat docStringFormat = this.myDocStringFormat;
        if (docStringFormat == null) {
            PyDocumentationSettings.$$$reportNull$$$0(5);
        }
        return docStringFormat;
    }

    public void setFormat(@NotNull DocStringFormat format) {
        if (format == null) {
            PyDocumentationSettings.$$$reportNull$$$0(6);
        }
        this.myDocStringFormat = format;
    }

    @OptionTag(value="myDocStringFormat")
    @NotNull
    public String getFormatName() {
        String string = this.myDocStringFormat.getName();
        if (string == null) {
            PyDocumentationSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void setFormatName(@NotNull String name) {
        if (name == null) {
            PyDocumentationSettings.$$$reportNull$$$0(8);
        }
        this.myDocStringFormat = DocStringFormat.fromNameOrPlain(name);
    }

    public boolean isAnalyzeDoctest() {
        return this.myAnalyzeDoctest;
    }

    public void setAnalyzeDoctest(boolean analyze) {
        this.myAnalyzeDoctest = analyze;
    }

    public boolean isRenderExternalDocumentation() {
        return this.myRenderExternalDocumentation;
    }

    public void setRenderExternalDocumentation(boolean renderExternalDocumentation) {
        this.myRenderExternalDocumentation = renderExternalDocumentation;
    }

    public PyDocumentationSettings getState() {
        return this;
    }

    public void loadState(@NotNull PyDocumentationSettings state2) {
        if (state2 == null) {
            PyDocumentationSettings.$$$reportNull$$$0(9);
        }
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PyDocumentationSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PyDocumentationSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatForFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isFormat";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFormatForFile";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFormatFromDocformatAttribute";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFormat";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setFormatName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

