/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.collect.Maps;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.documentation.docstrings.DocStringLineParser;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.toolbox.Substring;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TagBasedDocString
extends DocStringLineParser
implements StructuredDocString {
    protected final String myDescription;
    protected final Map<String, Substring> mySimpleTagValues;
    protected final Map<String, Map<Substring, Substring>> myArgTagValues;
    private static final Pattern RE_STRICT_TAG_LINE = Pattern.compile("([a-z]+)(\\s+:class:[^:]*|[^:]*)\\s*:\\s*?(.*)");
    private static final Pattern RE_LOOSE_TAG_LINE = Pattern.compile("([a-z]+)\\s+([a-zA-Z_0-9]*)\\s*:?\\s*?([^:]*)");
    private static final Pattern RE_ARG_TYPE = Pattern.compile("(.*?)\\s+([a-zA-Z_0-9]+)");
    public static String[] PARAM_TAGS = new String[]{"param", "parameter", "arg", "argument"};
    public static String[] PARAM_TYPE_TAGS = new String[]{"type"};
    public static String[] VARIABLE_TAGS = new String[]{"ivar", "cvar", "var"};
    public static String[] RAISES_TAGS = new String[]{"raises", "raise", "except", "exception"};
    public static String[] RETURN_TAGS = new String[]{"return", "returns"};
    @NotNull
    private final String myTagPrefix;
    public static String TYPE = "type";

    protected TagBasedDocString(@NotNull Substring docStringText, @NotNull String tagPrefix) {
        if (docStringText == null) {
            TagBasedDocString.$$$reportNull$$$0(0);
        }
        if (tagPrefix == null) {
            TagBasedDocString.$$$reportNull$$$0(1);
        }
        super(docStringText);
        this.mySimpleTagValues = Maps.newHashMap();
        this.myArgTagValues = Maps.newHashMap();
        this.myTagPrefix = tagPrefix;
        StringBuilder builder = new StringBuilder();
        for (int lineno = 0; lineno < this.getLineCount(); ++lineno) {
            Substring line = this.getLine(lineno).trim();
            if (line.startsWith(tagPrefix)) {
                lineno = this.parseTag(lineno, tagPrefix);
                continue;
            }
            builder.append(line.toString()).append("\n");
        }
        this.myDescription = builder.toString();
    }

    public abstract List<String> getAdditionalTags();

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            TagBasedDocString.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String getSummary() {
        List strings = StringUtil.split((String)StringUtil.trimLeading((String)this.myDescription), (String)"\n", (boolean)true, (boolean)false);
        if (strings.size() > 1 && ((String)strings.get(1)).isEmpty()) {
            return (String)strings.get(0);
        }
        return "";
    }

    @NotNull
    private Map<Substring, Substring> getTagValuesMap(String key) {
        LinkedHashMap map2 = this.myArgTagValues.get(key);
        if (map2 == null) {
            map2 = Maps.newLinkedHashMap();
            this.myArgTagValues.put(key, map2);
        }
        LinkedHashMap linkedHashMap = map2;
        if (linkedHashMap == null) {
            TagBasedDocString.$$$reportNull$$$0(3);
        }
        return linkedHashMap;
    }

    protected int parseTag(int lineno, String tagPrefix) {
        Substring lineWithPrefix = this.getLine(lineno).trimLeft();
        if (lineWithPrefix.startsWith(tagPrefix)) {
            Substring line = lineWithPrefix.substring(tagPrefix.length());
            Matcher strictTagMatcher = RE_STRICT_TAG_LINE.matcher(line);
            Matcher looseTagMatcher = RE_LOOSE_TAG_LINE.matcher(line);
            Matcher tagMatcher = null;
            if (strictTagMatcher.matches()) {
                tagMatcher = strictTagMatcher;
            } else if (looseTagMatcher.matches()) {
                tagMatcher = looseTagMatcher;
            }
            if (tagMatcher != null) {
                Substring nextLine;
                Substring tagName = line.getMatcherGroup(tagMatcher, 1);
                Substring argName = line.getMatcherGroup(tagMatcher, 2).trim();
                TextRange firstArgLineRange = line.getMatcherGroup(tagMatcher, 3).trim().getTextRange();
                int linesCount = this.getLineCount();
                int argStart = firstArgLineRange.getStartOffset();
                int argEnd = firstArgLineRange.getEndOffset();
                while (lineno + 1 < linesCount && !(nextLine = this.getLine(lineno + 1).trim()).isEmpty() && !nextLine.startsWith(tagPrefix)) {
                    argEnd = nextLine.getTextRange().getEndOffset();
                    ++lineno;
                }
                Substring argValue = new Substring(argName.getSuperString(), argStart, argEnd);
                String tagNameString = tagName.toString();
                if (argName.isEmpty()) {
                    this.mySimpleTagValues.put(tagNameString, argValue);
                } else {
                    Matcher argTypeMatcher;
                    if (("param".equals(tagNameString) || "parameter".equals(tagNameString) || "arg".equals(tagNameString) || "argument".equals(tagNameString)) && (argTypeMatcher = RE_ARG_TYPE.matcher(argName)).matches()) {
                        Substring argType = argName.getMatcherGroup(argTypeMatcher, 1).trim();
                        argName = argName.getMatcherGroup(argTypeMatcher, 2);
                        this.getTagValuesMap(TYPE).put(argName, argType);
                    }
                    this.getTagValuesMap(tagNameString).put(argName, argValue);
                }
            }
        }
        return lineno;
    }

    protected static List<String> toUniqueStrings(List<?> objects) {
        ArrayList<String> result = new ArrayList<String>(objects.size());
        for (Object o : objects) {
            String s = o.toString();
            if (result.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    @Nullable
    public Substring getTagValue(String ... tagNames) {
        for (String tagName : tagNames) {
            Substring value = this.mySimpleTagValues.get(tagName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Nullable
    public Substring getTagValue(String tagName, @NotNull String argName) {
        Map<Substring, Substring> argValues;
        if (argName == null) {
            TagBasedDocString.$$$reportNull$$$0(4);
        }
        return (argValues = this.myArgTagValues.get(tagName)) != null ? argValues.get(new Substring(argName)) : null;
    }

    @Nullable
    public Substring getTagValue(String[] tagNames, @NotNull String argName) {
        if (argName == null) {
            TagBasedDocString.$$$reportNull$$$0(5);
        }
        for (String tagName : tagNames) {
            Map<Substring, Substring> argValues = this.myArgTagValues.get(tagName);
            Substring key = new Substring(argName);
            if (argValues == null || !argValues.containsKey(key)) continue;
            return argValues.get(key);
        }
        return null;
    }

    public List<Substring> getTagArguments(String ... tagNames) {
        ArrayList<Substring> result = new ArrayList<Substring>();
        for (String tagName : tagNames) {
            Map<Substring, Substring> map2 = this.myArgTagValues.get(tagName);
            if (map2 == null) continue;
            result.addAll(map2.keySet());
        }
        return result;
    }

    @Override
    @NotNull
    public List<Substring> getParameterSubstrings() {
        ArrayList<Substring> results = new ArrayList<Substring>();
        results.addAll(this.getTagArguments(PARAM_TAGS));
        results.addAll(this.getTagArguments(PARAM_TYPE_TAGS));
        ArrayList<Substring> arrayList = results;
        if (arrayList == null) {
            TagBasedDocString.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    protected boolean isBlockEnd(int lineNum) {
        return this.getLine(lineNum).trimLeft().startsWith(this.myTagPrefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docStringText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagPrefix";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/TagBasedDocString";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/TagBasedDocString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagValuesMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterSubstrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTagValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

