/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class PyTrailingBlankLinesPostFormatProcessor
implements PostFormatProcessor {
    private static boolean isApplicableTo(@NotNull PsiFile source) {
        if (source == null) {
            PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(0);
        }
        if (InjectedLanguageManager.getInstance((Project)source.getProject()).isInjectedFragment(source)) {
            return false;
        }
        return source.getLanguage().isKindOf((Language)PythonLanguage.getInstance());
    }

    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        PsiFile psiFile;
        if (source == null) {
            PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(2);
        }
        if (PyTrailingBlankLinesPostFormatProcessor.isApplicableTo(psiFile = source.getContainingFile())) {
            TextRange whitespaceRange = PyTrailingBlankLinesPostFormatProcessor.findTrailingWhitespacesRange(psiFile);
            if (source.getTextRange().intersects(whitespaceRange)) {
                PyTrailingBlankLinesPostFormatProcessor.replaceOrDeleteTrailingWhitespaces(psiFile, whitespaceRange);
            }
        }
        return source;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(3);
        }
        if (rangeToReformat == null) {
            PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(5);
        }
        if (!PyTrailingBlankLinesPostFormatProcessor.isApplicableTo(source)) {
            TextRange textRange = rangeToReformat;
            if (textRange == null) {
                PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        TextRange oldWhitespaceRange = PyTrailingBlankLinesPostFormatProcessor.findTrailingWhitespacesRange(source);
        if (rangeToReformat.intersects(oldWhitespaceRange)) {
            TextRange newWhitespaceRange = PyTrailingBlankLinesPostFormatProcessor.replaceOrDeleteTrailingWhitespaces(source, oldWhitespaceRange);
            TextRange textRange = rangeToReformat.grown(oldWhitespaceRange.getLength() - newWhitespaceRange.getLength());
            if (textRange == null) {
                PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(7);
            }
            return textRange;
        }
        TextRange textRange = rangeToReformat;
        if (textRange == null) {
            PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    @NotNull
    private static TextRange findTrailingWhitespacesRange(@NotNull PsiFile file) {
        char c;
        int start;
        if (file == null) {
            PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(9);
        }
        CharSequence contents = file.getViewProvider().getContents();
        boolean lineFeedNext = false;
        for (start = contents.length() - 1; start >= 0 && (" \t\f\n\r".indexOf(c = contents.charAt(start)) >= 0 || c == '\\' && (lineFeedNext || start == contents.length() - 1)); --start) {
            lineFeedNext = c == '\n';
        }
        TextRange textRange = new TextRange(start + 1, contents.length());
        if (textRange == null) {
            PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(10);
        }
        return textRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static TextRange replaceOrDeleteTrailingWhitespaces(@NotNull PsiFile pyFile, @NotNull TextRange whitespaceRange) {
        PsiDocumentManager documentManager;
        Document document;
        String desiredWhitespace;
        if (pyFile == null) {
            PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(11);
        }
        if (whitespaceRange == null) {
            PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(12);
        }
        PyCodeStyleSettings customSettings = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)pyFile, PyCodeStyleSettings.class);
        boolean addLineFeed = customSettings.BLANK_LINE_AT_FILE_END || EditorSettingsExternalizable.getInstance().isEnsureNewLineAtEOF();
        String realWhitespace = whitespaceRange.substring(pyFile.getText());
        String string = desiredWhitespace = addLineFeed ? "\n" : "";
        if (!realWhitespace.equals(desiredWhitespace) && (desiredWhitespace.isEmpty() || whitespaceRange.getStartOffset() != 0) && (document = (documentManager = PsiDocumentManager.getInstance((Project)pyFile.getProject())).getDocument(pyFile)) != null) {
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            document.replaceString(whitespaceRange.getStartOffset(), whitespaceRange.getEndOffset(), (CharSequence)desiredWhitespace);
            TextRange textRange = TextRange.from((int)whitespaceRange.getStartOffset(), (int)desiredWhitespace.length());
            TextRange textRange2 = textRange;
            if (textRange2 == null) {
                PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(13);
            }
            return textRange2;
            finally {
                documentManager.commitDocument(document);
            }
        }
        TextRange textRange = whitespaceRange;
        if (textRange == null) {
            PyTrailingBlankLinesPostFormatProcessor.$$$reportNull$$$0(14);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/formatter/PyTrailingBlankLinesPostFormatProcessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whitespaceRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/formatter/PyTrailingBlankLinesPostFormatProcessor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findTrailingWhitespacesRange";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceOrDeleteTrailingWhitespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findTrailingWhitespacesRange";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceOrDeleteTrailingWhitespaces";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

